/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServTypeIPMode;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLink;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetAddressType;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.tree.BGUCheckTree;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.service.EntityService;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;

public class InetServTypePanel
extends BGUPanel {
    private InetDeviceService inetDeviceService = null;
    private InetServService inetServService = null;
    private InetServTypeTableModel model = new InetServTypeTableModel();

    public InetServTypePanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetServTypePanel.this.model.setData(InetServTypePanel.this.getInetServService().inetServTypeList());
            }
        };
    }

    private InetServService getInetServService() {
        if (this.inetServService == null) {
            this.inetServService = (InetServService)((ClientContext)this.getContext()).getPort(InetServService.class);
        }
        return this.inetServService;
    }

    private InetDeviceService getInetDeviceService() {
        if (this.inetDeviceService == null) {
            this.inetDeviceService = (InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class);
        }
        return this.inetDeviceService;
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        BGEditor editor = new BGEditor();
        editor.setVisible(false);
        editor.addForm((JComponent)((Object)new InetServTypeForm()));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), "Center");
        this.add((Component)editor, "South");
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)editor);
    }

    class InetServTypeTableModel
    extends BGTableModel<InetServType> {
        public InetServTypeTableModel() {
            super(InetServTypeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class InetServTypeForm
    extends BGUPanel {
        private BGTextField title;
        private BGUComboBox<TrafficTypeLink> trafficTypeLink;
        private BGUComboBox<IdTitle> sessionInitiationType;
        private BGUComboBox<IdTitle> sessionCountLimit;
        private JCheckBox sessionCountLimitLock;
        private JTabbedPane addressTabbedPane;
        private BGUComboBox<IdTitle> addressType;
        private JCheckBox addressAllInterface;
        private IpPanel addressIPv4Panel;
        private IpPanel addressIPv6Panel;
        private BGUComboBox<EntitySpec> entitySpec;
        private BGUCheckList<InetDeviceType> deviceType;
        private BGUCheckTree<DeviceGroup> deviceGroup;
        private BGUCheckList<InetServType> childrenType;
        private JCheckBox needLogin;
        private JCheckBox needDevice;
        private JCheckBox needInterface;
        private JCheckBox personalInterface;
        private JCheckBox vlanPersonal;
        private JCheckBox vlanNeed;
        private JCheckBox vlanNull;
        private JCheckBox needIdentifier;
        private JCheckBox needMacAddress;
        private JCheckBox needRestriction;
        private JCheckBox needContractObject;
        private BGConfigEditorPane config;
        private InetServType current;
        private JCheckBox ipFromParentRange;

        public InetServTypeForm() {
            super((LayoutManager)new GridBagLayout());
            this.addressTabbedPane = new JTabbedPane();
            this.addressIPv4Panel = new IpPanel();
            this.addressIPv6Panel = new IpPanel();
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetServTypeForm.this.current = new InetServType();
                    InetServTypeForm.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetServTypeForm.this.current = (InetServType)InetServTypePanel.this.model.getSelectedRow();
                    if (InetServTypeForm.this.current != null) {
                        InetServTypeForm.this.performActionOpen();
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    JSONObject jsonData = new JSONObject(InetServTypeForm.this.current.getData() == null || !InetServTypeForm.this.current.getData().startsWith("{") ? "{}" : InetServTypeForm.this.current.getData());
                    jsonData.put("ipv4", (Object)InetServTypeForm.this.addressIPv4Panel.getInfo());
                    jsonData.put("ipv6", (Object)InetServTypeForm.this.addressIPv6Panel.getInfo());
                    InetServTypeForm.this.current.setTitle(InetServTypeForm.this.title.getText());
                    InetServTypeForm.this.current.setSessionCountLimit(((IdTitle)InetServTypeForm.this.sessionCountLimit.getSelectedItem()).getId());
                    InetServTypeForm.this.current.setSessionCountLimitLock(InetServTypeForm.this.sessionCountLimitLock.isSelected());
                    InetServTypeForm.this.current.setSessionInitiationType(((IdTitle)InetServTypeForm.this.sessionInitiationType.getSelectedItem()).getId());
                    InetServTypeForm.this.current.setAddressType(InetAddressType.getInetAddressType((int)(InetServTypeForm.this.addressType.getSelectedItem() == null ? 0 : ((IdTitle)InetServTypeForm.this.addressType.getSelectedItem()).getId())));
                    InetServTypeForm.this.current.setAddressAllInterface(InetServTypeForm.this.addressAllInterface.isSelected());
                    InetServTypeForm.this.current.setData(jsonData.toString());
                    InetServTypeForm.this.current.setAddressAllInterface(InetServTypeForm.this.addressIPv4Panel.addressAllInterface.isSelected());
                    if (InetServTypeForm.this.trafficTypeLink.getSelectedItem() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0443 \u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u0444\u0438\u043a\u0430");
                        return;
                    }
                    InetServTypeForm.this.current.setTrafficTypeLinkId(((TrafficTypeLink)InetServTypeForm.this.trafficTypeLink.getSelectedItem()).getId());
                    InetServTypeForm.this.current.setDeviceTypeIds(InetServTypeForm.this.deviceType.getSelectedIds());
                    InetServTypeForm.this.current.setParentTypeIds(InetServTypeForm.this.childrenType.getSelectedIds());
                    InetServTypeForm.this.current.setDeviceGroupIds(InetServTypeForm.this.deviceGroup.getChecked());
                    InetServTypeForm.this.current.setNeedLogin(InetServTypeForm.this.needLogin.isSelected());
                    InetServTypeForm.this.current.setNeedDevice(InetServTypeForm.this.needDevice.isSelected());
                    InetServTypeForm.this.current.setNeedInterface(InetServTypeForm.this.needInterface.isSelected());
                    InetServTypeForm.this.current.setPersonalInterface(InetServTypeForm.this.personalInterface.isSelected());
                    InetServTypeForm.this.current.setPersonalVlan(InetServTypeForm.this.vlanPersonal.isSelected());
                    InetServTypeForm.this.current.setNeedVlan(InetServTypeForm.this.vlanNeed.isSelected());
                    InetServTypeForm.this.current.setNullVlan(InetServTypeForm.this.vlanNull.isSelected());
                    InetServTypeForm.this.current.setNeedIdentifier(InetServTypeForm.this.needIdentifier.isSelected());
                    InetServTypeForm.this.current.setNeedMacAddress(InetServTypeForm.this.needMacAddress.isSelected());
                    InetServTypeForm.this.current.setNeedContractObject(InetServTypeForm.this.needContractObject.isSelected());
                    InetServTypeForm.this.current.setNeedRestriction(InetServTypeForm.this.needRestriction.isSelected());
                    InetServTypeForm.this.current.setConfig(InetServTypeForm.this.config.getText());
                    InetServTypeForm.this.current.setIpFromParentRange(InetServTypeForm.this.ipFromParentRange.isSelected());
                    InetServTypeForm.this.current.setEntitySpecId(((EntitySpec)InetServTypeForm.this.entitySpec.getSelectedItem()).getId());
                    int id = InetServTypePanel.this.getInetServService().inetServTypeUpdate(InetServTypeForm.this.current);
                    InetServTypeForm.this.performActionClose();
                    InetServTypePanel.this.performAction("refresh");
                    InetServTypePanel.this.model.setSelectedRow(id);
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetServTypeForm.this.current = (InetServType)InetServTypePanel.this.model.getSelectedRow();
                    if (InetServTypeForm.this.current != null && BGSwingUtilites.confirmDelete((String)"InetServ", (Object)InetServTypeForm.this.current)) {
                        InetServTypePanel.this.getInetServService().inetServTypeDelete(InetServTypeForm.this.current.getId());
                        InetServTypeForm.this.performActionClose();
                        InetServTypePanel.this.performAction("refresh");
                    }
                }
            };
        }

        public void performActionOpen() {
            try {
                JSONObject jsonData = new JSONObject(this.current.getData() == null || !this.current.getData().startsWith("{") ? "{}" : this.current.getData());
                this.trafficTypeLink.setData(InetServTypePanel.this.getInetServService().trafficTypeLinkList());
                this.trafficTypeLink.insertItemAt((Object)new TrafficTypeLink(0, "\u043d\u0435\u0442"), 0);
                this.trafficTypeLink.setSelectedIndex(0);
                this.deviceType.setData(InetServTypePanel.this.getInetDeviceService().deviceTypeList());
                this.deviceType.setSelected((Collection)this.current.getDeviceTypeIds());
                this.deviceGroup.setData((Id)InetServTypePanel.this.getInetDeviceService().deviceGroupRoot(), this.current.getDeviceGroupIds());
                this.childrenType.setData(InetServTypePanel.this.getInetServService().inetServTypeList());
                this.childrenType.setSelected((Collection)this.current.getParentTypeIds());
                this.title.setText(this.current.getTitle());
                this.sessionInitiationType.setSelectedItem((Object)this.current.getSessionInitiationType());
                this.sessionCountLimit.setSelectedItem((Object)this.current.getSessionCountLimit());
                this.sessionCountLimitLock.setSelected(this.current.isSessionCountLimitLock());
                this.addressTabbedPane.setSelectedIndex(0);
                this.addressIPv4Panel.setInfo(new InetServTypeIPMode(jsonData.optJSONObject("ipv4")));
                this.addressIPv6Panel.setInfo(new InetServTypeIPMode(jsonData.optJSONObject("ipv6")));
                this.addressType.setSelectedItem((Object)(this.current.getAddressType() == null ? InetAddressType.OFF.getCode() : this.current.getAddressType().getCode()));
                this.addressAllInterface.setSelected(this.current.isAddressAllInterface());
                this.trafficTypeLink.setSelectedItem((Object)this.current.getTrafficTypeLinkId());
                this.entitySpec.setSelectedItem((Object)this.current.getEntitySpecId());
                this.needLogin.setSelected(this.current.isNeedLogin());
                this.needDevice.setSelected(this.current.isNeedDevice());
                this.needInterface.setSelected(!this.current.isNeedInterface());
                this.needInterface.setSelected(this.current.isNeedInterface());
                this.personalInterface.setSelected(this.current.isPersonalInterface());
                this.vlanPersonal.setSelected(this.current.isPersonalVlan());
                this.vlanNeed.setSelected(!this.current.isNeedVlan());
                this.vlanNeed.setSelected(this.current.isNeedVlan());
                this.vlanNull.setSelected(this.current.isNullVlan());
                this.needIdentifier.setSelected(this.current.isNeedIdentifier());
                this.needMacAddress.setSelected(this.current.isNeedMacAddress());
                this.needContractObject.setSelected(this.current.isNeedContractObject());
                this.needRestriction.setSelected(this.current.isNeedRestriction());
                this.ipFromParentRange.setSelected(this.current.isIpFromParentRange());
                this.config.setText(this.current.getConfig());
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            super.performActionOpen();
        }

        protected void jbInit() {
            BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ");
            this.deviceType = new BGUCheckList();
            this.deviceGroup = new BGUCheckTree(DeviceGroup.class);
            this.childrenType = new BGUCheckList();
            this.config = new BGConfigEditorPane();
            Dimension dimension = new Dimension(800, 400);
            JScrollPane scrollPane = new JScrollPane((Component)this.config);
            scrollPane.setPreferredSize(dimension);
            scrollPane.setMaximumSize(dimension);
            JTabbedPane pane = new JTabbedPane();
            pane.add((Component)this.panelWrap(scrollPane), "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
            pane.add((Component)this.panelWrap((JComponent)this.deviceType), "\u0422\u0438\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432");
            pane.add((Component)this.panelWrap(new JScrollPane((Component)this.deviceGroup)), "\u0413\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432");
            pane.add((Component)this.panelWrap((JComponent)this.childrenType), "\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u0442\u0438\u043f\u044b");
            this.add(this.getParameterPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.getCheckPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 3, 0), 0, 0));
            this.add(pane, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.needInterface.addChangeListener(e -> this.personalInterface.setEnabled(this.needInterface.isSelected()));
            this.vlanNeed.addChangeListener(e -> {
                this.vlanPersonal.setEnabled(this.vlanNeed.isSelected());
                this.vlanNull.setEnabled(this.vlanNeed.isSelected());
            });
        }

        private JPanel getParameterPanel() {
            ArrayList<IdTitle> sessionInitiationTypeData = new ArrayList<IdTitle>();
            sessionInitiationTypeData.add(new IdTitle(0, "\u043f\u043e \u0441\u0438\u0433\u043d\u0430\u043b\u0443 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, RADIUS \u0438\u043b\u0438 DHCP)"));
            sessionInitiationTypeData.add(new IdTitle(1, "\u043f\u043e \u0442\u0440\u0430\u0444\u0438\u043a\u0443 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, Netflow, sFlow \u0438\u043b\u0438 SNMP)"));
            ArrayList<IdTitle> data = new ArrayList<IdTitle>();
            data.add(new IdTitle(0, "\u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e"));
            for (int i = 1; i <= 30; ++i) {
                data.add(new IdTitle(i, String.valueOf(i)));
            }
            this.entitySpec = new BGUComboBox();
            try {
                List entitySpecList = ((EntityService)((ClientContext)this.getContext()).getPort(EntityService.class, 0)).entitySpecList();
                EntitySpec nullEntitySpec = new EntitySpec();
                nullEntitySpec.setTitle(" --- ");
                entitySpecList.add(0, nullEntitySpec);
                this.entitySpec.setData(entitySpecList);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            this.title = new BGTextField();
            this.sessionInitiationType = new BGUComboBox();
            this.sessionInitiationType.setData(sessionInitiationTypeData);
            this.sessionCountLimit = new BGUComboBox();
            this.sessionCountLimit.setData(data);
            this.sessionCountLimitLock = new JCheckBox("\u043d\u0435\u0438\u0437\u043c\u0435\u043d\u043d\u043e");
            this.trafficTypeLink = new BGUComboBox();
            this.addressTabbedPane.add("IPv4", this.addressIPv4Panel);
            this.addressTabbedPane.add("IPv6", this.addressIPv6Panel);
            this.addressTabbedPane.add("\u0422\u0438\u043f \u0430\u0434\u0440\u0435\u0441\u0430 (\u0443\u0441\u0442\u0430\u0440\u0435\u043b\u043e)", this.getAddressTypePanel());
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0422\u0438\u043f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 (\u0441\u0442\u0430\u0440\u0442\u0430) \u0441\u0435\u0441\u0441\u0438\u0438:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.sessionInitiationType, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043b-\u0432\u043e \u0441\u0435\u0441\u0441\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.sessionCountLimit, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.sessionCountLimitLock, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.addressTabbedPane, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u0442\u0440\u0430\u0444\u0438\u043a\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.trafficTypeLink, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.entitySpec, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getAddressTypePanel() {
            ArrayList<IdTitle> addressTypeData = new ArrayList<IdTitle>();
            addressTypeData.add(new IdTitle(InetAddressType.OFF.getCode(), "=== \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e ==="));
            addressTypeData.add(new IdTitle(InetAddressType.NONE.getCode(), "\u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0442\u044c \u0430\u0434\u0440\u0435\u0441"));
            addressTypeData.add(new IdTitle(InetAddressType.NONE_OR_SINGLE.getCode(), "\u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0442\u044c \u0438\u043b\u0438 \u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441"));
            addressTypeData.add(new IdTitle(InetAddressType.RANGE.getCode(), "\u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
            addressTypeData.add(new IdTitle(InetAddressType.NET.getCode(), "\u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u0435\u0442\u044c"));
            addressTypeData.add(new IdTitle(InetAddressType.SINGLE_IPV4.getCode(), "\u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 (IPv4)"));
            addressTypeData.add(new IdTitle(InetAddressType.IPV6.getCode(), "\u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 (IPv6)"));
            addressTypeData.add(new IdTitle(InetAddressType.DYNAMIC.getCode(), "\u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441"));
            addressTypeData.add(new IdTitle(InetAddressType.DYNAMIC_OR_SINGLE.getCode(), "\u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0438\u043b\u0438 \u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441"));
            addressTypeData.add(new IdTitle(InetAddressType.DYNAMIC_OR_RANGE.getCode(), "\u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 \u0438\u043b\u0438 \u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
            this.addressAllInterface = new JCheckBox("\u0432\u0435\u0441\u044c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
            this.addressAllInterface.addActionListener(e -> {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "<html>\u0415\u0441\u043b\u0438 \u0433\u0430\u043b\u043e\u0447\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430, \u0442\u043e \u0432\u0435\u0441\u044c (Netflow/sFlow) \u0442\u0440\u0430\u0444\u0438\u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043f\u043e\u043f\u0430\u0434\u0430\u0435\u0442 \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441, \u043d\u0435 \u0443\u0447\u0438\u0442\u044b\u0432\u0430\u044f<br>\u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d/\u043f\u043e\u0434\u0441\u0435\u0442\u044c \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435. \u041f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043d\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u043c \u0442\u0438\u043f\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a InetAccounting.<br>\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440?</html>", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) != 0) {
                    if (this.current != null) {
                        this.addressAllInterface.setSelected(this.current.isAddressAllInterface());
                    } else {
                        this.addressAllInterface.setSelected(false);
                    }
                }
            });
            this.addressAllInterface.setToolTipText("<html>\u0415\u0441\u043b\u0438 \u0433\u0430\u043b\u043e\u0447\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430, \u0442\u043e \u0432\u0435\u0441\u044c (Netflow/sFlow) \u0442\u0440\u0430\u0444\u0438\u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430<br>\u043f\u043e\u043f\u0430\u0434\u0430\u0435\u0442 \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441, \u043d\u0435 \u0443\u0447\u0438\u0442\u044b\u0432\u0430\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d/\u043f\u043e\u0434\u0441\u0435\u0442\u044c \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435.</html>");
            this.addressType = new BGUComboBox();
            this.addressType.setData(addressTypeData);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.addressType, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.addressAllInterface, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 3, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getCheckPanel() {
            this.needLogin = new JCheckBox("\u043b\u043e\u0433\u0438\u043d + \u043f\u0430\u0440\u043e\u043b\u044c");
            this.needDevice = new JCheckBox("\u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            this.needInterface = new JCheckBox("\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
            this.personalInterface = new JCheckBox("\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u0435\u043d");
            this.vlanNeed = new JCheckBox("VLAN");
            this.vlanNull = new JCheckBox("VLAN \u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d");
            this.vlanPersonal = new JCheckBox("VLAN \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u0435\u043d");
            this.needIdentifier = new JCheckBox("\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440");
            this.needMacAddress = new JCheckBox("MAC-\u0430\u0434\u0440\u0435\u0441");
            this.needContractObject = new JCheckBox("\u043e\u0431\u044a\u0435\u043a\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            this.needRestriction = new JCheckBox("\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f");
            this.ipFromParentRange = new JCheckBox("IP \u0438\u0437 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.needLogin, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needDevice, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needInterface, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.personalInterface, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.vlanNeed, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.vlanPersonal, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.vlanNull, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needMacAddress, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needIdentifier, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needContractObject, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needRestriction, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.ipFromParentRange, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel panelWrap(JComponent panel) {
            JPanel result = new JPanel(new GridBagLayout());
            result.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return result;
        }
    }

    class IpPanel
    extends JPanel {
        private boolean allInterface;
        private JCheckBox selectNo;
        private JCheckBox selectStatic;
        private JCheckBox selectDynamic;
        private BGUComboBox<IdTitle> netMode;
        private JCheckBox addressAllInterface;
        private DynamicClassChooser ipClass;

        public IpPanel() {
            super(new GridBagLayout());
            this.allInterface = false;
            this.selectNo = new JCheckBox("\u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0442\u044c");
            this.selectStatic = new JCheckBox("\u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439");
            this.selectDynamic = new JCheckBox("\u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439");
            this.netMode = new BGUComboBox();
            this.addressAllInterface = new JCheckBox("\u0432\u0435\u0441\u044c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
            this.ipClass = new DynamicClassChooser(true);
            this.addressAllInterface.setToolTipText("<html>\u0415\u0441\u043b\u0438 \u0433\u0430\u043b\u043e\u0447\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430, \u0442\u043e \u0432\u0435\u0441\u044c (Netflow/sFlow) \u0442\u0440\u0430\u0444\u0438\u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430<br>\u043f\u043e\u043f\u0430\u0434\u0430\u0435\u0442 \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441, \u043d\u0435 \u0443\u0447\u0438\u0442\u044b\u0432\u0430\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d/\u043f\u043e\u0434\u0441\u0435\u0442\u044c \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435.</html>");
            this.addressAllInterface.addActionListener(e -> {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "<html>\u0415\u0441\u043b\u0438 \u0433\u0430\u043b\u043e\u0447\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430, \u0442\u043e \u0432\u0435\u0441\u044c (Netflow/sFlow) \u0442\u0440\u0430\u0444\u0438\u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043f\u043e\u043f\u0430\u0434\u0430\u0435\u0442 \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441, \u043d\u0435 \u0443\u0447\u0438\u0442\u044b\u0432\u0430\u044f<br>\u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d/\u043f\u043e\u0434\u0441\u0435\u0442\u044c \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435. \u041f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043d\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u043c \u0442\u0438\u043f\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a InetAccounting.<br>\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440?</html>", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) != 0) {
                    this.addressAllInterface.setSelected(this.allInterface);
                }
            });
            ArrayList<IdTitle> netModeData = new ArrayList<IdTitle>();
            netModeData.add(new IdTitle(0, "\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e"));
            netModeData.add(new IdTitle(1, "\u0441\u0435\u0442\u044c"));
            netModeData.add(new IdTitle(2, "\u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
            this.netMode.setData(netModeData);
            try {
                JSONObject json = new JSONObject(InetServTypePanel.this.getInetServService().inetServTypeIpClass());
                String iface = json.optString("iface");
                this.ipClass.setIfaceName(iface);
                this.ipClass.setSuperclassName(json.optString("superClass"));
                this.ipClass.setDerivingIfaces(Collections.singleton(iface));
            }
            catch (Exception e2) {
                ClientUtils.showErrorMessageDialog((Throwable)e2);
            }
            this.add((Component)new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430:"), new GridBagConstraints(-1, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.ipClass, new GridBagConstraints(-1, 1, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectStatic, new GridBagConstraints(-1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.selectDynamic, new GridBagConstraints(-1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.selectNo, new GridBagConstraints(-1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.netMode, new GridBagConstraints(-1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.addressAllInterface, new GridBagConstraints(-1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        }

        public void setInfo(InetServTypeIPMode info) {
            this.ipClass.performAction("refresh");
            this.ipClass.setSelectedItem(info.getIpHandlerClassName());
            this.selectNo.setSelected(info.isSelectNo());
            this.selectStatic.setSelected(info.isSelectStatic());
            this.selectDynamic.setSelected(info.isSelectDynamic());
            this.netMode.setSelectedItem((Object)info.getNetMode());
            this.addressAllInterface.setSelected(info.isAddressAllInterface());
        }

        public JSONObject getInfo() {
            JSONObject jsonInfo = new JSONObject();
            jsonInfo.put("ipHandler", (Object)this.ipClass.getSelectedClass());
            jsonInfo.put("ipNo", this.selectNo.isSelected());
            jsonInfo.put("ipStatic", this.selectStatic.isSelected());
            jsonInfo.put("ipDynamic", this.selectDynamic.isSelected());
            jsonInfo.put("netMode", ((IdTitle)this.netMode.getSelectedItem()).getId());
            jsonInfo.put("addressAllInterface", this.addressAllInterface.isSelected());
            return jsonInfo;
        }
    }
}

