/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.server.action;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.im.common.IMUtils;
import ru.bitel.bgbilling.plugins.im.server.action.ActionBase;

public class ActionGetRoster
extends ActionBase {
    int availableContactCount = 0;
    int totalAvailableEntryCount = 0;
    int totalEntryCount = 0;

    public void doAction() throws SQLException, BGException {
        Element elgroup;
        XMPPConnection connection = this.getXMPPConnection();
        if (connection == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Roster roster = connection.getRoster();
        Element elroster = this.createElement(this.rootNode, "roster");
        Collection groups = roster.getGroups();
        for (Object group : groups) {
            elgroup = this.createElement(elroster, "group");
            elgroup.setAttribute("name", group.getName());
            elgroup.setAttribute("EntryCount", String.valueOf(group.getEntryCount()));
            this.totalEntryCount += group.getEntryCount();
            this.availableContactCount = 0;
            Collection entrys = group.getEntries();
            for (RosterEntry entry : entrys) {
                this.availableContactCount += this.makeEntryXml(entry, elgroup, roster);
            }
            elgroup.setAttribute("AvailableEntryCount", String.valueOf(this.availableContactCount));
            this.totalAvailableEntryCount += this.availableContactCount;
        }
        if (roster.getUnfiledEntryCount() > 0) {
            elgroup = this.createElement(elroster, "group");
            elgroup.setAttribute("name", "General");
            elgroup.setAttribute("EntryCount", String.valueOf(roster.getUnfiledEntryCount()));
            this.totalEntryCount += roster.getUnfiledEntryCount();
            this.availableContactCount = 0;
            Collection entrys = roster.getUnfiledEntries();
            for (RosterEntry entry : entrys) {
                this.availableContactCount += this.makeEntryXml(entry, elgroup, roster);
            }
            elgroup.setAttribute("AvailableEntryCount", String.valueOf(this.availableContactCount));
            this.totalAvailableEntryCount += this.availableContactCount;
        }
        elroster.setAttribute("user", connection.getUser());
        String selfEntryName = IMUtils.getLoginFromJID((String)connection.getUser());
        elroster.setAttribute("name", selfEntryName);
        elroster.setAttribute("EntryCount", String.valueOf(this.totalEntryCount));
        elroster.setAttribute("AvailableEntryCount", String.valueOf(this.totalAvailableEntryCount));
        Iterator presences = roster.getPresences(connection.getUser());
        this.availableContactCount = 0;
        int contactCount = 0;
        elgroup = this.createElement(elroster, "group");
        elgroup.setAttribute("name", "Self");
        while (presences.hasNext()) {
            Presence presence = (Presence)presences.next();
            Element elentry = this.createElement(elgroup, "entry");
            this.makePresenceXml(presence, elentry);
            elentry.setAttribute("name", selfEntryName);
            if (presence.isAvailable()) {
                ++this.availableContactCount;
            }
            ++contactCount;
        }
        elgroup.setAttribute("AvailableEntryCount", String.valueOf(this.availableContactCount));
        elgroup.setAttribute("EntryCount", String.valueOf(contactCount));
        List<ActionBase.RosterListenerItem> rosterListenerItemListOrig = this.getRosterListenerItemList();
        rosterListenerItemListOrig.clear();
    }
}

