/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.client.load;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.fias.client.load.LoadManager;
import ru.bitel.bgbilling.plugins.fias.common.bean.Region;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.City;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.Street;
import ru.bitel.bgbilling.plugins.fias.common.service.FiasService;
import ru.bitel.common.model.Result;

public class LoadPanelStreet
extends JPanel {
    private JList<Street> streetCompare = new JList();
    private BGTextField oldStreetTitle = new BGTextField();
    private BGButton commitStreet = null;
    private BGButton ignoreStreet = null;
    private Street oldStreet = null;
    private LoadManager parentPanel;

    public LoadPanelStreet(LoadManager parentPanel) {
        this.parentPanel = parentPanel;
        this.oldStreetTitle = new BGTextField();
        this.oldStreetTitle.setEditable(false);
        this.streetCompare = new JList();
        this.streetCompare.setModel(new DefaultListModel());
        this.streetCompare.setSelectionMode(0);
        this.commitStreet = new BGButton("\u041f\u0440\u0438\u043d\u044f\u0442\u044c \u0443\u043b\u0438\u0446\u0443");
        this.commitStreet.setActionCommand("commit");
        this.commitStreet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadPanelStreet.this.netxStreet(actionEvent);
            }
        });
        this.ignoreStreet = new BGButton("\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u0443");
        this.ignoreStreet.setActionCommand("ignore");
        this.ignoreStreet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadPanelStreet.this.netxStreet(actionEvent);
            }
        });
        JScrollPane scrollPanel = new JScrollPane(this.streetCompare);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("\u0421\u0442\u0430\u0440\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.oldStreetTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)scrollPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.commitStreet, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.ignoreStreet, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void startStreetLoad() {
        try {
            City city = this.parentPanel.loadPanelStart.fiasCityList.getSelectedValue();
            city.setId(this.parentPanel.loadPanelStart.cityList.getSelectedValue().getId());
            String regionId = ((Region)this.parentPanel.loadPanelStart.regions.getSelectedItem()).getNumber();
            Result result = ((FiasService)((ClientContext)this.parentPanel.getContext()).getPort(FiasService.class)).startSync(regionId, city, false);
            Boolean inProcess = (Boolean)result.getAttribute("loadInProgress");
            if (inProcess.booleanValue() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u044f \u0443\u0436\u0435 \u043d\u0430\u0447\u0430\u0442\u0430, \u041d\u0430\u0447\u0430\u0442\u044c \u0437\u0430\u043d\u043e\u0432\u043e?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1) == 0) {
                ((FiasService)((ClientContext)this.parentPanel.getContext()).getPort(FiasService.class)).startSync(regionId, city, true);
            }
            this.getNextStreet(null);
        }
        catch (BGMessageException e) {
            this.loadIsDone();
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443");
            e.printStackTrace();
        }
    }

    private void getNextStreet(Street street) throws BGMessageException, BGException {
        this.oldStreetTitle.setText("\u0418\u0434\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430....");
        this.streetCompare.setListData((Street[])new Street[0]);
        int cityId = this.parentPanel.loadPanelStart.cityList.getSelectedValue().getId();
        Result result = ((FiasService)((ClientContext)this.parentPanel.getContext()).getPort(FiasService.class)).streetSync(cityId, street);
        List streetList = result.getList();
        this.oldStreet = (Street)result.getAttribute("street");
        if (streetList.size() != 0) {
            this.oldStreetTitle.setText(this.oldStreet.getBgTitle());
            this.streetCompare.setListData(new Vector(streetList));
        } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u043b\u0438\u0446\u0430 " + this.oldStreet.getBgTitle() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0424\u0418\u0410\u0421", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 1) {
            this.getNextStreet(null);
        } else {
            this.ignoreStreet.doClick();
        }
    }

    private void netxStreet(ActionEvent event) {
        try {
            if (event.getActionCommand().equals("ignore")) {
                this.oldStreet.setShortname("-1");
                this.oldStreet.setOffname(this.oldStreet.getBgTitle());
                this.oldStreet.setCode("-1");
                this.oldStreet.setAoguid("-1");
                this.oldStreet.setLevel("-1");
                this.oldStreet.setPostalcode("-1");
            } else {
                Street newStreet = this.streetCompare.getSelectedValue();
                if (newStreet == null) {
                    JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u0443\u043b\u0438\u0446\u044b " + this.oldStreet.getBgTitle() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0424\u0418\u0410\u0421", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                    return;
                }
                this.oldStreet.setStreet(newStreet);
            }
            this.getNextStreet(this.oldStreet);
        }
        catch (BGMessageException e) {
            this.loadIsDone();
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443");
            e.printStackTrace();
        }
    }

    private void loadIsDone() {
        try {
            City city;
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0430\u0434\u0440\u0435\u0441\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u044b!!!!!!!! \u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435 \u0432 \u0431\u0438\u043b\u0438\u043d\u0433\u0435 \u0443\u043b\u0438\u0446\u044b", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1) == 0 && (city = this.parentPanel.loadPanelStart.fiasCityList.getSelectedValue()) != null) {
                ((FiasService)((ClientContext)this.parentPanel.getContext()).getPort(FiasService.class)).loadAllStreet(city);
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443");
        }
        this.parentPanel.cardLayout.show(this.parentPanel.panelSync, "startPanel");
    }
}

