/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.EmailServiceActivator;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;
import ru.bitel.common.ParameterMap;

public class JDBCEmailServiceActivator
extends EmailServiceActivator {
    private static Map<Reference, SoftReference<DataSource>> dataSourceMap = Collections.synchronizedMap(new HashMap());
    private Domain domain;
    private ParameterMap moduleSetup;
    private Connection con;

    public JDBCEmailServiceActivator(Domain domain, ParameterMap moduleSetup) throws BGException {
        this.domain = domain;
        this.moduleSetup = moduleSetup;
        ParameterMap params = this.domain.getParameterMap().inherit(moduleSetup).sub("sa.jdbc.");
        String url = params.get("url", null);
        try {
            DataSource dataSource;
            Reference ref = new Reference(url);
            params.toReference(ref);
            SoftReference<DataSource> dataSourceRef = dataSourceMap.get(ref);
            DataSource dataSource2 = dataSource = dataSourceRef != null ? dataSourceRef.get() : null;
            if (dataSource == null) {
                String driverClass = params.get("driver", null);
                String user = params.get("user", null);
                String pswd = params.get("password", null);
                if (driverClass != null) {
                    try {
                        Class.forName(driverClass);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                GenericObjectPool connectionPool = new GenericObjectPool(null);
                DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, user, pswd);
                new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, "SELECT 1", false, true);
                connectionPool.setMaxIdle(10);
                connectionPool.setMaxActive(100);
                connectionPool.setTestOnBorrow(true);
                connectionPool.setTestOnReturn(true);
                dataSource = new PoolingDataSource((ObjectPool)connectionPool);
                dataSourceMap.put(ref, new SoftReference<DataSource>(dataSource));
            }
            this.con = dataSource.getConnection();
            this.con.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new BGException("Can't connect to " + params.get("url", null), (Throwable)e);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.con = null;
    }

    protected void finalize() throws Throwable {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    @Override
    protected void createImpl(Account account) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO users (login, name, password, domain, quota, status) VALUES (?,?,?,?,?,?)");
            ps.setString(1, account.getAccount());
            ps.setString(2, account.getAccount());
            ps.setString(3, account.getPassword());
            ps.setString(4, this.domain.getName());
            ps.setInt(5, (int)account.getQuota());
            ps.setString(6, String.valueOf(account.getStatus() == 0 ? 1 : 0));
            ps.executeUpdate();
            this.updateForwards(account);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && e.getSQLState().startsWith("23")) {
                throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            throw new BGException((Throwable)e);
        }
    }

    @Override
    protected void modifyImpl(Account account) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE users SET name=?, password=?, quota=?, status=? WHERE login=? AND domain=?");
            ps.setString(1, account.getAccount());
            ps.setString(2, account.getPassword());
            ps.setInt(3, (int)account.getQuota());
            ps.setString(4, String.valueOf(account.getStatus() == 0 ? 1 : 0));
            ps.setString(5, account.getAccount());
            ps.setString(6, this.domain.getName());
            if (ps.executeUpdate() == 0) {
                throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            ps.close();
            this.updateForwards(account);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void updateForwards(Account account) throws SQLException {
        PreparedStatement ps;
        StringBuilder sb;
        ArrayList<Forward> forwards = new ArrayList<Forward>();
        ArrayList<Forward> aliases = new ArrayList<Forward>();
        for (Forward forward : account.getForwardList()) {
            if (forward.getEmail().endsWith("@" + this.domain.getName())) {
                aliases.add(forward);
                continue;
            }
            forwards.add(forward);
        }
        if (aliases.size() > 0) {
            sb = new StringBuilder();
            for (Forward a : aliases) {
                sb.append(a.getEmail()).append("\n");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            ps = this.con.prepareStatement("UPDATE aliases SET recipients=? WHERE local_part=? AND domain=?");
            ps.setString(1, sb.toString());
            ps.setString(2, account.getAccount());
            ps.setString(3, this.domain.getName());
            if (ps.executeUpdate() == 0) {
                ps.close();
                ps = this.con.prepareStatement("INSERT INTO aliases (local_part, domain, recipients) VALUES (?,?,?)");
                ps.setString(1, account.getAccount());
                ps.setString(2, this.domain.getName());
                ps.setString(3, sb.toString());
                ps.executeUpdate();
            }
            ps.close();
        } else {
            ps = this.con.prepareStatement("DELETE FROM aliases WHERE local_part=? AND domain=?");
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
            ps.close();
        }
        if (forwards.size() > 0) {
            sb = new StringBuilder();
            for (Forward f : forwards) {
                sb.append(f.getEmail()).append("\n");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            ps = this.con.prepareStatement("UPDATE userforward SET recipients=? WHERE local_part=? AND domain=?");
            ps.setString(1, sb.toString());
            ps.setString(2, account.getAccount());
            ps.setString(3, this.domain.getName());
            if (ps.executeUpdate() == 0) {
                ps.close();
                ps = this.con.prepareStatement("INSERT INTO userforward (local_part, domain, recipients) VALUES (?,?,?)");
                ps.setString(1, account.getAccount());
                ps.setString(2, this.domain.getName());
                ps.setString(3, sb.toString());
                ps.executeUpdate();
            }
            ps.close();
        } else {
            ps = this.con.prepareStatement("DELETE FROM userforward WHERE local_part=? AND domain=?");
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
            ps.close();
        }
    }

    @Override
    protected void cancelImpl(Account account) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM users WHERE login=? AND domain=?");
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("DELETE FROM aliases WHERE local_part=? AND domain=?");
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("DELETE FROM userforward WHERE local_part=? AND domain=?");
            ps.setString(1, account.getAccount());
            ps.setString(2, this.domain.getName());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Override
    protected void removeDomainImpl(Domain domain) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM domains WHERE domain=?");){
            ps.setString(1, domain.getName());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Override
    protected void updateDomainImpl(Domain domain) throws BGException {
        try {
            ParameterMap params = domain.getParameterMap().inherit(this.moduleSetup).sub("sa.jdbc.");
            PreparedStatement ps = this.con.prepareStatement("UPDATE domains SET type=?, uid=?, gid=? WHERE domain=?");
            ps.setString(1, params.get("domain.type", "LOCAL"));
            ps.setInt(2, params.getInt("domain.uid", 0));
            ps.setInt(3, params.getInt("domain.gid", 0));
            ps.setString(4, domain.getName());
            if (ps.executeUpdate() == 0) {
                ps.close();
                ps = this.con.prepareStatement("INSERT INTO domains (domain, type, uid, gid) VALUES (?,?,?,?)");
                ps.setString(1, domain.getName());
                ps.setString(2, params.get("domain.type", "LOCAL"));
                ps.setInt(3, params.getInt("domain.uid", 0));
                ps.setInt(4, params.getInt("domain.gid", 0));
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

