/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.EmailUtils;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionUpdateForwards
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int aid = this.getIntParameter("aid", -1);
        String forwards = this.getParameter("forwards", "");
        if (aid < 0 || this.mid < 0) {
            throw new BGIllegalArgumentException();
        }
        AccountManager am = new AccountManager(this.con, this.mid);
        ForwardManager fm = new ForwardManager(this.con, this.mid);
        Account account = am.getAccountById(aid);
        if (account != null) {
            String[] forwardArray = forwards.split(";");
            ArrayList<Forward> forwardList = new ArrayList<Forward>();
            if (Utils.notBlankString((String)forwards)) {
                for (String email : forwardArray) {
                    if (!EmailUtils.checkForwardEmail(email, (ParameterMap)this.moduleSetup)) {
                        throw new BGMessageException("\u0410\u0434\u0440\u0435\u0441 " + email + " \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c \u0432 \u043f\u0435\u0440\u0435\u0441\u044b\u043b\u043a\u0435!");
                    }
                    Forward forward = new Forward();
                    forward.setAccountId(aid);
                    forward.setEmail(email);
                    forwardList.add(forward);
                }
            }
            account.setForwardList(forwardList);
            DomainManager dm = new DomainManager(this.con, this.mid);
            Domain domain = dm.get(account.getDomainId());
            if (domain != null) {
                if (TimeUtils.dateInRange((Date)new Date(), (Date)account.getDate1(), (Date)account.getDate2())) {
                    dm.getServiceActivator(domain).modify(account);
                }
                fm.updateForwardList(aid, forwardList);
            }
        }
    }
}

