/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.pattern;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.common.service.ContractParameterServiceOld;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariableType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class VariableEditorDialog
extends BGDialog {
    private JPanel mainPanel = new JPanel(new GridBagLayout());
    private BGTextField variableName = new BGTextField(15);
    private JComboBox<DocumentVariableType> variableType = new JComboBox<DocumentVariableType>(DocumentVariableType.values());
    private BGTextField oneLineVariableValue = new BGTextField(20);
    private BGTextArea multiLineVariableValue = new BGTextArea(3, 20);
    private JScrollPane scrollPane = new JScrollPane((Component)this.multiLineVariableValue);
    private BGControlPanelDateNoB dateCalendarValue = new BGControlPanelDateNoB();
    private BGTextField additionalDateParamValue = new BGTextField(20);
    private JComboBox<IdTitle> dateVariableCombobox = new JComboBox();
    private BGUComboBox<ContractParameterPrefType> contractParamType = new BGUComboBox();
    private BGUComboBox<ContractParameterPref> contractParam = new BGUComboBox();
    private JPanel valuePanel = new JPanel(new GridBagLayout());
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.OK, BGButtonPanel.CANCEL});
    private static DocumentVariable currentVariable;
    private static List<DocumentVariable> existVarList;

    private VariableEditorDialog(DocumentVariable variable) {
        super(null, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", Dialog.ModalityType.APPLICATION_MODAL);
        currentVariable = variable;
        this.jbInit();
        this.setData();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 200));
        this.contractParamType.setModel(this.getParamTypeModel());
        this.dateVariableCombobox.addItem(new IdTitle(0, "\u0412\u044b\u0431\u043e\u0440 \u0434\u0430\u0442\u044b \u0438\u0437 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f"));
        this.dateVariableCombobox.addItem(new IdTitle(1, "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430"));
        this.dateVariableCombobox.addItem(new IdTitle(2, "\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        this.mainPanel.add((Component)new JLabel("\u0418\u043c\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.variableName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add(this.variableType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.valuePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.variableType.addActionListener(actionEvent -> {
            this.oneLineVariableValue.setText("");
            this.multiLineVariableValue.setText("");
            this.additionalDateParamValue.setText("");
            DocumentVariableType type = (DocumentVariableType)this.variableType.getSelectedItem();
            if (type != null) {
                switch (type) {
                    case CONST: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
                        this.valuePanel.add((Component)this.oneLineVariableValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.valuePanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.redraw();
                        if (currentVariable != null) {
                            this.oneLineVariableValue.setText(currentVariable.getValue());
                            break;
                        }
                        this.oneLineVariableValue.setPromptText("<\u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430>", true, true);
                        this.oneLineVariableValue.setToolTipText("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u0430\u043a\u0440\u043e\u043f\u043e\u0434\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438: ${contract_title} - \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430; ${contract_comment} - \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430;${current_user} - \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c;${user_<id>} - \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u043a\u043e\u0434\u043e\u043c <id>");
                        break;
                    }
                    case CONTRACT_PARAM: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
                        this.valuePanel.add((Component)this.contractParamType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.valuePanel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
                        this.valuePanel.add((Component)this.contractParam, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
                        this.valuePanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.redraw();
                        if (currentVariable != null) {
                            this.contractParamType.setSelectedItem((Object)ContractParameterPrefType.getType((int)Utils.parseInt((String)currentVariable.getAdditionalParam(), (int)1)));
                            break;
                        }
                        this.contractParamType.setSelectedIndex(0);
                        break;
                    }
                    case DATE: {
                        this.additionalDateParamValue.setPromptText("\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, dd.MM.yyyy", true, true);
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
                        this.valuePanel.add(this.dateVariableCombobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
                        this.valuePanel.add((Component)this.dateCalendarValue, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
                        this.valuePanel.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
                        this.valuePanel.add((Component)this.additionalDateParamValue, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
                        this.valuePanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.redraw();
                        if (currentVariable != null) {
                            String dt = currentVariable.getValue();
                            if (dt.contains("${contract_date}") || dt.contains("${date_now}")) {
                                if (dt.contains("${contract_date}")) {
                                    this.dateVariableCombobox.setSelectedIndex(2);
                                } else {
                                    this.dateVariableCombobox.setSelectedIndex(1);
                                }
                            } else {
                                this.dateVariableCombobox.setSelectedIndex(0);
                                this.dateCalendarValue.setDateString(currentVariable.getValue());
                            }
                            this.additionalDateParamValue.setText(currentVariable.getAdditionalParam());
                            break;
                        }
                        this.dateVariableCombobox.setSelectedIndex(0);
                        this.dateCalendarValue.setDateCalendar((Calendar)new GregorianCalendar());
                        break;
                    }
                    case URL: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
                        this.valuePanel.add((Component)this.oneLineVariableValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.valuePanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.redraw();
                        if (currentVariable != null) {
                            this.oneLineVariableValue.setText(currentVariable.getValue());
                            break;
                        }
                        this.oneLineVariableValue.setPromptText("http://<\u0430\u0434\u0440\u0435\u0441>", true, true);
                        break;
                    }
                    case SQL: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
                        this.valuePanel.add((Component)this.scrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.valuePanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.redraw();
                        if (currentVariable != null) {
                            this.multiLineVariableValue.setText(currentVariable.getValue());
                            break;
                        }
                        this.multiLineVariableValue.setPromptText("SELECT <\u0438\u043c\u044f_\u043f\u043e\u043b\u044f> FROM <\u0438\u043c\u044f_\u0442\u0430\u0431\u043b\u0438\u0446\u044b>", true, false);
                        this.multiLineVariableValue.setToolTipText("\u0412 SQL-\u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0430\u043a\u0440\u043e\u043f\u043e\u0434\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 ${cid} - \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                        break;
                    }
                    case BARCODE: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
                        this.valuePanel.add((Component)this.scrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.valuePanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
                        this.redraw();
                        if (currentVariable != null) {
                            this.multiLineVariableValue.setText(currentVariable.getValue());
                            break;
                        }
                        String helpMessage = "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0442\u0440\u043e\u043a\u043e\u0439, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0437\u0430\u0434\u0430\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u043c\u0435\u0440 \u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0430. \u0424\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438: MxN;text. \u0417\u0434\u0435\u0441\u044c M - \u0448\u0438\u0440\u0438\u043d\u0430, N - \u0432\u044b\u0441\u043e\u0442\u0430, text - \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0435.\u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u043c\u043e\u0436\u043d\u043e \u0434\u0435\u043b\u0430\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435, \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0432 \u0434\u0430\u043d\u043d\u043e\u043c \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u043f\u0443\u0442\u0435\u043c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0432 \u0444\u0438\u0433\u0443\u0440\u043d\u044b\u0445 \u0441\u043a\u043e\u0431\u043a\u0430\u0445.\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, {param} \u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442, \u0447\u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u0437\u044f\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 param \u0438\u0437 \u044d\u0442\u043e\u0433\u043e \u0436\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0438 \u043f\u043e\u0434\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0435\u0435 \u043d\u0430 \u043c\u0435\u0441\u0442\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0438.";
                        this.multiLineVariableValue.setPromptText(helpMessage, true, false);
                        this.multiLineVariableValue.setToolTipText("\u0412 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043f\u0443\u0442\u0435\u043c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u043f\u0435\u0440\u043c\u0435\u043d\u043d\u043e\u0439 \u0432 \u0444\u0438\u0433\u0443\u0440\u043d\u044b\u0445 \u0441\u043a\u043e\u0431\u043a\u0430\u0445. \u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, {param}");
                        break;
                    }
                    case NONE: {
                        break;
                    }
                }
            }
            this.pack();
        });
        this.contractParamType.addActionListener(actionEvent -> {
            ContractParameterPrefType selectedType = (ContractParameterPrefType)this.contractParamType.getSelectedItem();
            if (selectedType != null) {
                try {
                    List params = ((ContractParameterServiceOld)this.getContext().getPort(ContractParameterServiceOld.class)).getContractParameterPrefList(selectedType.getId());
                    this.contractParam.setData(params);
                    if (currentVariable != null && this.contractParamType.getSelectedItem() == ContractParameterPrefType.getType((int)Utils.parseInt((String)currentVariable.getAdditionalParam(), (int)1))) {
                        this.contractParam.setSelectedItem((Object)Utils.parseInt((String)currentVariable.getValue(), (int)1));
                    }
                }
                catch (BGException e1) {
                    this.getContext().processException((Throwable)e1);
                }
            }
        });
        this.buttonPanel.addActionListener(actionEvent -> {
            String actionCommand = actionEvent.getActionCommand();
            if (BGButtonPanel.CANCEL.command.equals(actionCommand)) {
                this.dispose();
            } else {
                DocumentVariableType selectedType;
                if (Utils.isBlankString((String)this.variableName.getText())) {
                    BGToolTip.showErrorMessage((JComponent)this.variableName, (String)"\u041f\u043e\u043b\u0435 \u0418\u043c\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c!");
                }
                if ((selectedType = (DocumentVariableType)this.variableType.getSelectedItem()).equals((Object)DocumentVariableType.NONE)) {
                    BGToolTip.showErrorMessage((JComponent)this.variableName, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439!");
                }
                DocumentVariable current = new DocumentVariable(this.variableName.getText());
                current.setType(selectedType);
                switch (current.getType()) {
                    case CONTRACT_PARAM: {
                        ContractParameterPrefType typeSelectedItem = (ContractParameterPrefType)this.contractParamType.getSelectedItem();
                        if (typeSelectedItem == null) break;
                        current.setAdditionalParam(String.valueOf(typeSelectedItem.getId()));
                        ContractParameterPref paramSelectedItem = (ContractParameterPref)this.contractParam.getSelectedItem();
                        if (paramSelectedItem == null) {
                            BGToolTip.showErrorMessage((JComponent)this.buttonPanel, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e!");
                            return;
                        }
                        current.setValue(String.valueOf(paramSelectedItem.getId()));
                        break;
                    }
                    case DATE: {
                        String format = this.additionalDateParamValue.getText();
                        if (!Utils.notBlankString((String)format)) {
                            format = "dd.MM.yyyy";
                        }
                        current.setAdditionalParam(format);
                        IdTitle selectedDateValue = (IdTitle)this.dateVariableCombobox.getSelectedItem();
                        if (selectedDateValue == null) break;
                        current.setValue(selectedDateValue.getId() == 0 ? TimeUtils.format((Calendar)this.dateCalendarValue.getDateCalendar(), (String)"dd.MM.yyyy") : (selectedDateValue.getId() == 1 ? "${date_now}" : "${contract_date}"));
                        break;
                    }
                    case CONST: 
                    case URL: {
                        current.setValue(this.oneLineVariableValue.getText());
                        break;
                    }
                    case SQL: 
                    case BARCODE: {
                        current.setValue(this.multiLineVariableValue.getText());
                        break;
                    }
                }
                for (DocumentVariable var : existVarList) {
                    if (!var.equals((Object)current)) continue;
                    BGToolTip.showErrorMessage((JComponent)this.variableName, (String)"\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442! \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u0430\u0434\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u043e\u0435 \u0438\u043c\u044f!");
                    this.variableName.setText(current.getTitle());
                    return;
                }
                currentVariable = current;
                this.dispose();
            }
        });
        this.dateVariableCombobox.addActionListener(actionEvent -> {
            IdTitle selectedItem = (IdTitle)this.dateVariableCombobox.getSelectedItem();
            if (selectedItem != null) {
                this.dateCalendarValue.setEnabled(selectedItem.getId() == 0);
            }
        });
        this.variableType.setSelectedIndex(0);
        this.contractParamType.setSelectedIndex(0);
    }

    public void setData() {
        if (currentVariable != null) {
            this.variableName.setText(currentVariable.getTitle());
            this.variableType.setSelectedItem(currentVariable.getType());
        }
    }

    private DefaultComboBoxModel<ContractParameterPrefType> getParamTypeModel() {
        DefaultComboBoxModel<ContractParameterPrefType> result = new DefaultComboBoxModel<ContractParameterPrefType>();
        result.addElement(ContractParameterPrefType.TYPE_TEXT);
        result.addElement(ContractParameterPrefType.TYPE_ADDRESS);
        result.addElement(ContractParameterPrefType.TYPE_EMAIL);
        result.addElement(ContractParameterPrefType.TYPE_FLAG);
        result.addElement(ContractParameterPrefType.TYPE_DATE);
        result.addElement(ContractParameterPrefType.TYPE_LIST);
        result.addElement(ContractParameterPrefType.TYPE_CONTRACT_REF);
        result.addElement(ContractParameterPrefType.TYPE_PHONE);
        return result;
    }

    static DocumentVariable showVariableEditor(DocumentVariable var, List<DocumentVariable> varList) {
        VariableEditorDialog dialog = new VariableEditorDialog(var);
        existVarList = varList;
        dialog.setVisible(true);
        return currentVariable;
    }

    private void redraw() {
        this.mainPanel.repaint();
        this.mainPanel.updateUI();
    }
}

