/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.pattern;

import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.documents.client.pattern.ClassChooser;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTableExtractMethod;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;

public class TableEditorDialog
extends BGDialog {
    private JPanel mainPanel = new JPanel(new GridBagLayout());
    private BGTextField tableName = new BGTextField(20);
    private BGTextField tableIdentifier = new BGTextField(20);
    private JComboBox<DocumentTableExtractMethod> extractMethod = new JComboBox();
    private BGTextArea multiLineVariableValue = new BGTextArea(3, 20);
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.OK, BGButtonPanel.CANCEL});
    private JScrollPane scrollPane = new JScrollPane((Component)this.multiLineVariableValue);
    private ClassChooser classChooserPanel;
    private JPanel valuePanel = new JPanel(new GridBagLayout());
    private static DocumentTable currentTable;
    private static List<DocumentTable> existTableList;

    private TableEditorDialog(DocumentTable docTable, ClientContext ctx) {
        super(ctx, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0431\u043b\u0438\u0446\u044b", Dialog.ModalityType.APPLICATION_MODAL);
        currentTable = docTable;
        this.jbInit();
        this.setData();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 250));
        this.classChooserPanel = new ClassChooser(this.getContext());
        this.mainPanel.add((Component)new JLabel("\u0418\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.tableName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)new JLabel("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.tableIdentifier, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)new JLabel("\u041c\u0435\u0442\u043e\u0434 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.mainPanel.add(this.extractMethod, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.valuePanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.extractMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DocumentTableExtractMethod method = (DocumentTableExtractMethod)TableEditorDialog.this.extractMethod.getSelectedItem();
                switch (method) {
                    case SQL: {
                        TableEditorDialog.this.clearValuePanel();
                        TableEditorDialog.this.valuePanel.add((Component)TableEditorDialog.this.scrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
                        TableEditorDialog.this.valuePanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
                        TableEditorDialog.this.redrawValuePanel();
                        if (currentTable != null) {
                            TableEditorDialog.this.multiLineVariableValue.setText(currentTable.getValue());
                            break;
                        }
                        TableEditorDialog.this.multiLineVariableValue.setPromptText("SELECT <\u0441\u0442\u043e\u043b\u0431\u0446\u044b \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e> FROM <\u0438\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b>", true, true);
                        TableEditorDialog.this.multiLineVariableValue.setToolTipText("\u0412 SQL-\u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0430\u043a\u0440\u043e\u043f\u043e\u0434\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 ${cid} - \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                        break;
                    }
                    case DYNCLASS: {
                        TableEditorDialog.this.clearValuePanel();
                        TableEditorDialog.this.valuePanel.add((Component)((Object)TableEditorDialog.this.classChooserPanel), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
                        TableEditorDialog.this.valuePanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
                        TableEditorDialog.this.redrawValuePanel();
                        if (currentTable == null) break;
                        TableEditorDialog.this.classChooserPanel.dynClassChooser.setSelectedItem(currentTable.getValue());
                        break;
                    }
                    case NONE: {
                        break;
                    }
                }
                TableEditorDialog.this.pack();
            }
        });
        this.buttonPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BGButtonPanel.CANCEL.equals((Object)actionEvent.getActionCommand())) {
                    TableEditorDialog.this.dispose();
                } else if (Utils.notBlankString((String)TableEditorDialog.this.tableName.getText())) {
                    DocumentTable table = new DocumentTable();
                    table.setTitle(TableEditorDialog.this.tableName.getText());
                    table.setIdentifier(TableEditorDialog.this.tableIdentifier.getText());
                    table.setExtractMethod((DocumentTableExtractMethod)TableEditorDialog.this.extractMethod.getSelectedItem());
                    switch (table.getExtractMethod()) {
                        case SQL: {
                            table.setValue(TableEditorDialog.this.multiLineVariableValue.getText());
                            break;
                        }
                        case DYNCLASS: {
                            table.setValue(TableEditorDialog.this.classChooserPanel.dynClassChooser.getSelectedClass());
                            break;
                        }
                        case NONE: {
                            break;
                        }
                    }
                    for (DocumentTable tab : existTableList) {
                        if (!tab.equals((Object)table)) continue;
                        BGToolTip.showErrorMessage((JComponent)TableEditorDialog.this.tableName, (String)"\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442! \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u0430\u0434\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u043e\u0435 \u0438\u043c\u044f!");
                        TableEditorDialog.this.tableName.setText(table != null ? table.getTitle() : "");
                        return;
                    }
                    currentTable = table;
                    TableEditorDialog.this.dispose();
                } else {
                    BGToolTip.showErrorMessage((JComponent)TableEditorDialog.this.tableName, (String)"\u041f\u043e\u043b\u0435 \u0418\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c!");
                }
            }
        });
        this.extractMethod.setModel(new DefaultComboBoxModel<DocumentTableExtractMethod>(new DocumentTableExtractMethod[]{DocumentTableExtractMethod.SQL, DocumentTableExtractMethod.DYNCLASS}));
        this.extractMethod.setSelectedIndex(0);
    }

    public void setData() {
        try {
            this.classChooserPanel.dynClassChooser.setIfaceName(((DocumentsPatternService)this.getContext().getPort(DocumentsPatternService.class)).getTableExtractorIfaceClassName());
            this.classChooserPanel.dynClassChooser.performAction("refresh");
            this.tableName.setPromptText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b", true, false);
            this.tableIdentifier.setPromptText("<id>", true, false);
        }
        catch (BGException e1) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430", 64);
        }
        if (currentTable != null) {
            this.tableName.setText(currentTable.getTitle());
            this.tableIdentifier.setText(currentTable.getIdentifier());
            this.extractMethod.setSelectedItem(currentTable.getExtractMethod());
            switch (currentTable.getExtractMethod()) {
                case SQL: {
                    this.multiLineVariableValue.setText(currentTable.getValue());
                    break;
                }
                case DYNCLASS: {
                    this.classChooserPanel.dynClassChooser.setSelectedItem(currentTable.getValue());
                    break;
                }
                case NONE: {
                    break;
                }
            }
        }
    }

    public static DocumentTable showTableEditor(DocumentTable table, ClientContext ctx, List<DocumentTable> tableList) {
        TableEditorDialog dialog = new TableEditorDialog(table, ctx);
        existTableList = tableList;
        dialog.setVisible(true);
        return currentTable;
    }

    private void clearValuePanel() {
        this.valuePanel.remove(this.scrollPane);
        this.valuePanel.remove((Component)((Object)this.classChooserPanel));
    }

    private void redrawValuePanel() {
        this.valuePanel.repaint();
        this.valuePanel.updateUI();
    }
}

