/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.activation.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.dispatch.server.filestorage.DispatchFileStorage;
import ru.bitel.common.model.Id;

public class DispatchFileStorageDao {
    private static final Logger logger = LogManager.getLogger();
    private FileStorage fileStorageManager;

    public DispatchFileStorageDao(Connection con, BGPluginServer plugin) throws BGException {
        this.fileStorageManager = new DispatchFileStorage(con);
    }

    public BGServerFile uploadFile(Id object, String fileName, byte[] fileData) throws BGException {
        BGServerFile serverFile = null;
        try {
            serverFile = new BGServerFile();
            serverFile.setDate(new Date());
            serverFile.setTitle(fileName);
            serverFile.setSize((long)fileData.length);
            serverFile.setOwnerId(object.getId());
            serverFile.setComment("");
            this.fileStorageManager.updateFile(serverFile);
            if (serverFile.getId() > 0) {
                FileOutputStream out = this.fileStorageManager.save(serverFile.getId());
                out.write(fileData);
                out.close();
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return serverFile;
    }

    public void deleteFile(int fileId) throws BGException {
        this.fileStorageManager.deleteFile(fileId);
    }

    public FileInputStream getFileInputStream(int fileId) throws IOException {
        try {
            return this.fileStorageManager.load(fileId);
        }
        catch (FileNotFoundException ex) {
            throw new IOException("error get file id=" + fileId, ex);
        }
    }

    public BGServerFile getServerFile(int fileId) throws BGException {
        return this.fileStorageManager.getFileById(fileId);
    }

    public List<BGServerFile> getFileList(Id object) throws BGException {
        return this.fileStorageManager.getFilesListByOwner(object.getId());
    }

    public void deleteByObject(Id o) throws BGException {
        try {
            this.fileStorageManager.deleteByOwner(o.getId());
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public DataSource getDataSource(BGServerFile serverFile) {
        DataSource result = null;
        try {
            result = this.fileStorageManager.getDataSource(serverFile.getId());
            result.getInputStream();
        }
        catch (IOException e) {
            logger.error(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b %s \u0441 \u043a\u043e\u0434\u043e\u043c %d", serverFile.getTitle(), serverFile.getId()), (Throwable)e);
        }
        return result;
    }
}

