/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.calc;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatusManager;
import bitel.billing.server.tariff.TariffModuleTree;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpSessionUtils;
import ru.bitel.bgbilling.modules.dialup.server.calc.CalcPeriod;
import ru.bitel.bgbilling.modules.dialup.server.calc.ContractData;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ContractDataStorage {
    private static Logger log = LogManager.getLogger((String)"scheduler");
    private Connection conSlave;
    private int mid;
    private Calendar date1;
    private Calendar date2;
    private Calendar startMonth;
    private Date startMonthDate;
    private Date endMonthDate;
    private CalcPeriod defaultPeriod;
    private Map<Integer, ContractData> contractDataMap = new HashMap<Integer, ContractData>();
    private ContractManager contractManager;
    private ContractStatusManager contractStatusManager;
    private ContractTariffOptionDao contractTariffOptionManager;
    private DialUpSessionUtils dsu;
    private String sids;
    private final Set<Integer> suspendedOrClosed;

    public ContractDataStorage(Connection conSlave, int mid, String sids, Calendar date1, Calendar date2, Calendar startMonth, Calendar endMonth) {
        this.conSlave = conSlave;
        this.mid = mid;
        this.sids = sids;
        this.date1 = date1;
        this.date2 = date2;
        this.startMonth = startMonth;
        this.startMonthDate = TimeUtils.convertCalendarToDate((Calendar)startMonth);
        this.endMonthDate = TimeUtils.convertCalendarToDate((Calendar)endMonth);
        this.defaultPeriod = new CalcPeriod(startMonth, endMonth);
        this.contractManager = new ContractManager(conSlave);
        this.contractStatusManager = new ContractStatusManager(conSlave);
        this.contractTariffOptionManager = new ContractTariffOptionDao(conSlave);
        this.dsu = new DialUpSessionUtils(conSlave, mid);
        this.suspendedOrClosed = StatusCache.getInstance().getModuleSuspendStatusSet(mid);
    }

    public ContractData getContractData(int cid, int firstSessionId, Calendar firstSessionDtime) throws Exception {
        ContractData result = this.contractDataMap.get(cid);
        if (result == null) {
            result = new ContractData(cid, this.defaultPeriod);
            this.contractDataMap.put(cid, result);
            this.loadCalculatePeriods(result);
            CalcPeriod period = result.getCalcPeriod(firstSessionDtime);
            result.tariffOptions = this.contractTariffOptionManager.getContractRealtimeTariffOptionList(cid, TimeUtils.convertCalendarToDate((Calendar)period.start));
            result.serviceRanges = this.dsu.getServiceRangeMap(cid, this.sids);
            result.tts = this.contractManager.getRealtimeTariffTreeSet(cid, period.start, "dialup", this.mid, true);
            result.suspendedPeriods = this.contractStatusManager.getPeriodList(cid, this.suspendedOrClosed, this.startMonthDate, this.endMonthDate);
            this.initTariffTree(firstSessionDtime, firstSessionId, result);
        }
        return result;
    }

    private void initTariffTree(Calendar firstSessionDtime, int firstSessionId, ContractData data) {
        try {
            boolean needInit = false;
            TariffTreeSet tts = data.tts;
            for (TariffModuleTree tree : tts.getTreeList()) {
                TariffRequest req = new TariffRequest();
                req.setRequestParam("cid", (Object)data.cid);
                req.setRequestParam("action", (Object)"reset");
                tree.processRequest(req);
                needInit = req.getResponseParam("reset") != null;
                if (!needInit) continue;
                break;
            }
            if (needInit) {
                CalcPeriod period = data.getCalcPeriod(firstSessionDtime);
                Calendar fromDate = period.start;
                if (TimeUtils.dateBefore((Calendar)this.startMonth, (Calendar)fromDate)) {
                    fromDate = period.start;
                }
                Calendar date = (Calendar)fromDate.clone();
                while (TimeUtils.monthsDelta((Calendar)date, (Calendar)this.date2) >= 0) {
                    String query;
                    PreparedStatement ps = null;
                    String tableName = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)fromDate.getTime(), (int)this.mid);
                    String sessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)fromDate.getTime(), (int)this.mid);
                    if (TimeUtils.monthsDelta((Calendar)date, (Calendar)this.startMonth) == 0) {
                        query = "SELECT sid, dtime, amount FROM " + tableName + " AS detail INNER JOIN " + sessionTableName + " AS session ON session.id=detail.session_id WHERE cid=? AND TO_DAYS(dtime)>=TO_DAYS(?) AND detail.session_id<? AND amount!=0";
                        ps = this.conSlave.prepareStatement(query);
                        ps.setInt(1, data.cid);
                        ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)fromDate));
                        ps.setInt(3, firstSessionId);
                    } else {
                        query = "SELECT sid, dtime, amount FROM " + tableName + " AS detail INNER JOIN " + sessionTableName + " AS session ON session.id=detail.session_id WHERE cid=? AND TO_DAYS(dtime)>=TO_DAYS(?) AND amount!=0";
                        ps = this.conSlave.prepareStatement(query);
                        ps.setInt(1, data.cid);
                        ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)fromDate));
                    }
                    TariffRequest req = new TariffRequest();
                    req.setRequestParam("cid", (Object)data.cid);
                    req.setRequestParam("action", (Object)"init");
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        int sid = rs.getInt(1);
                        Calendar dtime = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(2));
                        long amount = rs.getLong(3);
                        period = data.getCalcPeriod(dtime);
                        TariffTreeSet.TariffSetEntry tse = tts.getTreeEntry(dtime);
                        if (tse != null) {
                            req.setNoAccepted();
                            req.clearHistory();
                            float servicePart = DialUpSessionUtils.getPart(period.start, period.end, sid, data.serviceRanges);
                            float tariffPart = tse.getPartOnPeriod(period.start, period.end);
                            float tariffPartSuspended = tse.getPartOnPeriod(period.start, period.end, data.suspendedPeriods);
                            req.setRequestParam("sid", (Object)sid);
                            req.setRequestParam("time", (Object)dtime);
                            req.setRequestParam("amount", (Object)amount);
                            req.setRequestParam("period_end", (Object)period.end);
                            req.setRequestParam("part_service", (Object)Float.valueOf(servicePart));
                            req.setRequestParam("part_tariff", (Object)Float.valueOf(tariffPart));
                            req.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tariffPartSuspended));
                            tse.getTree().processRequest(req);
                            continue;
                        }
                        log.error("Not found tariff on:" + TimeUtils.formatDate((Calendar)dtime) + "; cid: " + data.cid);
                    }
                    date.add(2, 1);
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void loadCalculatePeriods(ContractData data) {
        try {
            data.calcPeriods = new ArrayList<CalcPeriod>(5);
            String query = "SELECT start, end FROM calculate_period_" + this.mid + " WHERE cid=? AND start<=? AND end>=?";
            PreparedStatement ps = this.conSlave.prepareStatement(query);
            ps.setInt(1, data.cid);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.date2));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)this.date1));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CalcPeriod period = new CalcPeriod(TimeUtils.convertDateToCalendar((Date)rs.getDate(1)), TimeUtils.convertDateToCalendar((Date)rs.getDate(2)));
                data.calcPeriods.add(period);
            }
            ps.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

