/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.gospell;

import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.ByteSerializer;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.Command;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.Response;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.SendEntitlementUserResponse;

public class SendEntitlementUserCommand
extends Command {
    private long cardId;
    private final int quickSendFlag = 1;
    private List<ProductEntry> productEntrys;

    @Override
    protected int getCommandType() {
        return 1;
    }

    @Override
    protected byte[] getDataBody() {
        ByteSerializer result = new ByteSerializer(4026);
        result.put(this.cardId, 4);
        result.put(1, 1);
        result.put(this.productEntrys.size(), 1);
        for (ProductEntry product : this.productEntrys) {
            result.put(product.sendOrNot ? 1 : 0, 1);
            result.put(product.tapingCtrl ? 1 : 0, 1);
            result.put(product.productNumber, 2);
            result.put(product.productBeginTime.getTime() / 1000L, 4);
            result.put(product.productEndTime.getTime() / 1000L, 4);
            if (product.description != null) {
                result.put(product.description.length(), 1);
                result.put(product.description);
                continue;
            }
            result.put(0, 1);
        }
        return result.getBuffer();
    }

    @Override
    public Response getResponse() {
        return new SendEntitlementUserResponse();
    }

    public void setCardId(long cardId) {
        this.cardId = cardId;
    }

    public void setProductEntrys(List<ProductEntry> productEntrys) {
        this.productEntrys = productEntrys;
    }

    public static class ProductEntry {
        boolean sendOrNot;
        boolean tapingCtrl;
        int productNumber;
        Date productBeginTime;
        Date productEndTime;
        String description;

        ProductEntry(boolean sendOrNot, boolean tapingCtrl, int productNumber, Date productBeginTime, Date productEndTime, String description) {
            this.sendOrNot = sendOrNot;
            this.tapingCtrl = tapingCtrl;
            this.productNumber = productNumber;
            this.productBeginTime = productBeginTime;
            this.productEndTime = productEndTime;
            this.description = description;
        }
    }
}

