/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.gospell;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.Command;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.DisplayOSDCommand;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.GospellException;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.Response;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.SendEmailCommand;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.SendEntitlementUserCommand;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.SendEntitlementUserResponse;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.StartStopCardCommand;
import ru.bitel.bgbilling.modules.cerbercrypt.server.gospell.StartStopCardResponse;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class GospellCon {
    private static final Logger log = LogManager.getLogger();
    private String host;
    private int port;
    private int timeout;
    private Socket socket;
    private OutputStream os;
    private InputStream is;
    private int osdShowTimeLength = 30;
    private int osdShowTimes = 0;
    private int osdPriority = 0;
    private int osdExpiredTimeSecond = 86400;
    static final int MAX_ENTRY_COUNT = 14;

    public GospellCon(ParameterMap preferences, int serverId) throws BGException {
        this.host = preferences.get("host", null);
        this.port = preferences.getInt("port", 0);
        if (Utils.isEmptyString((String)this.host) || this.port <= 0) {
            throw new BGException("Host or port for server " + serverId + " undefined!");
        }
        this.timeout = preferences.getInt("timeout", 30000);
        this.osdShowTimeLength = preferences.getInt("osdShowTimeLength", 30);
        this.osdShowTimes = preferences.getInt("osdShowTimes", 0);
        this.osdPriority = preferences.getInt("osdPriority", 0);
        this.osdExpiredTimeSecond = preferences.getInt("osdExpiredTimeSecond", 86400);
    }

    public Response sendRequest(Command packet) throws BGException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("send command " + packet.getClass().getSimpleName() + "\u2026");
        }
        packet.writePacket(this.os);
        this.os.flush();
        Response result = packet.getResponse();
        result.readPacket(this.is);
        if (log.isDebugEnabled()) {
            log.debug("get response " + result.getClass().getSimpleName() + ": " + result.toString());
        }
        if (result.getResult() != 0) {
            throw new GospellException(result.getResult());
        }
        return result;
    }

    public void connect() throws IOException, BGException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setSoTimeout(this.timeout);
        this.os = new BufferedOutputStream(this.socket.getOutputStream());
        this.is = new BufferedInputStream(this.socket.getInputStream());
    }

    public void disconnect() throws Exception {
        this.is.close();
        this.is = null;
        this.os.close();
        this.os = null;
        this.socket.close();
        this.socket = null;
    }

    public void packageAuthorization(long cardNumber, final int packageId, final Date startTime, final Date endTime) throws BGException, IOException {
        SendEntitlementUserCommand command = new SendEntitlementUserCommand();
        command.setSessionId(1);
        command.setCardId(cardNumber);
        command.setProductEntrys((List<SendEntitlementUserCommand.ProductEntry>)new ArrayList<SendEntitlementUserCommand.ProductEntry>(){
            {
                this.add(new SendEntitlementUserCommand.ProductEntry(true, true, packageId, startTime, endTime, null));
            }
        });
        SendEntitlementUserResponse request = (SendEntitlementUserResponse)this.sendRequest(command);
        request.getProductEntrys();
    }

    public void cancelPackageAuthorization(long cardNumber, final int packageId) throws BGException, IOException {
        Date startTime;
        final Date endTime = startTime = new Date();
        SendEntitlementUserCommand command = new SendEntitlementUserCommand();
        command.setSessionId(1);
        command.setCardId(cardNumber);
        command.setProductEntrys((List<SendEntitlementUserCommand.ProductEntry>)new ArrayList<SendEntitlementUserCommand.ProductEntry>(){
            {
                this.add(new SendEntitlementUserCommand.ProductEntry(true, true, packageId, startTime, endTime, null));
            }
        });
        SendEntitlementUserResponse request = (SendEntitlementUserResponse)this.sendRequest(command);
        request.getProductEntrys();
    }

    public void cancelAllChannelAuthorization(long cardNumber, List<Integer> allcodes) throws BGException, IOException {
        for (int ps = 0; ps < allcodes.size() / 14 + 1; ++ps) {
            Date startTime;
            final List<Integer> sublist = allcodes.subList(ps * 14, Math.min((ps + 1) * 14, allcodes.size()));
            final Date endTime = startTime = new Date();
            SendEntitlementUserCommand command = new SendEntitlementUserCommand();
            command.setSessionId(1);
            command.setCardId(cardNumber);
            command.setProductEntrys((List<SendEntitlementUserCommand.ProductEntry>)new ArrayList<SendEntitlementUserCommand.ProductEntry>(){
                {
                    for (Integer packageId : sublist) {
                        this.add(new SendEntitlementUserCommand.ProductEntry(true, true, packageId, startTime, endTime, null));
                    }
                }
            });
            SendEntitlementUserResponse request = (SendEntitlementUserResponse)this.sendRequest(command);
            request.getProductEntrys();
        }
    }

    public void sendEmail(long cardNumber, String title, String message) throws BGException, IOException {
        SendEmailCommand command = new SendEmailCommand();
        command.setSessionId(1);
        command.setCardId(cardNumber);
        command.setWritePaperTime(new Date());
        command.setEmailTitle(title);
        command.setEmailContent(message);
        this.sendRequest(command);
    }

    public void sendOSD(long cardNumber, String message) throws BGException, IOException {
        DisplayOSDCommand command = new DisplayOSDCommand();
        command.setSessionId(1);
        command.setCardId(cardNumber);
        command.setShowTimeLength(this.osdShowTimeLength);
        command.setShowTimes(this.osdShowTimes);
        command.setPriority(this.osdPriority);
        command.setExpiredTime(TimeUtils.nowPlusPeriod((int)13, (int)this.osdExpiredTimeSecond));
        command.setData(message);
        this.sendRequest(command);
    }

    public void enableSmartcard(long cardNumber, boolean active) throws BGException, IOException {
        StartStopCardCommand command = new StartStopCardCommand();
        command.setSessionId(1);
        command.setCardId(cardNumber);
        command.setSendOrNot(true);
        command.setCardStatus(active);
        StartStopCardResponse response = (StartStopCardResponse)this.sendRequest(command);
        response.getEmmEntrys();
    }
}

