/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.task;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PaymentQueueManager;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.function.ThrowingConsumer;

public class CheckStatus
extends TaskBase {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
    private int checkStatusBackDays = -1;
    private long checkStatusTimeoutMs = 10L;

    public String getDescription() {
        return this.defaultDescription + "\u041f\u043b\u0430\u0433\u0438\u043d CashCheck. \u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0447\u0435\u043a\u043e\u0432";
    }

    protected boolean initTask() {
        this.checkStatusBackDays = this.plugin.getSetup().getInt("check.status.back.days", this.checkStatusBackDays);
        this.checkStatusTimeoutMs = this.plugin.getSetup().getLong("check.status.timeout.ms", this.checkStatusTimeoutMs);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.processCheckPending(con, conSlave);
        }
        catch (Exception e) {
            this.log.error("error CheckStatus task", (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
    }

    private void processCheckPending(Connection con, Connection conSlave) throws BGException {
        Date date1 = this.checkStatusBackDays != -1 ? TimeUtils.nowPlusPeriod((int)5, (int)(-this.checkStatusBackDays)) : null;
        Date date2 = null;
        PaymentDao pm = new PaymentDao(con);
        PaymentQueueManager pqm = new PaymentQueueManager(con);
        List<Payment> needPending = pqm.getNeedPendingIdLog(-1, date1, date2, false);
        this.log.info("cashcheck autoprint: check status: payments from " + (date1 != null ? TimeUtils.formatDate((Date)date1) : "all") + " to " + (date2 != null ? TimeUtils.formatDate(date2) : "now") + ", size: " + needPending.size() + "...");
        HashMap<Integer, List> posPendingsMap = new HashMap<Integer, List>();
        for (Payment payment : needPending) {
            if (payment.getPosId() < 1) {
                this.log.error("no set pos_id for log-payment #" + payment.getPaymentId() + " (log-id #" + payment.getLogId() + ")");
                continue;
            }
            posPendingsMap.computeIfAbsent(payment.getPosId(), __ -> new ArrayList()).add(payment.getPendingId());
        }
        for (Map.Entry entry : posPendingsMap.entrySet()) {
            int posId = (Integer)entry.getKey();
            List pendingIds = (List)entry.getValue();
            this.log.info("cashcheck autoprint: check status: from kkm #" + posId + ", pendings size: " + pendingIds.size() + "...");
            ArrayList erroredCheck = new ArrayList();
            try {
                Printer printer = CashCheckUtils.getPrinter(posId);
                Fiscalizator fiscalizator = printer.fiscalize();
                if (!fiscalizator.isAsynchronous()) {
                    this.log.error("printer #" + posId + " is not asynchronous fiscalizator");
                    continue;
                }
                this.log.info("cashcheck autoprint: checkPending fiscalizator " + printer.getFiscalizatorType());
                fiscalizator.checkPending(pendingIds, this.checkStatusTimeoutMs, (ThrowingConsumer<Fiscalizator.CheckResult>)((ThrowingConsumer)checkResult -> {
                    if (checkResult.result == Fiscalizator.CheckResult.Result.WAIT) {
                        this.log.debug("payment " + checkResult.pendingId + " is wait");
                    } else if (checkResult.result == Fiscalizator.CheckResult.Result.OK) {
                        this.log.debug("payment " + checkResult.pendingId + " is OK");
                        pqm.updatePaymentFiscalDataForPendingId(checkResult.pendingId, checkResult.data);
                    } else if (checkResult.result == Fiscalizator.CheckResult.Result.ERROR) {
                        this.log.error("payment " + checkResult.pendingId + " is ERROR: " + checkResult.data);
                        pqm.updatePaymentLastErrorForPendingId(checkResult.pendingId, checkResult.data);
                        erroredCheck.add(checkResult.data);
                    }
                }));
                if (erroredCheck.isEmpty()) continue;
                String text = "\u0414\u043b\u044f \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 (" + erroredCheck.size() + ") \u0447\u0435\u043a\u043e\u0432 \u043d\u0430 kkm #" + posId + " \u0431\u044b\u043b \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438:\n\n" + Utils.toString(erroredCheck, (String)"\n\n");
                CashCheckUtils.sendMailsAutoprint("check.status.error", "cashcheck autoprint: ERROR check on kkm #" + posId, text);
            }
            catch (BGException e) {
                this.log.error("cashcheck autoprint: ERROR run checkStatus on kkm #" + posId, (Throwable)e);
                CashCheckUtils.sendMailsAutoprint("check.status.error", "cashcheck autoprint: ERROR run checkStatus on kkm #" + posId, e.printStackTraceToString());
            }
        }
        pm.close();
    }
}

