/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;

public class ActionCardContractList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int mid = this.getIntParameter("mid", -1);
        if (mid == -1) {
            return;
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        if (this.getIntParameter("header", 0) == 1) {
            table.appendChild(this.getTableHeader(7));
        }
        String query = "SELECT t1.id, t2.title, date_format( t1.date1, '%d.%m.%Y' ), date_format( t1.date2, '%d.%m.%Y' ), t1.comment FROM card_contract as t1, contract_pattern as t2 WHERE t1.pattern=t2.id and t1.mid=? ORDER BY t1.id";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, mid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Element item = this.createElement(data, "item");
            item.setAttribute("f0", rs.getString(1));
            item.setAttribute("f1", rs.getString(2));
            item.setAttribute("f2", this.period(rs.getString(3), rs.getString(4)));
            item.setAttribute("f3", rs.getString(5));
        }
        rs.close();
        ps.close();
    }

    private String period(String date1, String date2) {
        StringBuffer sb = new StringBuffer();
        if (!"00.00.0000".equals(date1)) {
            sb.append(date1);
        }
        sb.append("-");
        if (!"00.00.0000".equals(date2)) {
            sb.append(date2);
        }
        return sb.toString();
    }
}

