/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.dynamic.common.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;
import ru.bitel.bgbilling.modules.botmanager.server.bean.UserBotData;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.TelegramRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.VKRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotSessionsDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class BotManagment {
    private static final Logger logger = LogManager.getLogger();
    private static BotManagment instance;
    private ServerContext serverContext = (ServerContext)ServerContext.get();
    private final Map<String, RuntimeBot> bots = new HashMap<String, RuntimeBot>();
    private Map<String, DialogProcessing> dialogProcessingClasses = new HashMap<String, DialogProcessing>();

    public static void init(int moduleId) throws BGException {
        instance = new BotManagment();
        instance.loadBots(moduleId);
        instance.reloadDialogProcessing();
    }

    private void loadBots(int moduleId) {
        if (this.bots.size() > 0) {
            this.bots.clear();
        }
        try (BotDao botDao = new BotDao(this.serverContext.getConnection(), moduleId);){
            BotSessionsDao sessionsDao = new BotSessionsDao(this.serverContext.getConnection(), moduleId);
            for (Bot bot : botDao.getBots()) {
                RuntimeBot runtimeBot2 = BotManagment.convertBotToRuntimeBot(bot);
                runtimeBot2.setBotData(botDao.getBotData(bot.getId()));
                runtimeBot2.initBot(this.serverContext, moduleId);
                runtimeBot2.getBotSessions().putAll(sessionsDao.getSessions(bot.getId()));
                this.bots.put(runtimeBot2.getToken(), runtimeBot2);
            }
        }
        catch (BGException e) {
            logger.error((Object)e);
        }
        this.bots.forEach((token, runtimeBot) -> {
            if (runtimeBot.getBotState() == 1) {
                runtimeBot.startBot();
            } else {
                runtimeBot.stopBot();
            }
        });
    }

    public static RuntimeBot convertBotToRuntimeBot(Bot bot) throws BGException {
        return BotManagment.convertBotToRuntimeBot(bot, null);
    }

    public static RuntimeBot convertBotToRuntimeBot(Bot bot, RuntimeBot runtime) throws BGException {
        RuntimeBot runtimeBot = null;
        if (runtime != null) {
            runtime.setBotId(bot.getId());
            runtime.setBotState(bot.getState());
            runtime.setToken(bot.getToken());
            return runtime;
        }
        switch (bot.getBotType()) {
            case TELEGRAM_BOT: {
                runtimeBot = new TelegramRuntimeBot(bot);
                break;
            }
            case BK_BOT: {
                runtimeBot = new VKRuntimeBot(bot);
            }
        }
        return runtimeBot;
    }

    public synchronized void commitUserBotData(int botId, int moduleId, UserBotData userBotData) throws BGException {
        try (BotDao botDao = new BotDao(this.serverContext.getConnection(), moduleId);){
            botDao.updateBotData(botId, userBotData);
        }
    }

    public void reloadDialogProcessing() throws BGException {
        this.dialogProcessingClasses.clear();
        List classes = ServerUtils.getClassList((String)"ru.bitel.bgbilling.modules.botmanager.server.bean.dialogprocessing");
        classes.removeIf(clazz -> !DialogProcessing.class.isAssignableFrom((Class<?>)clazz));
        classes.forEach(clazz -> {
            try {
                this.dialogProcessingClasses.put(clazz.getName(), (DialogProcessing)Utils.newInstance((String)clazz.getName(), DialogProcessing.class));
            }
            catch (BGException e) {
                logger.error((Object)e);
            }
        });
        this.getCustomProcessingFromDynCode().forEach(clazz -> this.dialogProcessingClasses.put(clazz.getClass().getName(), (DialogProcessing)clazz));
    }

    private List<DialogProcessing> getCustomProcessingFromDynCode() throws BGException {
        ArrayList<DialogProcessing> result = new ArrayList<DialogProcessing>();
        DynamicCodeService dynamicCodeService = (DynamicCodeService)this.serverContext.getService(DynamicCodeService.class, 0);
        List dynamicClasses = dynamicCodeService.getDynamicClassesByInterface(DialogProcessing.class.getName());
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        dynamicClasses.forEach(dynamicClass -> {
            try {
                DialogProcessing dialogProcessing = (DialogProcessing)dynamicClassManager.newInstance(DialogProcessing.class, dynamicClass.getClassName());
                if (dialogProcessing != null) {
                    result.add(dialogProcessing);
                }
            }
            catch (BGException ex) {
                logger.error((Object)ex);
            }
        });
        return result;
    }

    public void startBot(String token) throws BGException {
        this.getBotByToken(token).startBot();
    }

    public void stopBot(String token) throws BGException {
        this.getBotByToken(token).stopBot();
    }

    public void startAllBots() {
        this.bots.forEach((token, bot) -> bot.startBot());
    }

    public void stopAllBots() {
        this.bots.forEach((token, bot) -> bot.stopBot());
    }

    public synchronized void hotSwapBotData(Bot bot) throws BGException {
        RuntimeBot runtimeBot = this.bots.get(bot.getToken());
        if (runtimeBot == null) {
            runtimeBot = BotManagment.convertBotToRuntimeBot(bot);
            this.bots.put(bot.getToken(), runtimeBot);
            if (bot.getState() == 1) {
                runtimeBot.startBot();
            }
        } else {
            this.bots.put(bot.getToken(), BotManagment.convertBotToRuntimeBot(bot, runtimeBot));
            if (runtimeBot.getBotState() == 1) {
                runtimeBot.startBot();
            } else if (runtimeBot.getBotState() == 0) {
                runtimeBot.stopBot();
            }
        }
    }

    private RuntimeBot getBotByToken(String token) throws BGException {
        RuntimeBot runtimeBot = this.bots.get(token);
        if (runtimeBot == null) {
            throw new BGException("\u0411\u043e\u0442 \u0441 \u0442\u0430\u043a\u0438\u043c \u0442\u043e\u043a\u0435\u043d\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0431\u043e\u0442\u043e\u0432");
        }
        return runtimeBot;
    }

    public static BotManagment getInstance() {
        return instance;
    }

    public Map<String, RuntimeBot> getBots() {
        return this.bots;
    }

    public RuntimeBot getBot(String token) {
        return this.bots.get(token);
    }

    public RuntimeBot getBot(int botId) throws NoSuchElementException {
        return this.bots.values().stream().filter(bot -> bot.getBotId() == botId).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public Map<String, DialogProcessing> getDialogProcessingClasses() {
        return this.dialogProcessingClasses;
    }
}

