<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#8212;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:svg="http://www.w3.org/2000/svg" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:st="bitel.billing.common.SummaToString"
	xmlns:utils="ru.bitel.bgbilling.server.util.ServerUtils"
	xmlns:counter="bitel.billing.server.util.exslt.Counter">
	
	<xalan:component prefix="st" functions="summaToString">
   		<xalan:script lang="javaclass" src="xalan://bitel.billing.common.SummaToString"/>
  	</xalan:component>
	<xalan:component prefix="counter" functions="add set get">
   		<xalan:script lang="javaclass" src="xalan://bitel.billing.server.util.exslt.Counter"/>
  	</xalan:component>

	<xsl:output encoding="UTF-8" method='xml' indent='yes' />

	<!-- РЕКВИЗИТЫ ПРЕДПРИЯТИЯ -->	
	<xsl:variable name="orgTitle" select="//data/act/organization/param[@name='title']/@value" />
	<xsl:variable name="orgDirectorPost" select="//data/act/organization/param[@name='directorPost']/@value" />
	<xsl:variable name="orgDirectorFIO" select="//data/act/organization/param[@name='directorFIO']/@value" />
	<!-- РЕКВИЗИТЫ ПРЕДПРИЯТИЯ -->

	<xsl:variable name="s-quote">'</xsl:variable>

	<xsl:attribute-set name="text">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_title">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="start-indent">0cm</xsl:attribute>
		<xsl:attribute name="end-indent">0cm</xsl:attribute>
		<xsl:attribute name="space-before">0cm</xsl:attribute>
		<xsl:attribute name="space-after">0cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_title1">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0cm</xsl:attribute>
		<xsl:attribute name="end-indent">0cm</xsl:attribute>
		<xsl:attribute name="space-before">0cm</xsl:attribute>
		<xsl:attribute name="space-after">0cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:template match="data">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<xsl:apply-templates select="act" />
		</fo:root>
	</xsl:template>
	
	<xsl:template match="act">

 		<fo:layout-master-set>
			<fo:simple-page-master master-name="first"
				margin-left="15mm" margin-right="15mm"
				margin-top="15mm" margin-bottom="15mm"  
				page-width="29.7cm" page-height="21cm">
				<fo:region-body margin-top="0cm" margin-bottom="0cm" />
				<fo:region-before extent="0cm" />
				<fo:region-after extent="0cm" />
			</fo:simple-page-master>
		</fo:layout-master-set>

		<fo:page-sequence master-reference="first">
			<fo:flow flow-name="xsl-region-body" font-family="sans-serif">
			
				<!-- заголовок -->
				<fo:block xsl:use-attribute-sets="text_title">АКТ СВЕРКИ</fo:block>
				<fo:block xsl:use-attribute-sets="text_title1">взаимных расчетов за период <xsl:value-of select="@periodFrom"/>&nbsp;-&nbsp;<xsl:value-of select="@periodTo"/> по состоянию на <xsl:value-of select="@date" /></fo:block>
				<fo:block xsl:use-attribute-sets="text_title1">между <xsl:value-of select="@contractOrgName" /> и <xsl:value-of select="$orgTitle"/></fo:block>
				<!-- заголовок -->
				
				<fo:block xsl:use-attribute-sets="text" text-align="justify" space-before="5mm" space-after="5mm">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Мы, нижеподписавшиеся 
				<xsl:value-of select="$orgTitle" />, с одной стороны, и <xsl:value-of select="@contractOrgName" />, с другой стороны, составили настоящий
				акт сверки в том, что состояние взаимных расчетов по данным учета следующее:</fo:block>

				<!-- начало таблицы -->
				<fo:table table-layout="fixed" border-collapse="collapse" font-size="6pt" border-width="0.7pt" border-style="solid">
					<fo:table-column column-width="15mm" border-right-style="solid"/>
					<fo:table-column column-width="80mm" border-right-style="solid"/>
					<fo:table-column column-width="19mm" border-right-style="solid"/>
					<fo:table-column column-width="19mm" border-right-style="solid"/>
					<fo:table-column column-width="15mm" border-right-style="solid"/>
					<fo:table-column column-width="80mm" border-right-style="solid"/>
					<fo:table-column column-width="19mm" border-right-style="solid"/>
					<fo:table-column column-width="19mm" border-right-style="solid"/>
		
					<fo:table-body>
						<!-- первая строка -->
						<fo:table-row text-align="left" display-align="center" font-size="7pt" font-weight="bold" border-bottom-style="solid">
							<fo:table-cell number-columns-spanned="4" padding="0.5mm"><fo:block>По данным <xsl:value-of select="$orgTitle" />, руб.</fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="4" padding="0.5mm"><fo:block>По данным <xsl:value-of select="@contractOrgName" />, руб.</fo:block></fo:table-cell>
						</fo:table-row>
		
						<!-- вторая строка -->
						<fo:table-row text-align="center" display-align="center" font-weight="bold" height="5mm" border-bottom-style="solid">
							<fo:table-cell><fo:block>Дата</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Наименование операции, документы</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Дебет</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Кредит</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Дата</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Наименование операции, документы</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Дебет</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Кредит</fo:block></fo:table-cell>
						</fo:table-row>

						<xsl:call-template name="row2">
						    <xsl:with-param name="type" select="-1"/>
						</xsl:call-template>
						<xsl:for-each select="/data/act/contracts/contract">
							<fo:table-row text-align="center" display-align="center" border-bottom-style="solid" height="8pt" font-weight="bold">
								<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
								<fo:table-cell padding-left="3mm"><fo:block>Договор № <xsl:value-of select="@title"/> от <xsl:value-of select="@dateFrom"/></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
								<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
								<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
								<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
								<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
								<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
							</fo:table-row>
							<xsl:call-template name="row1">
							    <xsl:with-param name="contractId" select="@id"/>
							</xsl:call-template>
						</xsl:for-each>
						<xsl:call-template name="row2">
						    <xsl:with-param name="type" select="-2"/>
						</xsl:call-template>
					</fo:table-body>
				</fo:table>

				<fo:table table-layout="fixed" font-size="7pt" space-before="5mm">
					<fo:table-column column-width="95mm"/>
					<fo:table-column column-width="38mm"/>
					<fo:table-column column-width="95mm"/>
					<fo:table-column column-width="38mm"/>
		
					<fo:table-body>
						<fo:table-row text-align="left" display-align="center">
							<fo:table-cell number-columns-spanned="2" padding="0.5mm"><fo:block>По данным <xsl:value-of select="$orgTitle" /></fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2" padding="0.5mm"><fo:block>По данным <xsl:value-of select="@contractOrgName" /></fo:block></fo:table-cell>
						</fo:table-row>
						<fo:table-row text-align="left" display-align="center" height="10mm" font-weight="bold">
							<fo:table-cell number-columns-spanned="2" padding-right="2mm"><fo:block>на <xsl:value-of select="@date"/> 
							<xsl:choose>
								<xsl:when test="number(accountReport[position()=last()]/@debetSum) &gt; 0"> задолженность в пользу <xsl:value-of select="$orgTitle" /> &nbsp; <xsl:value-of select="utils:replace(utils:formatNumber(accountReport[position()=last()]/@debetSum + 0, '###,###,##0.00'),'.','-')"/> руб. (<xsl:value-of select="st:summaToString(accountReport[position()=last()]/@debetSum)" />)</xsl:when>
								<xsl:when test="number(accountReport[position()=last()]/@creditSum) &gt; 0"> задолженность в пользу <xsl:value-of select="@contractOrgName" /> &nbsp;<xsl:value-of select="utils:replace(utils:formatNumber(accountReport[position()=last()]/@creditSum + 0, '###,###,##0.00'),'.','-')"/> руб. (<xsl:value-of select="st:summaToString(accountReport[position()=last()]/@creditSum)" />)</xsl:when>
								<xsl:otherwise> задолженность отсутствует.</xsl:otherwise>
							</xsl:choose>
							</fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2" padding="0.5mm"><fo:block/></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
							
				<fo:table table-layout="fixed" font-size="7pt" space-before="10mm">				
					<fo:table-column column-width="130mm"/>
					<fo:table-column column-width="3mm"/>
					<fo:table-column column-width="133mm"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell><fo:block>От <xsl:value-of select="$orgTitle"/></fo:block></fo:table-cell>
							<fo:table-cell><fo:block/></fo:table-cell>
							<fo:table-cell><fo:block>От <xsl:value-of select="@contractOrgName"/></fo:block></fo:table-cell>
						</fo:table-row>
						<fo:table-row height="6mm" font-weight="bold" display-align="after">
							<fo:table-cell><fo:block><xsl:value-of select="$orgDirectorPost"/></fo:block></fo:table-cell>
							<fo:table-cell><fo:block/></fo:table-cell>
							<fo:table-cell><fo:block><fo:table><fo:table-column column-width="60mm"/><fo:table-body><fo:table-row><fo:table-cell border-width="0.7pt" border-bottom-style="solid"><fo:block/></fo:table-cell></fo:table-row></fo:table-body></fo:table></fo:block></fo:table-cell>
						</fo:table-row>
						<fo:table-row height="10mm" display-align="center">
							<fo:table-cell><fo:block>
								<fo:table table-layout="fixed" width="100mm">
									<fo:table-column column-width="60mm"/>
									<fo:table-column column-width="40mm"/>
									<fo:table-body>							
										<fo:table-row>
											<fo:table-cell border-width="0.7pt" border-bottom-style="solid"><fo:block/></fo:table-cell>
											<fo:table-cell><fo:block>&nbsp;&nbsp;&nbsp;/&nbsp;<xsl:value-of select="$orgDirectorFIO"/></fo:block></fo:table-cell>
										</fo:table-row>								
									</fo:table-body>
								</fo:table></fo:block>
							</fo:table-cell>
							<fo:table-cell><fo:block/></fo:table-cell>
							<fo:table-cell><fo:block>
								<fo:table table-layout="fixed" width="100mm">
									<fo:table-column column-width="60mm"/>
									<fo:table-column column-width="40mm"/>
									<fo:table-body>							
										<fo:table-row>
											<fo:table-cell border-width="0.7pt" border-bottom-style="solid"><fo:block/></fo:table-cell>
											<fo:table-cell><fo:block>&nbsp;&nbsp;&nbsp;/&nbsp;________________________</fo:block></fo:table-cell>
										</fo:table-row>								
									</fo:table-body>
								</fo:table></fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
	
			<xsl:if test="@with_stamp">
				<fo:block-container space-before="-20mm">
				<fo:table table-layout="fixed" width="100%">
					<fo:table-column column-width="1cm"/>
					<fo:table-column column-width="4.0cm"/>
					<fo:table-body>							
						<fo:table-row>
							<fo:table-cell><fo:block/></fo:table-cell>
							<fo:table-cell><fo:block><fo:external-graphic src="webroot/stamp.gif" width="4.1cm" height="3.85cm" content-height="3.85cm" content-width="4.1cm" space-before="0.2cm"/></fo:block></fo:table-cell>
						</fo:table-row>								
					</fo:table-body>
				</fo:table>
				</fo:block-container>	
			</xsl:if>
		</fo:flow>	
		</fo:page-sequence>

	</xsl:template>	

	<xsl:template name="row2">
		<xsl:param name="type"/>
			<xsl:for-each select="/data/act/accountReport[@type=$type]">
				<fo:table-row text-align="right" display-align="center" border-bottom-style="solid" height="8pt" font-style="italic">
					<fo:table-cell><fo:block text-align="center"><xsl:value-of select="utils:dateToString(@createDate, concat('yyyy-MM-dd',$s-quote,'T',$s-quote,'HH:mm:ssXXX'), 'dd.MM.yyyy')"/></fo:block></fo:table-cell>
					<fo:table-cell padding-left="0.5mm"><fo:block text-align="left"><xsl:value-of select="@document"/></fo:block></fo:table-cell>
					<fo:table-cell padding-right="0.5mm"><fo:block><xsl:choose><xsl:when test="@debetSum=0"></xsl:when><xsl:otherwise><xsl:value-of select="utils:replace(utils:formatNumber(@debetSum + 0, '###,###,##0.00'),'.','-')"/></xsl:otherwise></xsl:choose></fo:block></fo:table-cell>
					<fo:table-cell padding-right="0.5mm"><fo:block><xsl:choose><xsl:when test="@creditSum=0"></xsl:when><xsl:otherwise><xsl:value-of select="utils:replace(utils:formatNumber(@creditSum + 0, '###,###,##0.00'),'.','-')"/></xsl:otherwise></xsl:choose></fo:block></fo:table-cell>
					<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
					<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
					<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
					<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
				</fo:table-row>
			</xsl:for-each>
	</xsl:template>

	<xsl:template name="row1">
		<xsl:param name="contractId"/>
			<xsl:for-each select="/data/act/accountReport[@contractId=$contractId and @type &gt; 0]">
				<fo:table-row text-align="right" display-align="center" border-bottom-style="solid" height="8pt">
					<fo:table-cell><fo:block text-align="center"><xsl:value-of select="utils:dateToString(@createDate, concat('yyyy-MM-dd',$s-quote,'T',$s-quote,'HH:mm:ssXXX'), 'dd.MM.yyyy')"/></fo:block></fo:table-cell>
					<fo:table-cell padding-left="0.5mm"><fo:block text-align="left"><xsl:value-of select="@document"/></fo:block></fo:table-cell>
					<fo:table-cell padding-right="0.5mm"><fo:block><xsl:choose><xsl:when test="@debetSum=0"></xsl:when><xsl:otherwise><xsl:value-of select="utils:replace(utils:formatNumber(@debetSum + 0, '###,###,##0.00'),'.','-')"/></xsl:otherwise></xsl:choose></fo:block></fo:table-cell>
					<fo:table-cell padding-right="0.5mm"><fo:block><xsl:choose><xsl:when test="@creditSum=0"></xsl:when><xsl:otherwise><xsl:value-of select="utils:replace(utils:formatNumber(@creditSum + 0, '###,###,##0.00'),'.','-')"/></xsl:otherwise></xsl:choose></fo:block></fo:table-cell>
					<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
					<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
					<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
					<fo:table-cell><fo:block>&nbsp;</fo:block></fo:table-cell>
				</fo:table-row>
			</xsl:for-each>
	</xsl:template>


</xsl:stylesheet>