/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.assistant.client.AssistantActionBaseDialog;
import ru.bitel.bgbilling.plugins.assistant.client.AssistantActionDialog;
import ru.bitel.bgbilling.plugins.assistant.client.AssistantListCellRenderer;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.common.client.BGUAction;

public class AssistantActionListDialog
extends AssistantActionBaseDialog {
    private BGToolBar toolBar = new BGToolBar();
    private DefaultListModel<AssistantActionItem> listModel = new DefaultListModel();
    private JList<AssistantActionItem> list = new JList<AssistantActionItem>(this.listModel);
    private JPanel buttonPanel = new JPanel(new GridLayout(0, 3, 5, 5));
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);

    public AssistantActionListDialog(ClientContext clientContext) {
        super(clientContext);
        this.setTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435");
        this.initToolBar();
        this.initCardPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.cardPanel, "Center");
        this.pack();
        this.setSize(600, 400);
        this.moveWindowToCenterScreen();
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        this.list.setCellRenderer(new AssistantListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AssistantActionItem assistantActionItem;
                if (mouseEvent.getClickCount() == 2 && (assistantActionItem = AssistantActionListDialog.this.list.getSelectedValue()) != null) {
                    AssistantActionListDialog.this.openAssistantActionDialog(assistantActionItem.getActionId());
                }
            }
        });
        this.listModel.removeAllElements();
        try {
            this.getAssistantService().assistantActionsForUser(this.getContext().getContractId()).stream().filter(i -> !i.isDependent()).forEach(i -> this.listModel.addElement((AssistantActionItem)i));
            ActionListener buttonActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AssistantActionListDialog.this.openAssistantActionDialog(actionEvent.getActionCommand());
                }
            };
            Dimension dimension = new Dimension(150, 100);
            int size = this.listModel.getSize();
            for (int index = 0; index < size; ++index) {
                AssistantActionItem assistantActionItem = this.listModel.get(index);
                JButton button = new JButton(assistantActionItem.getTitle());
                button.setActionCommand(assistantActionItem.getActionId());
                button.addActionListener(buttonActionListener);
                button.setMinimumSize(dimension);
                button.setPreferredSize(dimension);
                this.buttonPanel.add(button);
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void openAssistantActionDialog(String actionId) {
        this.setVisible(false);
        this.dispose();
        try {
            AssistantActionDialog assistantActionDialog = new AssistantActionDialog(actionId, this.getContext());
            assistantActionDialog.showAction(null);
            assistantActionDialog.setVisible(true);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void initToolBar() {
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.toolBar.add((Action)new BGUAction("list", "\u0421\u043f\u0438\u0441\u043e\u043a", ClientUtils.getIcon((String)"list")){

            public void actionPerformed(ActionEvent actionEvent) {
                AssistantActionListDialog.this.setShowMode("list");
            }
        });
        this.toolBar.add((Action)new BGUAction("icons", "\u0418\u043a\u043e\u043d\u043a\u0438", ClientUtils.getIcon((String)"icons")){

            public void actionPerformed(ActionEvent actionEvent) {
                AssistantActionListDialog.this.setShowMode("icons");
            }
        });
        this.toolBar.add(Box.createHorizontalGlue());
    }

    private void setShowMode(String mode) {
        this.cardLayout.show(this.cardPanel, mode);
        ClientSetup.getInstance().getUserConfig().set("assistant.actions.mode", mode);
        ClientSetup.getInstance().saveUserConfig();
    }

    private void initCardPanel() {
        this.cardPanel.add((Component)this.getListPanel(), "list");
        this.cardPanel.add((Component)this.getIconsPanel(), "icons");
        String mode = ClientSetup.getInstance().getUserConfig().get("assistant.actions.mode");
        if (mode != null) {
            this.cardLayout.show(this.cardPanel, mode);
        }
    }

    private JPanel getListPanel() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getIconsPanel() {
        JScrollPane iconsPanel = new JScrollPane();
        iconsPanel.setBorder(null);
        iconsPanel.setViewportView(this.buttonPanel);
        iconsPanel.revalidate();
        iconsPanel.setVerticalScrollBarPolicy(20);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)iconsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }
}

