/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.client;

import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.TransactionStatus;
import ru.bitel.common.Utils;

public abstract class TransactionTableModel
extends AbstractTransactionTableModel<Transaction> {
    public static final String COLUMN_INVOICE_ID = "invoiceId";
    public static final String COLUMN_CANCELLATION_DETAILS = "cancellationDetails";
    public static final String COLUMN_CONTRACT_COMMENT = "contractComment";
    public static final String COLUMN_ORDER_SUM_AMOUNT = "orderSumAmount";
    public static final String COLUMN_ORDER_SUM_CURRENCY_PAYCASH = "orderSumCurrencyPaycash";
    public static final String COLUMN_ORDER_SUM_BANK_PAYCASH = "orderSumBankPaycash";
    public static final String COLUMN_SHOP_SUM_AMOUNT = "shopSumAmount";
    public static final String COLUMN_SHOP_SUM_CURRENCY_PAYCASH = "shopSumCurrencyPaycash";
    public static final String COLUMN_SHOP_SUM_BANK_PAYCASH = "shopSumBankPaycash";
    public static final String COLUMN_PAYMENT_PAYER_CODE = "paymentPayerCode";
    public static final String COLUMN_PAYMENT_DATE_TIME = "paymentDateTime";
    public static final String COLUMN_PAYMENT_TYPE = "paymentType";
    public static final String COLUMN_TITLE_INVOICE_ID = "YoomoneyID";
    public static final String COLUMN_TITLE_CONTRACT_COMMENT = "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
    public static final String COLUMN_TITLE_PAYMENT_DATE_TIME = "\u0412\u0440\u0435\u043c\u044f \u043e\u043f\u043b\u0430\u0442\u044b";

    public TransactionTableModel(String name) {
        super(name, Transaction.class);
    }

    public Object getValue(Transaction value, int column) throws BGException {
        String identifier = this.getIdentifier(column);
        if (identifier.equals(COLUMN_ORDER_SUM_CURRENCY_PAYCASH)) {
            return value != null && value.getOrderSumCurrencyPaycash() != null ? value.getOrderSumCurrencyPaycash().getGuiTitle() : "";
        }
        if (identifier.equals(COLUMN_SHOP_SUM_CURRENCY_PAYCASH)) {
            return value != null && value.getShopSumCurrencyPaycash() != null ? value.getShopSumCurrencyPaycash().getGuiTitle() : "";
        }
        if (identifier.equals(COLUMN_ORDER_SUM_BANK_PAYCASH)) {
            return value != null && value.getOrderSumBankPaycash() != null ? value.getOrderSumBankPaycash().getGuiTitle() : "";
        }
        if (identifier.equals(COLUMN_SHOP_SUM_BANK_PAYCASH)) {
            return value != null && value.getShopSumBankPaycash() != null ? value.getShopSumBankPaycash().getGuiTitle() : "";
        }
        if (identifier.equals(COLUMN_ORDER_SUM_AMOUNT)) {
            return value != null ? value.getSum() : "";
        }
        if (identifier.equals(COLUMN_SHOP_SUM_AMOUNT)) {
            return value != null ? value.getShopSumAmount() : "";
        }
        if (identifier.equals(COLUMN_INVOICE_ID)) {
            String result = "";
            if (value != null) {
                long invoiceId = value.getInvoiceId();
                result = invoiceId == 0L ? value.getYoomoneyId() : String.valueOf(invoiceId);
            }
            return result;
        }
        if (COLUMN_CANCELLATION_DETAILS.equals(identifier)) {
            Object result = "";
            if (value.getStatus().equals(TransactionStatus.CANCELED.getCode())) {
                try {
                    JSONObject jsonObject = new JSONObject(value.getRawRequest());
                    Object party = jsonObject.optQuery("/object/cancellation_details/party");
                    Object reason = jsonObject.optQuery("/object/cancellation_details/reason");
                    if (party != null || reason != null) {
                        String sparty = party != null ? String.valueOf(party) : null;
                        String sreason = reason != null ? String.valueOf(reason) : null;
                        result = Transaction.getCancelComment((String)sparty, (String)sreason) + " (" + Utils.maskNull((String)sparty) + ":" + Utils.maskNull((String)sreason) + ")";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        return super.getValue((Object)value, column);
    }
}

