/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.common.service.YoomoneyService;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.event.YoomoneyAutopaymentEvent;
import ru.bitel.bgbilling.modules.yoomoney.server.event.YoomoneyCheckEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.yoomoney.common.service.YoomoneyService")
public class YoomoneyServiceImpl
extends AbstractService
implements YoomoneyService {
    private final Logger logger = LogManager.getLogger();

    public SearchResult<Transaction> searchTransactionList(int contractId, String contractTitle, Period period, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page, sort);
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            transactionManager.searchTransactionList((SearchResult<Transaction>)searchResult, contractId, contractTitle, null);
        }
        return searchResult;
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        String failureUrl;
        if (contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (url == null) {
            throw new BGIllegalArgumentException("url");
        }
        if (mode != null) {
            mode.value = "redirect";
        }
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGIllegalArgumentException();
        }
        ModuleSetup moduleSetup = this.getModuleSetup();
        BigDecimal sumMin = moduleSetup.getBigDecimal("yoomoney.sum.min", new BigDecimal(100));
        BigDecimal sumMax = moduleSetup.getBigDecimal("yoomoney.sum.max", new BigDecimal(5000));
        BigDecimal sum = amount.setScale(2, RoundingMode.HALF_EVEN);
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
        }
        Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
        String successUrl = (String)params.get("successUrl");
        if (Utils.isBlankString((String)successUrl)) {
            successUrl = moduleSetup.get("yoomoney.shopSuccessURL", "");
        }
        if (Utils.isBlankString((String)(failureUrl = (String)params.get("failureUrl")))) {
            failureUrl = moduleSetup.get("yoomoney.shopFailURL", "");
        }
        String paymentType = (String)params.get("paymentType");
        String contractTitle = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(contractId)).getContractTitle();
        String formUrl = "";
        if (moduleSetup.get("yoomoney.api.key") != null) {
            try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
                JSONObject data = transactionManager.getPaymentRequestJSON(sum, contractId, contractTitle);
                String resultJson = transactionManager.doPaymentRequest(data.toString(), Setup.getSetup().get("billing.name", "") + System.currentTimeMillis());
                if (resultJson != null) {
                    JSONObject result = new JSONObject(resultJson);
                    formUrl = String.valueOf(result.optQuery("/confirmation/confirmation_url"));
                }
                this.logger.error("resultJson = " + resultJson);
            }
        } else {
            formUrl = moduleSetup.get("yoomoney.url", "") + "?mid=" + this.moduleId + "&shopId=" + moduleSetup.get("yoomoney.shopId", "") + "&scid=" + moduleSetup.get("yoomoney.scid", "") + "&CustomerNumber=" + contractTitle + "&paymentType=" + (paymentType != null ? paymentType : "") + "&Sum=" + sum.toPlainString() + "&shopSuccessURL=" + successUrl + "&shopFailURL=" + failureUrl;
        }
        url.value = formUrl;
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
    }

    public void checkTransaction(String yoomoneyId) throws BGException {
        EventProcessor.getInstance().publish((Event)new YoomoneyCheckEvent(this.moduleId, 0, yoomoneyId));
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        autopaymentManager.close();
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
        if (contractId > 0) {
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
            autopaymentManager.close();
            if (autopayment != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
                try {
                    EventProcessor.getInstance().publish((Event)new YoomoneyAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
                }
                catch (BGException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

