/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.wm.server.servlet;

import java.io.IOException;
import java.sql.Connection;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.wm.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.wm.server.bean.WMRequest;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.bootstrap.Shutdown;

@WebServlet(name="WebMoneyExecutor", urlPatterns={"/wmexecuter"})
public class ModuleExecutor
extends CommonExecutor {
    private static final Logger log = LogManager.getLogger();
    private Boolean exit = false;
    private Integer prerequestDim = 0;

    public void init() {
        this.setup = Setup.getSetup();
        Shutdown.addShutdownHook((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                log.debug("Stopping WM...");
                Boolean bl = ModuleExecutor.this.exit;
                synchronized (bl) {
                    ModuleExecutor.this.exit = true;
                }
                int i = 0;
                while ((i < 2 || ModuleExecutor.this.prerequestDim != 0) && i++ <= 10) {
                    try {
                        1 var2_4 = this;
                        synchronized (var2_4) {
                            this.wait(500L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                log.debug("WM stopped. PrerequestDim=" + ModuleExecutor.this.prerequestDim);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block14: {
            Integer mid = 0;
            Integer cid = 0;
            try {
                mid = Utils.parseInt((String)request.getParameter("mid"));
                cid = Utils.parseInt((String)request.getParameter("cid"));
                if (mid == null || cid == null || mid <= 0 || cid <= 0) break block14;
                Connection con = this.setup.getDBConnectionFromPool();
                try {
                    ModuleSetup moduleSetup = new ModuleSetup(con, mid.intValue());
                    int mode = this.exit == false ? moduleSetup.getInt("wm.mode", 0) : 0;
                    TransactionManager transactionManager = new TransactionManager(con, mid);
                    WMRequest wmRequest = WMRequest.loadRequest((Preferences)moduleSetup, request);
                    int result = transactionManager.checkAndUpdateWMPayment(cid, wmRequest, mode);
                    transactionManager.close();
                    if (result == 0) {
                        if (wmRequest.isPrerequest()) {
                            Integer n = this.prerequestDim;
                            this.prerequestDim = this.prerequestDim + 1;
                        } else {
                            Integer n = this.prerequestDim;
                            this.prerequestDim = this.prerequestDim - 1;
                        }
                        response.getOutputStream().print("YES");
                        response.getOutputStream().close();
                    } else if ((result & 0x800) > 0) {
                        response.getOutputStream().write("\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442".getBytes("UTF-8"));
                        response.getOutputStream().close();
                    } else {
                        response.getOutputStream().write(("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + result).getBytes("UTF-8"));
                        response.getOutputStream().close();
                        if (log.isDebugEnabled()) {
                            log.debug("WMExecuter -> merchant request error: " + result + " remote host: " + request.getRemoteHost());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection((Connection)con);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

