/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDestinationService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;

public class VoiceDestinationPanel
extends BGUPanel {
    private static final String SET_DATA_ACTION = "setData";
    private static final VoiceOperator NOT_SELECTED_OPERATOR_ITEM = new VoiceOperator(0, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
    private BGUTable destinationTable;
    private DestinationTablModel destinationTableModel;
    private BGUComboBox<VoiceOperator> operatorFilter;
    private BGTextField titleFilter;
    private BGControlPanelPages pagePanel;
    private JLabel recordCountLabel;
    private VoiceDestinationService destinationService;
    private VoiceOperatorService operatorService;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            VoiceOperator selectedItem = (VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem();
            DefaultComboBoxModel<VoiceOperator> operatorFilterModel = new DefaultComboBoxModel<VoiceOperator>(VoiceDestinationPanel.this.operatorService.voiceOperatorList().toArray(new VoiceOperator[0]));
            operatorFilterModel.insertElementAt(NOT_SELECTED_OPERATOR_ITEM, 0);
            VoiceDestinationPanel.this.operatorFilter.setModel(operatorFilterModel);
            if (selectedItem != null) {
                VoiceDestinationPanel.this.operatorFilter.setSelectedItem((Object)selectedItem);
            } else {
                VoiceDestinationPanel.this.operatorFilter.setSelectedIndex(0);
            }
        }
    };
    AbstractBGUPanel.DefaultAction setDataAction = new AbstractBGUPanel.DefaultAction("setData", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            boolean showMainPanel;
            VoiceOperator oper = (VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem();
            boolean bl = showMainPanel = oper.getId() == 0 || oper.isUseCustomGeoDict();
            if (!showMainPanel) {
                VoiceDestinationPanel.this.destinationTableModel.setData(new ArrayList());
                VoiceDestinationPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: 0");
                VoiceDestinationPanel.this.pagePanel.setPage(new Page());
                return;
            }
            int operator = ((VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem()).getId();
            String title = VoiceDestinationPanel.this.titleFilter.getText();
            Holder pageHolder = new Holder((Object)VoiceDestinationPanel.this.pagePanel.getPage());
            Holder destinations = new Holder();
            VoiceDestinationPanel.this.destinationService.voiceDestinationList(operator, title, pageHolder, destinations);
            List destinationList = (List)VoiceCommonUtils.readFromHolder((Holder)destinations);
            if (destinationList != null) {
                VoiceDestinationPanel.this.destinationTableModel.setData(destinationList);
            }
            VoiceDestinationPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + ((Page)pageHolder.value).getRecordCount());
            VoiceDestinationPanel.this.pagePanel.setPage((Page)pageHolder.value);
        }
    };

    public VoiceDestinationPanel() {
        super((LayoutManager)new GridBagLayout());
    }

    protected void jbInit() throws Exception {
        this.operatorService = (VoiceOperatorService)((ClientContext)this.getContext()).getPort(VoiceOperatorService.class);
        this.destinationService = (VoiceDestinationService)((ClientContext)this.getContext()).getPort(VoiceDestinationService.class);
        this.destinationTableModel = new DestinationTablModel(DestinationTablModel.class.getName());
        this.destinationTable = new BGUTable((TableModel)((Object)this.destinationTableModel));
        this.titleFilter = new BGTextField(20);
        this.titleFilter.getDocument().addDocumentListener(new TitleDocumentListener());
        this.operatorFilter = new BGUComboBox();
        this.operatorFilter.addActionListener(l -> this.performAction(SET_DATA_ACTION));
        BGEditor editor = new BGEditor();
        editor.setVisible(false);
        editor.addForm((JComponent)((Object)new VoiceDestinationEditorForm()));
        this.pagePanel = new BGControlPanelPages();
        this.pagePanel.addPropertyChangeListener(l -> this.performAction(SET_DATA_ACTION));
        this.recordCountLabel = new JLabel();
        int gridx = 0;
        JPanel navigationPanel = new JPanel(new GridBagLayout());
        navigationPanel.add((Component)new JLabel("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        navigationPanel.add((Component)this.operatorFilter, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        navigationPanel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        navigationPanel.add((Component)this.titleFilter, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        navigationPanel.add((Component)this.recordCountLabel, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0));
        navigationPanel.add((Component)this.pagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)navigationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)new JScrollPane((Component)this.destinationTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        mainPanel.add((Component)editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 3, 3, 3), 0, 0));
        this.performAction("refresh");
        BGSwingUtilites.handleEdit((JTable)this.destinationTable, (AbstractBGUPanel)editor);
    }

    class DestinationTablModel
    extends BGTableModel<VoiceDestination> {
        public DestinationTablModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, -1, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440", -1, -1, -1, "", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(VoiceDestination val, int column) throws BGException {
            if (column == 2) {
                VoiceOperator operator = null;
                if (val.getOperatorId() > 0) {
                    operator = VoiceDestinationPanel.this.operatorService.voiceOperatorGet(val.getOperatorId());
                }
                String value = null;
                if (operator != null) {
                    value = operator.getTitle();
                }
                return value;
            }
            return super.getValue((Object)val, column);
        }
    }

    private class TitleDocumentListener
    implements DocumentListener {
        private TitleDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.process(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.process(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.process(e);
        }

        private void process(DocumentEvent e) {
            Document doc = e.getDocument();
            if (doc.getLength() <= 0 || doc.getLength() >= 2) {
                VoiceDestinationPanel.this.performAction(VoiceDestinationPanel.SET_DATA_ACTION);
            }
        }
    }

    private class VoiceDestinationEditorForm
    extends BGUPanel {
        private BGTextField destinationTitle;
        private VoiceDestination currentDestination;

        private VoiceDestinationEditorForm() {
        }

        protected void jbInit() throws Exception {
            this.destinationTitle = new BGTextField();
            BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ");
            this.setLayout(new GridBagLayout());
            this.add(new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f* "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)this.destinationTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u043e\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    boolean showMainPanel;
                    VoiceOperator oper = (VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem();
                    boolean bl = showMainPanel = oper.getId() == 0 || oper.isUseCustomGeoDict();
                    if (!showMainPanel) {
                        ClientUtils.showErrorMessageDialog((String)"\u0414\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e!");
                        return;
                    }
                    VoiceDestinationEditorForm.this.performActionOpen();
                    VoiceDestinationEditorForm.this.currentDestination = new VoiceDestination();
                    VoiceDestinationEditorForm.this.destinationTitle.setText("");
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VoiceDestinationEditorForm.this.currentDestination = (VoiceDestination)VoiceDestinationPanel.this.destinationTableModel.getSelectedRow();
                    if (VoiceDestinationEditorForm.this.currentDestination == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                        return;
                    }
                    VoiceDestinationEditorForm.this.performActionOpen();
                    VoiceDestinationEditorForm.this.destinationTitle.setText(VoiceDestinationEditorForm.this.currentDestination.getTitle());
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    List selectedDestinationList = VoiceDestinationPanel.this.destinationTableModel.getSelectedRows();
                    if (selectedDestinationList == null || selectedDestinationList.isEmpty()) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 (\u044f) \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                        return;
                    }
                    String message = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 " + ((VoiceDestination)selectedDestinationList.get(0)).getTitle();
                    if (selectedDestinationList.size() > 1) {
                        message = message + ", " + ((VoiceDestination)selectedDestinationList.get(1)).getTitle() + ", ...";
                    }
                    message = message + "?";
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                        VoiceDestinationPanel.this.destinationService.voiceDestinationDelete(Utils.getIdList((Collection)selectedDestinationList));
                        VoiceDestinationEditorForm.this.hideEditorAndRefresh();
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    String title = VoiceDestinationEditorForm.this.destinationTitle.getText();
                    VoiceOperator operator = (VoiceOperator)VoiceDestinationPanel.this.operatorFilter.getSelectedItem();
                    if (Utils.isBlankString((String)title)) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f!");
                        return;
                    }
                    VoiceDestinationEditorForm.this.currentDestination.setTitle(title);
                    if (operator != null && !operator.equals((Object)NOT_SELECTED_OPERATOR_ITEM)) {
                        VoiceDestinationEditorForm.this.currentDestination.setOperatorId(operator.getId());
                    }
                    VoiceDestinationPanel.this.destinationService.voiceDestinationUpdate(VoiceDestinationEditorForm.this.currentDestination);
                    VoiceDestinationEditorForm.this.hideEditorAndRefresh();
                }
            };
        }

        public void hideEditorAndRefresh() {
            VoiceDestinationPanel.this.performAction(VoiceDestinationPanel.SET_DATA_ACTION);
            this.performActionClose();
        }
    }
}

