/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.event.om;

import java.sql.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;

@EventType(autoAcknowledge=false)
@XmlRootElement
public class OmVoiceAccountModifyEvent
extends QueueEvent {
    private static Logger logger = LogManager.getLogger();
    private final int deviceId;
    private final VoiceAccount oldAccount;
    private final VoiceAccount newAccount;
    private final short newState;
    private boolean fireDeviceStateCnanged = true;

    public OmVoiceAccountModifyEvent() {
        super(-1, -1, -1);
        this.deviceId = -1;
        this.oldAccount = null;
        this.newAccount = null;
        this.newState = (short)-1;
    }

    public OmVoiceAccountModifyEvent(int moduleId, int deviceId, VoiceAccount oldAccount, VoiceAccount newAccount, short newState) {
        super(moduleId, CONTRACT_GLOBAL, 0);
        this.deviceId = deviceId;
        this.oldAccount = oldAccount;
        this.newAccount = newAccount;
        this.newState = newState;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        if (this.oldAccount != null) {
            message.setIntProperty("deviceId", this.oldAccount.getDeviceId());
        } else {
            message.setIntProperty("deviceId", this.newAccount.getDeviceId());
        }
    }

    public AccountOrderEvent toAccountOrderEvent(VoiceApplication application, Connection con) throws BGException {
        short deviceState;
        int eventType;
        int accountId;
        AccountOrderEvent result = null;
        if (this.oldAccount != null && this.newAccount != null) {
            accountId = this.newAccount.getId();
            eventType = 2;
        } else if (this.newAccount != null) {
            accountId = this.newAccount.getId();
            eventType = 1;
        } else {
            accountId = this.oldAccount.getId();
            eventType = 3;
        }
        VoiceAccountRuntimeMap accountRuntimeMap = application.getVoiceAccountRuntimeMap();
        VoiceAccountRuntime accountRuntime = accountRuntimeMap.get(accountId);
        if (accountRuntime == null) {
            switch (eventType) {
                case 1: {
                    accountRuntime = accountRuntimeMap.addRuntime(con, this.newAccount);
                    break;
                }
                case 3: {
                    accountRuntime = accountRuntimeMap.createRuntime(con, this.oldAccount);
                    break;
                }
                default: {
                    logger.error("AccountRuntime not found with AccountId=" + accountId);
                    return null;
                }
            }
            deviceState = -1;
        } else {
            deviceState = ((VoiceAccount)accountRuntime.getAccount()).getDeviceState();
        }
        result = new AccountOrderEvent(this.deviceId, eventType, this.oldAccount, this.newAccount, deviceState, this.newState);
        result.setFireDeviceStateCnanged(this.fireDeviceStateCnanged);
        return result;
    }

    public short getNewState() {
        return this.newState;
    }

    public boolean isFireDeviceStateCnanged() {
        return this.fireDeviceStateCnanged;
    }

    public void setFireDeviceStateCnanged(boolean fireDeviceStateCnanged) {
        this.fireDeviceStateCnanged = fireDeviceStateCnanged;
    }
}

