/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.contract.object.bean.ModuleEntity;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.event.om.OmVoiceAccountStateModifyEvent;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.TimeUtils;

public class Module
extends ModuleBase
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static final String[] PACKAGES = new String[]{Module.class.getPackage().getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void notify(Event event, EventListenerContext eventListenerContext) throws BGException {
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        if (!(event instanceof ContractCreateEvent)) {
            if (event instanceof ContractDeleteEvent) {
                this.contractDelete(serverContext, moduleId, (ContractDeleteEvent)event);
            } else if (event instanceof ContractCloseEvent) {
                this.contractClose(serverContext, moduleId, (ContractCloseEvent)event);
            } else if (event instanceof ContractWrapEvent || event instanceof ObjectMoveEvent) {
                // empty if block
            }
        }
    }

    private void contractDelete(ServerContext serverContext, int moduleId, ContractDeleteEvent contractDeleteEvent) throws BGException {
        VoiceAccountService accountService = (VoiceAccountService)serverContext.getService(VoiceAccountService.class, moduleId);
        if (contractDeleteEvent.isCheck()) {
            try {
                List accounts = accountService.voiceAccountList(contractDeleteEvent.getContractId(), 0, null);
                for (VoiceAccount account : accounts) {
                    accountService.checkVoiceAccountIsActive(account);
                }
            }
            catch (BGException ex) {
                contractDeleteEvent.setError(ModuleCache.getInstance().getModule(moduleId).getTitle() + ": " + ex.getMessage());
            }
        } else {
            List accounts = accountService.voiceAccountList(contractDeleteEvent.getContractId(), 0, null);
            for (VoiceAccount account : accounts) {
                accountService.voiceAccountDelete(account.getId());
            }
        }
    }

    private void contractClose(ServerContext serverContext, int moduleId, ContractCloseEvent contractCloseEvent) throws BGException {
        VoiceAccountService accountService = (VoiceAccountService)serverContext.getService(VoiceAccountService.class, moduleId);
        List accounts = accountService.voiceAccountList(contractCloseEvent.getContractId(), 0, null);
        if (contractCloseEvent.isCheck()) {
            for (VoiceAccount ac : accounts) {
                if (ac.getDateTo() == null || TimeUtils.dateBeforeOrEq((Date)ac.getDateTo(), (Date)contractCloseEvent.getDate())) continue;
                contractCloseEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0441\u0435\u0440\u0432\u0438\u0441 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.");
                break;
            }
        } else {
            Date now = new Date();
            for (VoiceAccount ac : accounts) {
                if (ac.getDateTo() != null && !TimeUtils.dateBefore((Date)now, (Date)ac.getDateTo())) continue;
                ac.setDateTo(contractCloseEvent.getDate());
                accountService.voiceAccountUpdate(ac);
            }
        }
    }

    public void lockServiceNow(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.lockService(con, moduleId, contractRuntime, balance, limit, lightweight);
    }

    public void lockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        try {
            EventProcessor ep = EventProcessor.getInstance();
            try (VoiceAccountDao voiceAccountDao = new VoiceAccountDao(con, moduleId);){
                List<VoiceAccount> accountList = voiceAccountDao.list(contractRuntime.contractId);
                for (VoiceAccount account : accountList) {
                    if (account.getDeviceState() != 1) continue;
                    logger.info("Sending state disable to account[id: " + account.getId() + "]");
                    ep.publish((Event)new OmVoiceAccountStateModifyEvent(moduleId, account, 0));
                }
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void unlockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        try {
            EventProcessor ep = EventProcessor.getInstance();
            try (VoiceAccountDao voiceAccountDao = new VoiceAccountDao(con, moduleId);){
                List<VoiceAccount> accountList = voiceAccountDao.list(contractRuntime.contractId);
                for (VoiceAccount account : accountList) {
                    if (account.getDeviceState() != 0) continue;
                    logger.info("Sending state enable to account[id: " + account.getId() + "]");
                    ep.publish((Event)new OmVoiceAccountStateModifyEvent(moduleId, account, 1));
                }
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void unlockServiceNow(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.unlockService(con, moduleId, contractRuntime, balance, limit, lightweight);
    }

    public void serializeContract(Connection con, int contractId, int moduleId, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String contractIdStr = String.valueOf(contractId);
        String tableAccountBase = "voice_account_base_" + moduleId;
        String tableClientAccount = "voice_account_" + moduleId;
        String query = "SELECT voice_account.id AS id, voice_account.number AS number, voice_account.comment AS comment, voice_account.password AS password, voice_account.status AS status, voice_account.contractObjectId AS contractObjectId, account_base.title AS title, account_base.dateFrom AS dateFrom, account_base.dateTo As dateTo, account_base.typeId As typeId, account_base.deviceId As deviceId FROM " + tableClientAccount + " AS voice_account LEFT JOIN " + tableAccountBase + " AS account_base ON account_base.id=voice_account.id WHERE account_base.contractId=" + contractIdStr + " ORDER BY number";
        try (Statement st = con.createStatement();){
            new XMLDatabaseSerializer(tables).addItemsFromRS("voice_account", null, null, st.executeQuery(query));
        }
    }

    public List<ModuleEntity> getObjectEntities(Connection con, int moduleId, int objectId) throws BGException {
        ArrayList<ModuleEntity> result = new ArrayList<ModuleEntity>();
        try (ContractObjectDao objectDao = new ContractObjectDao(con, 0);
             VoiceAccountDao accountDao = new VoiceAccountDao(con, moduleId);){
            ContractObject object = (ContractObject)objectDao.get(objectId);
            for (VoiceAccount voiceAccount : accountDao.list(object.getContractId())) {
                if (voiceAccount.getContractObjectId() != objectId) continue;
                ModuleEntity entity = new ModuleEntity();
                entity.setName("\u0410\u043a\u043a\u0430\u0443\u043d\u0442");
                entity.setData(voiceAccount.getTitle());
                entity.setComment(voiceAccount.getComment());
                entity.setPeriod(TimeUtils.formatPeriod((Date)voiceAccount.getDateFrom(), (Date)voiceAccount.getDateTo()));
                result.add(entity);
            }
        }
        return result;
    }
}

