/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class TvSearchPanel
extends BGUTabPanel {
    private JTextField login = new JTextField();
    private JTextField extId = new JTextField();
    private JTextField id = new JTextField();
    private JTextField identifier = new JTextField();
    private JTextField macAddress = new JTextField();
    private BGUComboBox<TvAccountSpec> serviceType = new BGUComboBox();
    private TvAccountService tvAccountService = (TvAccountService)((ClientContext)this.getContext()).getPort(TvAccountService.class);
    private TVAccountTableModel model = new TVAccountTableModel(TVAccountTableModel.class.getName());
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            List typeList = TvSearchPanel.this.tvAccountService.tvAccountSpecList();
            TvAccountSpec anyType = new TvAccountSpec();
            anyType.setTitle("\u041b\u044e\u0431\u043e\u0439");
            anyType.setId(0);
            typeList.add(0, anyType);
            TvSearchPanel.this.serviceType.setData(typeList);
        }
    };
    AbstractBGUPanel.DefaultAction find = new AbstractBGUPanel.DefaultAction("find", "\u041d\u0430\u0439\u0442\u0438"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TvAccountSpec selectedType = (TvAccountSpec)TvSearchPanel.this.serviceType.getSelectedItem();
            int idValue = Utils.parseInt((String)TvSearchPanel.this.id.getText(), (int)-1);
            if (!Utils.isBlankString((String)TvSearchPanel.this.id.getText()) && idValue == -1) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d ID!");
                return;
            }
            if (idValue > 0) {
                ArrayList<TvAccount> list = new ArrayList<TvAccount>();
                TvAccount tvAccount = TvSearchPanel.this.tvAccountService.tvAccountGet(((ClientContext)TvSearchPanel.this.getContext()).getContractId(), idValue);
                if (tvAccount != null) {
                    list.add(tvAccount);
                }
                TvSearchPanel.this.model.setData(list);
            } else if (selectedType != null) {
                TvSearchPanel.this.model.setData(TvSearchPanel.this.tvAccountService.tvAccountSearch(TvSearchPanel.this.login.getText(), TvSearchPanel.this.extId.getText(), selectedType.getId(), TvSearchPanel.this.identifier.getText(), TvSearchPanel.this.macAddress.getText(), false));
            } else {
                TvSearchPanel.this.model.setData(TvSearchPanel.this.tvAccountService.tvAccountSearch(TvSearchPanel.this.login.getText(), TvSearchPanel.this.extId.getText(), 0, TvSearchPanel.this.identifier.getText(), TvSearchPanel.this.macAddress.getText(), false));
            }
        }
    };

    public TvSearchPanel(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TvSearchPanel.this.openContract(((TvAccount)TvSearchPanel.this.model.getSelectedRow()).getContractId());
                }
            }
        });
        this.setLayout(new GridBagLayout());
        JPanel loginPanel = new JPanel(new GridBagLayout());
        loginPanel.setBorder((Border)new BGTitleBorder("\u041b\u043e\u0433\u0438\u043d"));
        BGButton clearLogin = new BGButton("X");
        clearLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvSearchPanel.this.login.setText("");
            }
        });
        loginPanel.add((Component)this.login, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        loginPanel.add((Component)clearLogin, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel ipPanel = new JPanel(new GridBagLayout());
        ipPanel.setBorder((Border)new BGTitleBorder("ExtID"));
        BGButton clearIp = new BGButton("X");
        clearIp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvSearchPanel.this.extId.setText("");
            }
        });
        ipPanel.add((Component)this.extId, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        ipPanel.add((Component)clearIp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel vlanPanel = new JPanel(new GridBagLayout());
        vlanPanel.setBorder((Border)new BGTitleBorder("ID"));
        BGButton clearVlan = new BGButton("X");
        clearVlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvSearchPanel.this.id.setText("");
            }
        });
        vlanPanel.add((Component)this.id, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        vlanPanel.add((Component)clearVlan, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel identifierPanel = new JPanel(new GridBagLayout());
        identifierPanel.setBorder((Border)new BGTitleBorder("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440"));
        BGButton clearIdentifier = new BGButton("X");
        clearIdentifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvSearchPanel.this.identifier.setText("");
            }
        });
        identifierPanel.add((Component)this.identifier, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        identifierPanel.add((Component)clearIdentifier, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel macAddressPanel = new JPanel(new GridBagLayout());
        macAddressPanel.setBorder((Border)new BGTitleBorder("MAC-\u0430\u0434\u0440\u0435\u0441"));
        BGButton clearMacAddress = new BGButton("X");
        clearMacAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvSearchPanel.this.macAddress.setText("");
            }
        });
        macAddressPanel.add((Component)this.macAddress, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        macAddressPanel.add((Component)clearMacAddress, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.setBorder((Border)new BGTitleBorder("\u0422\u0438\u043f \u0441\u0435\u0440\u0432\u0438\u0441\u0430"));
        typePanel.add((Component)this.serviceType, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        BGButton searchButton = new BGButton((Action)this.find);
        this.login.setAction((Action)this.find);
        this.extId.setAction((Action)this.find);
        this.id.setAction((Action)this.find);
        this.identifier.setAction((Action)this.find);
        this.macAddress.setAction((Action)this.find);
        this.add(loginPanel, new GridBagConstraints(0, 0, 1, 1, 0.8, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(ipPanel, new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(typePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(identifierPanel, new GridBagConstraints(0, 1, 1, 1, 0.8, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(macAddressPanel, new GridBagConstraints(1, 1, 1, 1, 0.2, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(vlanPanel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)searchButton, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(8, 5, 2, 5), 0, 0));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private class TVAccountTableModel
    extends BGTableModel<TvAccount> {
        public TVAccountTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 120, 150, 150, "contractTitle", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 120, 150, -1, "contractComment", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 150, -1, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 160, 160, 160, null, true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(TvAccount tvAccount, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("contractTitle".equals(identifier)) {
                return tvAccount.getContractTitle();
            }
            if ("contractComment".equals(identifier)) {
                return tvAccount.getContractComment();
            }
            switch (column) {
                case 4: {
                    return TimeUtils.formatPeriod((Date)tvAccount.getDateFrom(), (Date)tvAccount.getDateTo());
                }
            }
            return super.getValue((Object)tvAccount, column);
        }
    }
}

