/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;

public class MultCostTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<ServiceCost>, TariffContext> {
    private final BigDecimal multiplicand;

    public MultCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
    }

    public int executeImpl(Long treeNodeId, AbstractTariffRequest<ServiceCost> req, TariffContext ctx) {
        int result;
        if (req.serviceCost != null) {
            if (req.serviceCost.cost != null) {
                req.serviceCost.cost = req.serviceCost.cost.multiply(this.multiplicand, ctx.mc);
                result = 1;
            } else {
                result = 0;
            }
        } else {
            result = 0;
            for (Map.Entry e : req.getServiceCost().entrySet()) {
                List serviceCostList = (List)e.getValue();
                if (serviceCostList == null) continue;
                int jsize = serviceCostList.size();
                for (int j = 0; j < jsize; ++j) {
                    ServiceCost serviceCost = (ServiceCost)serviceCostList.get(j);
                    if (serviceCost.cost == null) continue;
                    result = 1;
                    if (BigDecimal.ZERO.compareTo(serviceCost.cost) == 0) continue;
                    serviceCost.cost = serviceCost.cost.multiply(this.multiplicand, ctx.mc);
                }
            }
        }
        return result;
    }
}

