/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.event.access.om;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AbstractOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.ProductEntry;
import ru.bitel.bgbilling.apps.tv.access.om.ProductOrderEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;
import ru.bitel.oss.systems.inventory.service.common.event.ServiceEntry;

@EventType(autoAcknowledge=false, timeToLive=691200000L)
@XmlRootElement
@XmlSeeAlso(value={ru.bitel.oss.systems.inventory.product.common.event.ProductEntry.class})
public class OmTvProductsModifyEvent
extends QueueEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(OmTvProductsModifyEvent.class);
    private static final Logger logger = LogManager.getLogger();
    @XmlAttribute
    private final int tvAccountId;
    @XmlAttribute
    private final int deviceId;
    @XmlElementWrapper(name="productEntryList")
    @XmlElements(value={@XmlElement(name="entry")})
    private final List<ru.bitel.oss.systems.inventory.product.common.event.ProductEntry> productEntryList;
    @XmlAttribute
    private final Set<Integer> optionIds;

    protected OmTvProductsModifyEvent() {
        this.deviceId = -1;
        this.tvAccountId = -1;
        this.productEntryList = null;
        this.optionIds = null;
    }

    public OmTvProductsModifyEvent(int moduleId, int contractId, int userId, int deviceId, int tvAccountId, List<ru.bitel.oss.systems.inventory.product.common.event.ProductEntry> productEntryList, Set<Integer> optionIds) {
        super(moduleId, contractId, userId);
        this.deviceId = deviceId;
        this.tvAccountId = tvAccountId;
        this.productEntryList = productEntryList;
        this.optionIds = optionIds != null && optionIds.size() == 0 ? null : optionIds;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductOrderEvent toOmEvent(TvAccess access, ConnectionSet connectionSet, Date now) throws BGException {
        TvAccountRuntime tvAccountRuntime = access.tvAccountRuntimeMap.get(Integer.valueOf(this.tvAccountId));
        if (tvAccountRuntime == null) {
            logger.error("InetServ not found with id=" + this.tvAccountId);
            return null;
        }
        tvAccountRuntime.lock();
        try {
            ProductOrderEvent productOrderEvent = this.toOmEventImpl(access, connectionSet, tvAccountRuntime, now);
            return productOrderEvent;
        }
        finally {
            tvAccountRuntime.unlock();
        }
    }

    private ProductOrderEvent toOmEventImpl(TvAccess access, ConnectionSet connectionSet, TvAccountRuntime tvAccountRuntime, Date now) throws BGException {
        Set<Integer> newDeviceOptionIds;
        Product product;
        ProductRuntimeList.ProductItem productItem;
        TvAccount tvAccount = tvAccountRuntime.getTvAccount();
        if (tvAccount.getParentId() > 0) {
            logger.error("TvAccount is child " + this.tvAccountId);
            return null;
        }
        List childrenAccounts = AbstractOrderEvent.getTvAccountChildren((TvAccountRuntimeMap)access.tvAccountRuntimeMap, (int)tvAccount.getId(), (long)now.getTime());
        tvAccount.setChildren(childrenAccounts);
        ArrayList<ProductEntry> productEntryList = new ArrayList<ProductEntry>();
        HashSet<Integer> add = new HashSet<Integer>();
        HashSet<Integer> remove = new HashSet<Integer>();
        try {
            this.filterProductSpecByDepends(access.productSpecRuntimeMap, tvAccountRuntime, now, add, remove);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        ArrayList<ru.bitel.oss.systems.inventory.product.common.event.ProductEntry> productEntryListModified = new ArrayList<ru.bitel.oss.systems.inventory.product.common.event.ProductEntry>(this.productEntryList);
        for (Integer id : add) {
            productItem = tvAccountRuntime.getProductRuntimeList().itemByProductId(id.intValue());
            if (productItem == null || productItem.deviceState == 1) continue;
            product = productItem.toProduct(tvAccount.getContractId(), this.tvAccountId);
            productEntryListModified.add(new ru.bitel.oss.systems.inventory.product.common.event.ProductEntry(product, product, productItem.deviceState, 1));
        }
        for (Integer id : remove) {
            productItem = tvAccountRuntime.getProductRuntimeList().itemByProductId(id.intValue());
            if (productItem == null || productItem.deviceState == 0) continue;
            product = productItem.toProduct(tvAccount.getContractId(), this.tvAccountId);
            productEntryListModified.add(new ru.bitel.oss.systems.inventory.product.common.event.ProductEntry(product, product, productItem.deviceState, 0));
        }
        for (ru.bitel.oss.systems.inventory.product.common.event.ProductEntry e : productEntryListModified) {
            ServiceSpecRuntime serviceSpecRuntime;
            Service service;
            Product product2 = e.getNewProduct() != null ? e.getNewProduct() : e.getOldProduct();
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)access.productSpecRuntimeMap.get(product2.getProductSpecId());
            ArrayList<ru.bitel.bgbilling.apps.tv.access.om.ServiceEntry> serviceEntryList = new ArrayList<ru.bitel.bgbilling.apps.tv.access.om.ServiceEntry>();
            if (e.getServiceEntryList() != null) {
                for (ServiceEntry serviceEntry : e.getServiceEntryList()) {
                    service = serviceEntry.getNewService() != null ? serviceEntry.getNewService() : serviceEntry.getOldService();
                    serviceSpecRuntime = (ServiceSpecRuntime)access.serviceSpecRuntimeMap.get(service.getServiceSpecId());
                    serviceEntryList.add(new ru.bitel.bgbilling.apps.tv.access.om.ServiceEntry(serviceSpecRuntime, serviceEntry.getOldService(), serviceEntry.getNewService(), serviceEntry.getOldState(), serviceEntry.getNewState()));
                }
            } else {
                for (ServiceRuntimeList.ServiceItem serviceItem : tvAccountRuntime.getServiceRuntimeList().listByProductId(product2.getId())) {
                    service = serviceItem.toService(tvAccount.getContractId(), this.tvAccountId);
                    serviceSpecRuntime = (ServiceSpecRuntime)access.serviceSpecRuntimeMap.get(service.getServiceSpecId());
                    serviceEntryList.add(new ru.bitel.bgbilling.apps.tv.access.om.ServiceEntry(serviceSpecRuntime, service, service, serviceItem.deviceState, e.getNewState()));
                }
            }
            ProductEntry productEntry = new ProductEntry(productSpecRuntime, e.getOldProduct(), e.getNewProduct(), e.getOldState(), e.getNewState(), serviceEntryList);
            productEntryList.add(productEntry);
        }
        Set<Integer> oldDeviceOptionIds = tvAccount.getDeviceOptionIds();
        if (oldDeviceOptionIds == null) {
            oldDeviceOptionIds = Collections.emptySet();
        }
        if ((newDeviceOptionIds = access.tvAccountOptionSet(connectionSet, tvAccountRuntime, now)) == null) {
            newDeviceOptionIds = oldDeviceOptionIds;
        }
        ProductOrderEvent result = new ProductOrderEvent(access, (Event)this, 0, tvAccountRuntime, 2, tvAccount.getId(), ((TvAccountSpecRuntime)tvAccountRuntime.tvAccountSpecRef.get()).tvAccountSpec, tvAccount, productEntryList, oldDeviceOptionIds, newDeviceOptionIds, 0);
        return result;
    }

    protected final void filterProductSpecByDepends(ProductSpecRuntimeMap productSpecRuntimeMap, TvAccountRuntime tvAccountRuntime, Date now, Set<Integer> add, Set<Integer> remove) throws BGException {
        ProductPeriodRuntimeList.ProductPeriodItem item;
        int i;
        ProductPeriodRuntimeList productPeriodRuntimeList = tvAccountRuntime.getProductPeriodRuntimeList();
        ProductRuntimeList productRuntimeList = tvAccountRuntime.getProductRuntimeList();
        HashMap<Integer, Integer> mustBeActiveProductIds = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> activeProductIds = new HashMap<Integer, Integer>();
        long millis = now.getTime();
        int size = productPeriodRuntimeList.size();
        for (i = 0; i < size; ++i) {
            item = (ProductPeriodRuntimeList.ProductPeriodItem)productPeriodRuntimeList.item(i);
            if (item.timeFrom > millis && item.timeFrom != 0L || item.timeTo < millis && item.timeTo != 0L) continue;
            mustBeActiveProductIds.put(item.productId, item.productSpecId);
        }
        size = productRuntimeList.size();
        for (i = 0; i < size; ++i) {
            item = (ProductRuntimeList.ProductItem)productRuntimeList.get(i);
            if (!(item.timeFrom > millis && item.timeFrom != 0L || item.timeTo < millis && item.timeTo != 0L)) {
                if (item.deviceState != 1) continue;
                activeProductIds.put(item.productId, item.id);
                continue;
            }
            mustBeActiveProductIds.remove(item.productId);
        }
        HashMap<Integer, Integer> mustBeActiveProductIds2 = new HashMap<Integer, Integer>(mustBeActiveProductIds);
        HashMap<Integer, Integer> activeProductIds2 = new HashMap<Integer, Integer>(activeProductIds);
        HashSet<Integer> affectedProductIds = new HashSet<Integer>();
        for (ru.bitel.oss.systems.inventory.product.common.event.ProductEntry e : this.productEntryList) {
            Product product = e.getNewProduct() != null ? e.getNewProduct() : e.getOldProduct();
            affectedProductIds.add(product.getId());
            if (e.getNewState() == 1) {
                activeProductIds2.put(product.getId(), product.getProductSpecId());
                mustBeActiveProductIds2.put(product.getId(), product.getProductSpecId());
            } else {
                activeProductIds2.remove(product.getId());
                mustBeActiveProductIds2.remove(product.getId());
            }
            if (e.getOldState() == 1) {
                activeProductIds.put(product.getId(), product.getProductSpecId());
                mustBeActiveProductIds.put(product.getId(), product.getProductSpecId());
                continue;
            }
            activeProductIds.remove(product.getId());
            mustBeActiveProductIds.remove(product.getId());
        }
        Set<Integer> filteredMustBeActiveProductIds = this.filterProductSpecByDepends(productSpecRuntimeMap, mustBeActiveProductIds);
        Set<Integer> filteredMustBeActiveProductIds2 = this.filterProductSpecByDepends(productSpecRuntimeMap, mustBeActiveProductIds2);
        filteredMustBeActiveProductIds2.removeAll(filteredMustBeActiveProductIds);
        filteredMustBeActiveProductIds2.removeAll(affectedProductIds);
        add.addAll(filteredMustBeActiveProductIds2);
        Set<Integer> filteredActiveProductIds = this.filterProductSpecByDepends(productSpecRuntimeMap, activeProductIds);
        Set<Integer> filteredActiveProductIds2 = this.filterProductSpecByDepends(productSpecRuntimeMap, activeProductIds2);
        filteredActiveProductIds.removeAll(filteredActiveProductIds2);
        filteredActiveProductIds.removeAll(affectedProductIds);
        remove.addAll(filteredActiveProductIds);
    }

    protected final Set<Integer> filterProductSpecByDepends(ProductSpecRuntimeMap productSpecRuntimeMap, Map<Integer, Integer> idMap) throws BGException {
        HashMap filteredMap;
        boolean needCheck;
        HashMap<Integer, ProductSpecRuntime> map = new HashMap<Integer, ProductSpecRuntime>();
        for (Map.Entry<Integer, Integer> e : idMap.entrySet()) {
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(e.getValue().intValue());
            if (productSpecRuntime == null) continue;
            map.put(e.getValue(), productSpecRuntime);
        }
        do {
            needCheck = false;
            filteredMap = new HashMap(map);
            for (ProductSpecRuntime productSpecRuntime : map.values()) {
                ProductSpec productSpec = productSpecRuntime.getProductSpec();
                if (productSpec.getDepends() == null || productSpec.getDepends().size() <= 0 || !Collections.disjoint(productSpec.getDepends(), filteredMap.keySet()) || filteredMap.remove(productSpec.getId()) == null) continue;
                needCheck = true;
            }
            map = filteredMap;
        } while (needCheck);
        HashSet<Integer> result = new HashSet<Integer>();
        for (Map.Entry<Integer, Integer> e : idMap.entrySet()) {
            if (!filteredMap.containsKey(e.getValue())) continue;
            result.add(e.getKey());
        }
        return result;
    }

    protected void toString(StringBuilder sb) {
        super.toString(sb);
        if (this.productEntryList != null) {
            int size = this.productEntryList.size();
            for (int i = 0; i < size; ++i) {
                sb.append("\n\t\t").append(this.productEntryList.get(i));
            }
        }
    }
}

