/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.commons.io.FilenameUtils;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.modules.softline.common.bean.Product;
import ru.bitel.bgbilling.modules.softline.common.bean.ProductCategory;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.TypeProduct;
import ru.bitel.bgbilling.modules.softline.common.service.ProductService;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;
import ru.bitel.bgbilling.modules.softline.server.bean.ProductCategoryDao;
import ru.bitel.bgbilling.modules.softline.server.bean.ProductDao;
import ru.bitel.bgbilling.modules.softline.server.filestorage.SoftlineCategoryFileStorage;
import ru.bitel.bgbilling.modules.softline.server.filestorage.SoftlineProductFileStorage;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.softline.common.service.ProductService")
public class ProductServiceImpl
extends AbstractService
implements ProductService {
    private ProductDao productDao;
    private ProductCategoryDao productCategoryDao;

    @PostConstruct
    public void init() {
        this.productDao = new ProductDao(this.getConnection(), this.moduleId);
        this.productCategoryDao = new ProductCategoryDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<Product> getProducts(Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setList(new ArrayList());
        this.productDao.getProducts((SearchResult<Product>)searchResult);
        return searchResult;
    }

    public void updateProduct(Product product) throws BGException {
        this.productDao.update(product);
    }

    public void deleteProduct(Product product) throws BGException {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        SoftLineSubscriptionService subscriptionService = (SoftLineSubscriptionService)serverContext.getService(SoftLineSubscriptionService.class, this.moduleId);
        List subscriptions = subscriptionService.searchSubscriptions(null, null, -1, -1, null, product.getId()).getList();
        if (subscriptions != null && subscriptions.size() > 0) {
            for (SoftLineSubscription subscription : subscriptions) {
                subscriptionService.deleteSubscription(subscription, true);
            }
        }
        this.productDao.delete(product.getId());
    }

    public List<Product> getProductsOfCategory(int productCategoryId) throws BGException {
        return this.productDao.getProductsOfCategory(productCategoryId);
    }

    public Product getProduct(int productId) throws BGException {
        return (Product)this.productDao.get(productId);
    }

    public SearchResult<ProductCategory> getProductCategories(Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setList(new ArrayList());
        this.productCategoryDao.getList((SearchResult<ProductCategory>)searchResult);
        return searchResult;
    }

    public ProductCategory getCategoryOfProduct(int productCategoryId) throws BGException {
        return (ProductCategory)this.productCategoryDao.get(productCategoryId);
    }

    public void updateProductCategory(ProductCategory productCategory) throws BGException {
        this.productCategoryDao.update(productCategory);
    }

    public void deleteProductCategory(ProductCategory productCategory) throws BGException {
        for (Product product : this.getProductsOfCategory(productCategory.getId())) {
            product.setProductCategoryId(0);
            this.productDao.update(product);
        }
        this.productCategoryDao.delete(productCategory.getId());
    }

    public void setProductPicture(int id, byte[] picture, TypeProduct type) throws BGException {
        try {
            if (picture != null) {
                String prefix = type == TypeProduct.PRODUCT ? "product_picture_" : "product_category_picture_";
                ByteArrayInputStream is = new ByteArrayInputStream(picture);
                BGServerFile bgFile = new BGServerFile();
                bgFile.setTitle(prefix + id + ".png");
                bgFile.setSize((long)((InputStream)is).available());
                bgFile.setOwnerId(id);
                bgFile.setComment("");
                bgFile.setDate(new Date());
                FileStorage fileStorage = this.getFileStorage(type);
                fileStorage.updateFile(bgFile);
                if (bgFile.getId() > 0) {
                    String extension = FilenameUtils.getExtension((String)bgFile.getTitle());
                    fileStorage.saveStream(bgFile.getId(), (InputStream)is, Utils.isBlankString((String)extension) ? "" : extension);
                }
            }
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    public byte[] getProductPicture(int productId, TypeProduct type) throws BGException {
        String path;
        File file;
        FileStorage fileStorage = this.getFileStorage(type);
        List files = fileStorage.getFilesListByOwner(productId);
        if (files != null && files.size() > 0 && (file = new File(path = fileStorage.getFileName(((BGServerFile)files.get(0)).getId()))).exists()) {
            byte[] byArray;
            FileInputStream fis = new FileInputStream(file);
            try {
                byte[] bytesPicture = new byte[(int)file.length()];
                fis.read(bytesPicture);
                byArray = bytesPicture;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            fis.close();
            return byArray;
        }
        return new byte[0];
    }

    public void getProductPicture0(int productId, Holder<DataHandler> fileData, TypeProduct type) throws BGException {
        FileStorage fileStorage = this.getFileStorage(type);
        List files = fileStorage.getFilesListByOwner(productId);
        if (files != null && files.size() > 0) {
            try {
                fileData.value = new DataHandler(fileStorage.getDataSource(((BGServerFile)files.get(0)).getId()));
            }
            catch (FileNotFoundException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    private FileStorage getFileStorage(TypeProduct type) throws BGException {
        return type == TypeProduct.PRODUCT ? new SoftlineProductFileStorage(this.getConnection(), this.moduleId) : new SoftlineCategoryFileStorage(this.getConnection(), this.moduleId);
    }
}

