/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sbpilot.server;

import java.io.IOException;
import java.util.stream.Collectors;
import javax.jws.WebService;
import ru.bitel.bgbilling.apps.cashcheck.frk.common.CmdProtocolClient;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.sbpilot.common.BGTerminalNotloggedMessageException;
import ru.bitel.bgbilling.plugins.sbpilot.common.SBPilotRemoteService;
import ru.bitel.bgbilling.plugins.sbpilot.common.bean.SbPilotPayment;
import ru.bitel.bgbilling.plugins.sbpilot.server.bean.SBPilotTerminal;
import ru.bitel.bgbilling.plugins.sbpilot.server.bean.SBPilotTerminalManager;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.sbpilot.common.SBPilotRemoteService")
public class SBPilotRemoteServiceImpl
extends AbstractService
implements SBPilotRemoteService {
    public SbPilotPayment doPayment(String summa) throws BGException {
        String paymentReply = this.request("\u043e\u043f\u043b\u0430\u0442\u044b", "payment", summa);
        SbPilotPayment payment = new SbPilotPayment();
        payment.fromJson(paymentReply);
        return payment;
    }

    public void doX0() throws BGException {
        this.request("\u0441\u043d\u044f\u0442\u0438\u044f X-\u043e\u0442\u0447\u0451\u0442\u0430(0)", "X0", new Object[0]);
    }

    public void doX1() throws BGException {
        this.request("\u0441\u043d\u044f\u0442\u0438\u044f X-\u043e\u0442\u0447\u0451\u0442\u0430(1)", "X1", new Object[0]);
    }

    public void doZ() throws BGException {
        this.request("\u0441\u043d\u044f\u0442\u0438\u044f Z-\u043e\u0442\u0447\u0451\u0442\u0430", "Z", new Object[0]);
    }

    public void doCancel13(String summa, String authcode) throws BGException {
        this.request("\u043e\u0442\u043c\u0435\u043d\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", "cancel13", summa, authcode);
    }

    public void doRepeat() throws BGException {
        this.request("\u043f\u043e\u0432\u0442\u043e\u0440\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0447\u0435\u043a\u0430", "repeat", new Object[0]);
    }

    public void doCancel8(String summa) throws BGMessageException, BGException {
        this.request("\u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043e\u043a\u0443\u043f\u043a\u0438", "cancel8", summa);
    }

    public void doCancel3(String summa) throws BGMessageException, BGException {
        this.request("\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430", "cancel3", summa);
    }

    public void doInfo() throws BGMessageException, BGException {
        this.request("\u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0438\u043d\u0444\u044b", "info", new Object[0]);
    }

    private String request(String cmdtitle, String command, Object ... parameters) throws BGException {
        String string;
        int terminalId = SBPilotTerminalManager.getCurrentTerminalId();
        if (terminalId <= 0) {
            throw new BGTerminalNotloggedMessageException("\u0422\u0435\u0440\u043c\u0438\u043d\u0430\u043b \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
        }
        SBPilotTerminal terminal = SBPilotTerminalManager.getTerminal(terminalId);
        CmdProtocolClient client = new CmdProtocolClient(terminal.getAddress(), terminal.getPort());
        try {
            client.connect();
            boolean result = client.send(command, parameters);
            if (!result) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b " + cmdtitle + "! sbpilot-\u0441\u0435\u0440\u0432\u0435\u0440 (" + terminal.getTitle() + ") \u0441\u043a\u0430\u0437\u0430\u043b: " + client.getReply());
            }
            string = client.getReply();
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 \u0441 sbpilot-\u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (" + terminal.getAddress() + ":" + terminal.getPort() + ") \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b " + cmdtitle + ":\n" + e.getMessage(), (Throwable)e);
            }
        }
        client.close();
        return string;
    }

    public void bindTerminal(int terminalId) throws BGException {
        if (terminalId <= 0) {
            SBPilotTerminalManager.setCurrentTerminal(0);
        } else {
            SBPilotTerminalManager.getTerminal(terminalId);
            SBPilotTerminalManager.setCurrentTerminal(terminalId);
        }
    }

    public Result<IdTitle> terminalList() throws BGException {
        Result rootNode = new Result(SBPilotTerminalManager.getTerminals().stream().map(p -> new IdTitle(p.getId(), p.getTitle())).collect(Collectors.toList()), null);
        rootNode.setAttribute("terminalId", (Object)SBPilotTerminalManager.getCurrentTerminalId());
        return rootNode;
    }
}

