/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.BGTableColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.rscm.common.service.RSCMService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public class SPP_PatternServices
extends BGPanel {
    private int currentRow = 0;
    private JPanel editorPanel = new JPanel();
    private BGTable table = new BGTable();
    private BGComboBox<ComboBoxItem> service = new BGComboBox();
    private IntTextField amount = new IntTextField();
    private JTextArea comment = new JTextArea();

    public SPP_PatternServices() {
        this.jbInit();
        int[] typeWidth = new int[]{150, 150, 150};
        int[] amountWidth = new int[]{100, 100, 100};
        int[] commentWidth = new int[]{-1, -1, -1};
        int[] noWidth = new int[]{0, 0, 0};
        this.table.addColumn(BGTableColumn.getInstance((String)"id", (String)"", (int[])noWidth, (boolean)false, (String)""));
        this.table.addColumn(BGTableColumn.getInstance((String)"service", (String)"\u0423\u0441\u043b\u0443\u0433\u0430", (int[])typeWidth, (boolean)false, (String)""));
        this.table.addColumn(BGTableColumn.getInstance((String)"amount", (String)"\u041a\u043e\u043b-\u0432\u043e", (int[])amountWidth, (boolean)false, (String)""));
        this.table.addColumn(BGTableColumn.getInstance((String)"comment", (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", (int[])commentWidth, (boolean)false, (String)""));
        this.editorPanel.setVisible(false);
    }

    private void jbInit() {
        JButton newButton = new JButton(ClientUtils.getIcon((String)"item_add"));
        newButton.setActionCommand("new");
        newButton.setPreferredSize(new Dimension(20, 20));
        newButton.setBorderPainted(false);
        JButton deleteButton = new JButton(ClientUtils.getIcon((String)"item_delete"));
        deleteButton.setActionCommand("delete");
        deleteButton.setPreferredSize(new Dimension(20, 20));
        deleteButton.setBorderPainted(false);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("new".equals(e.getActionCommand())) {
                    SPP_PatternServices.this.newItem();
                } else if ("delete".equals(e.getActionCommand())) {
                    SPP_PatternServices.this.deleteItem();
                }
            }
        };
        newButton.addActionListener(al);
        deleteButton.addActionListener(al);
        this.amount.setColumns(10);
        this.amount.setMinimumSize(new Dimension(100, 24));
        this.amount.setPreferredSize(new Dimension(100, 24));
        this.comment.setMargin(new Insets(3, 3, 3, 3));
        this.comment.setRows(5);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPP_PatternServices.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        });
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.editorPanel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.editorPanel.add((Component)this.service, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u041a\u043e\u043b-\u0432\u043e"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.editorPanel.add((Component)this.amount, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.editorPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 2, 6, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)okCancel, new GridBagConstraints(0, 3, 6, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SPP_PatternServices.this.editItem();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(newButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData() {
        try {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.service.getModel();
            model.removeAllElements();
            for (IdTitle idTitle : ((RSCMService)this.getContext().getPort(RSCMService.class)).getRSCMContractServiceList(false)) {
                model.addElement(new ComboBoxItem(idTitle.getId(), idTitle.getTitle()));
            }
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
    }

    public void serializeParams(Element currentServices) {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Element addCalculatedService = XMLUtils.createElement((Element)currentServices, (String)"addCalculatedService");
            addCalculatedService.setAttribute("id", (String)this.table.getValueAt(i, 0));
            addCalculatedService.setAttribute("amount", (String)this.table.getValueAt(i, 2));
            addCalculatedService.setAttribute("comment", (String)this.table.getValueAt(i, 3));
        }
    }

    public void setData(Element element) {
        this.table.removeRows();
        Element currentServices = XMLUtils.selectElement((Node)element, (String)("data/modules/rscm[@mid=" + this.getModuleId() + "]/currentServices"));
        if (currentServices != null) {
            NodeList nodes = currentServices.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!"addCalculatedService".equals(n.getNodeName())) continue;
                Element addCalculatedService = (Element)n;
                String serviceId = addCalculatedService.getAttribute("id");
                String curAmount = addCalculatedService.getAttribute("amount");
                String curComment = addCalculatedService.getAttribute("comment");
                String name = "";
                for (int j = 0; j < this.service.getItemCount(); ++j) {
                    ComboBoxItem item = (ComboBoxItem)this.service.getItemAt(j);
                    if (!serviceId.equals(item.getObject().toString())) continue;
                    name = item.toString();
                    break;
                }
                this.addRow(serviceId, curAmount, curComment, name);
            }
        } else {
            currentServices = element.getOwnerDocument().createElement("currentServices");
            element.appendChild(currentServices);
        }
    }

    private void addRow(String serviceId, String curAmount, String curComment, String name) {
        Vector<String> rowData = new Vector<String>();
        rowData.add(serviceId);
        rowData.add(name);
        rowData.add(curAmount);
        rowData.add(curComment);
        this.table.addRow(rowData);
    }

    private void stopEdit(boolean save) {
        if (save) {
            if (Utils.isEmptyString((String)this.amount.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
                return;
            }
            ComboBoxItem selected = (ComboBoxItem)this.service.getSelectedItem();
            String id = selected.getObject().toString();
            String name = selected.toString();
            String curAmount = this.amount.getText();
            String curComment = this.comment.getText();
            if (this.currentRow >= 0) {
                this.table.setValueAt((Object)id, this.currentRow, 0);
                this.table.setValueAt((Object)name, this.currentRow, 1);
                this.table.setValueAt((Object)curAmount, this.currentRow, 2);
                this.table.setValueAt((Object)curComment, this.currentRow, 3);
            } else {
                this.addRow(id, curAmount, curComment, name);
            }
        }
        this.editorPanel.setVisible(false);
    }

    public void deleteItem() {
        int row = this.table.getSelectedRow();
        if (row >= 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            this.table.removeRow(row);
        }
    }

    public void editItem() {
        this.currentRow = this.table.getSelectedRow();
        if (this.currentRow >= 0) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.currentRow = -1;
        this.startEdit();
    }

    private void startEdit() {
        String id = null;
        String amountText = "";
        String commentText = "";
        if (this.currentRow >= 0) {
            id = ClientUtils.getRowId((BGTable)this.table);
            amountText = String.valueOf(this.table.getValueAt(this.currentRow, 2));
            commentText = String.valueOf(this.table.getValueAt(this.currentRow, 3));
        }
        this.amount.setText(amountText);
        this.comment.setText(commentText);
        try {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.service.getModel();
            model.removeAllElements();
            for (IdTitle idTitle : ((RSCMService)this.getContext().getPort(RSCMService.class)).getRSCMContractServiceList(false)) {
                model.addElement(new ComboBoxItem(idTitle.getId(), idTitle.getTitle()));
            }
            ClientUtils.setComboBoxSelection(this.service, (Object)id);
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
        this.editorPanel.setVisible(true);
    }
}

