/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.server.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.server.bean.AbstractQiwiProtocol;
import ru.bitel.bgbilling.modules.qiwi.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.qiwi.server.ishop.ru.mw.ishop.server.IShopServerWS;
import ru.bitel.bgbilling.modules.qiwi.server.ishop.ru.mw.ishop.server.IShopServerWSService;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class QiwiSoap
extends AbstractQiwiProtocol {
    private static final Logger logger = LogManager.getLogger();

    public QiwiSoap(Connection connection, int moduleId, ModuleSetup moduleSetup) {
        super(connection, moduleId, moduleSetup);
    }

    @Override
    public String beginTransaction(int contractId, String phone, BigDecimal sum, String successUrl, String failUrl) throws BGException {
        String redirectUrl;
        block16: {
            if (logger.isDebugEnabled()) {
                logger.debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0443");
            }
            redirectUrl = null;
            try (TransactionManager manager = new TransactionManager(this.connection, this.moduleId);){
                Transaction transaction = new Transaction();
                transaction.setContractId(contractId);
                transaction.setCreateDate(new Date());
                transaction.setStatus(TransactionStatus.EXPOSED.getCode());
                transaction.setSum(sum);
                int identifyKeyParameterId = this.moduleSetup.getInt("qiwi.additional.identify.key.pid", 0);
                if (identifyKeyParameterId > 0) {
                    transaction.setAdditionalKey(new ContractParameterManager(this.connection).getStringParam(contractId, identifyKeyParameterId));
                }
                manager.addTransaction(transaction);
                if (logger.isDebugEnabled()) {
                    logger.debug("\t\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + transaction.getTransactionId() + " \u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c " + transaction.getStatus());
                }
                String login = this.moduleSetup.get("qiwi.login");
                String password = this.moduleSetup.get("qiwi.password");
                String shop = this.moduleSetup.get("qiwi.shop.id");
                if (shop == null) {
                    shop = login;
                }
                Contract contract = this.contractManager.getContractById(contractId);
                String comment = this.moduleSetup.get("qiwi.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
                String txId = String.valueOf(transaction.getTransactionId());
                Calendar now = Calendar.getInstance();
                now.add(5, 45);
                String lifeTime = TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy HH:mm:ss");
                if (phone.startsWith("7")) {
                    phone = phone.substring(1);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: login=" + Utils.maskConfidential((String)login) + "; password=" + Utils.maskConfidential((String)password) + "; phone=" + Utils.maskPhoneNumber((String)phone, (int)2, (int)2) + "; sum=" + sum + "; comment=" + comment + "; txId=" + txId + "; lifetime=" + lifeTime + "; alarm=0; create=true");
                }
                IShopServerWS service = new IShopServerWSService().getIShopServerWSPort();
                int statusCode = service.createBill(login, password, phone, sum.toString(), comment, txId, lifeTime, 0, true);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u041a\u043e\u0434 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + statusCode);
                }
                if (statusCode == 0) {
                    redirectUrl = this.moduleSetup.get("qiwi.gate.url", "https://bill.qiwi.com/order/external/main.action") + "?shop=" + shop + "&transaction=" + txId + "&successUrl=" + successUrl + "&failUrl=" + failUrl;
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u0421\u0441\u044b\u043b\u043a\u0430 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0430\u0434\u0440\u0435\u0441\u0430\u0446\u0438\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430: " + redirectUrl);
                    }
                    break block16;
                }
                AbstractQiwiProtocol.QiwiResultCode resultCode = AbstractQiwiProtocol.QiwiResultCode.getResultCodeByCode(statusCode);
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (\u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 " + resultCode.getCode() + " ): " + resultCode.getTitle());
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return redirectUrl;
    }

    @Override
    public void checkTransaction(Transaction transaction) throws BGException {
        boolean isPaided = false;
        String login = this.moduleSetup.get("qiwi.login");
        String password = this.moduleSetup.get("qiwi.password");
        Holder lifeTime = new Holder();
        Holder user = new Holder();
        Holder amount = new Holder();
        Holder date = new Holder();
        Holder status = new Holder();
        if (logger.isDebugEnabled()) {
            logger.debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (id=" + transaction.getTransactionId() + ", cid=" + transaction.getContractId() + ")");
        }
        IShopServerWS service = new IShopServerWSService().getIShopServerWSPort();
        service.checkBill(login, password, transaction.getTransactionId(), (Holder<String>)user, (Holder<String>)amount, (Holder<String>)date, (Holder<String>)lifeTime, (Holder<String>)status);
        try (TransactionManager manager = new TransactionManager(this.connection, this.moduleId);){
            if (logger.isDebugEnabled()) {
                logger.debug("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 - \u0441\u0442\u0430\u0442\u0443\u0441 " + (String)status.value);
            }
            if (((String)status.value).equals(TransactionStatus.PAIDED.getCode())) {
                isPaided = true;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0432 \u0411\u0414");
                }
                transaction.setStatus((String)status.value);
                manager.update(transaction);
            }
            if (isPaided) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u0430, \u0437\u0430\u043d\u043e\u0441\u0438\u043c \u043f\u043b\u0430\u0442\u0435\u0436 \u0432 \u0411\u0414");
                    }
                    this.addPayment(transaction, manager);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
        }
    }

    @Override
    public void cancelTransaction(Transaction transaction) throws BGException {
        throw new UnsupportedOperationException("\u0414\u043b\u044f SOAP-\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u043e\u0442\u043c\u0435\u043d\u0430 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430 \u043d\u0435 \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u0430!");
    }

    @Override
    public void refundTransaction(Transaction transaction) throws BGException {
        throw new UnsupportedOperationException("\u0414\u043b\u044f SOAP-\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043f\u043e \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u043c\u0443 \u0441\u0447\u0435\u0442\u0443 \u043d\u0435 \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d!");
    }

    @Override
    public void checkRefundStatus(Transaction transaction) throws BGException {
        throw new UnsupportedOperationException("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f SOAP-\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u043e\u043c");
    }
}

