/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import bitel.billing.module.tariff.voice.table.CodeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.table.tree.DefaultTreeTableModel;
import ru.bitel.bgbilling.client.common.table.tree.JTreeTable;
import ru.bitel.bgbilling.client.common.table.tree.TreeNode;
import ru.bitel.bgbilling.client.common.table.tree.TreeTableModel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class ServiceConfigNumberPool
extends ServiceConfigTabbedPanel {
    private static final Icon folderIcon = ClientUtils.getIcon((String)"folder2");
    private static final Icon leafIcon = ClientUtils.getIcon((String)"telephone_link");
    private DefaultTreeTableModel<NumberPoolTableNode> model = new DefaultTreeTableModel((TreeNode)new NumberPoolTableNode(), new String[]{"\u041f\u0443\u043b \u043d\u043e\u043c\u0435\u0440\u043e\u0432", "\u0421", "\u041f\u043e"}, new Class[]{TreeTableModel.class, String.class, String.class}, (DefaultTreeTableModel.GetTreeNodeFromElement)new DefaultTreeTableModel.GetTreeNodeFromElement<NumberPoolTableNode>(){

        public NumberPoolTableNode getFromElement(Element el) {
            NumberPoolTableNode result = new NumberPoolTableNode();
            result.id = Utils.parseInt((String)el.getAttribute("id"), (int)-1);
            int n = result.type = "pool".equals(el.getNodeName()) ? 1 : 2;
            if (result.type == 1) {
                result.title = el.getAttribute("title");
                result.range_start = Utils.parseLong((String)el.getAttribute("range_start"));
                result.range_end = Utils.parseLong((String)el.getAttribute("range_end"));
            } else {
                result.title = el.getAttribute("pattern");
            }
            return result;
        }
    });
    private JTreeTable tree = new JTreeTable(this.model);
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private String selected = null;
    private NumberPoolTableNode selectedNode = null;
    private JPanel poolEditorPanel = new JPanel(new GridBagLayout());
    private JPanel poolEntryEditorPanel = new JPanel(new GridBagLayout());
    private BGTextField poolEntryPattern = new BGTextField();
    private BGTextField title = new BGTextField();
    private BGTextField rangeStart = new BGTextField(10);
    private BGTextField rangeEnd = new BGTextField(10);
    private BGComboBox<ComboBoxItem> chargeType = new BGComboBox();
    private BGTextField charge = new BGTextField();

    public ServiceConfigNumberPool() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((NumberPoolTableNode)this.model.getRoot()).title = "\u041f\u0443\u043b\u044b \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u044b\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432";
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.tree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.poolEditorPanel.setVisible(false);
        this.poolEntryEditorPanel.setVisible(false);
        this.poolEntryEditorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 "));
        this.poolEditorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0443\u043b\u0430 "));
        JPanel panel = new JPanel();
        panel.setBorder((Border)new BGTitleBorder(" \u0428\u0430\u0431\u043b\u043e\u043d "));
        panel.add((Component)this.poolEntryPattern);
        BGButtonPanelRestoreOkCancelHelp okCancel = new BGButtonPanelRestoreOkCancelHelp();
        this.poolEntryEditorPanel.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.poolEntryEditorPanel.add((Component)okCancel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGButtonPanelRestoreOkCancelHelp okCancelEntry = new BGButtonPanelRestoreOkCancelHelp();
        this.poolEditorPanel.add((Component)this.wrap((Component)this.title, " \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 "), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.poolEditorPanel.add((Component)this.wrap((Component)this.rangeStart, " \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.poolEditorPanel.add((Component)this.wrap((Component)this.rangeEnd, " \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.poolEditorPanel.add((Component)okCancel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if ("reset".equals(actionCommand)) {
                    ServiceConfigNumberPool.this.editNode(ServiceConfigNumberPool.this.selectedNode);
                } else if ("ok".equals(actionCommand)) {
                    ComboBoxItem type = (ComboBoxItem)ServiceConfigNumberPool.this.chargeType.getSelectedItem();
                    if (type == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430!");
                        return;
                    }
                    Request request = new Request();
                    request.setModule(ServiceConfigNumberPool.this.module);
                    request.setModuleId(ServiceConfigNumberPool.this.getModuleId());
                    request.setAction("NumberPoolUpdate");
                    request.setAttribute("mode", "update");
                    request.setAttribute("id", String.valueOf(ServiceConfigNumberPool.this.selectedNode.id));
                    request.setAttribute("title", ServiceConfigNumberPool.this.title.getText());
                    request.setAttribute("ct_id", type.getObject());
                    request.setAttribute("charge", ServiceConfigNumberPool.this.charge.getText());
                    request.setAttribute("range_start", ServiceConfigNumberPool.this.rangeStart.getText());
                    request.setAttribute("range_end", ServiceConfigNumberPool.this.rangeEnd.getText());
                    if (ClientUtils.checkStatus((Document)ServiceConfigNumberPool.this.getDocument(request))) {
                        ServiceConfigNumberPool.this.poolEditorPanel.setVisible(false);
                    }
                } else if ("cancel".equals(actionCommand)) {
                    ServiceConfigNumberPool.this.poolEditorPanel.setVisible(false);
                } else if ("help".equals(actionCommand)) {
                    ServiceConfigNumberPool.this.openHelp(ServiceConfigNumberPool.class.getName());
                }
            }
        });
        okCancelEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if ("reset".equals(actionCommand)) {
                    ServiceConfigNumberPool.this.editNode(ServiceConfigNumberPool.this.selectedNode);
                } else if ("ok".equals(actionCommand)) {
                    ComboBoxItem type = (ComboBoxItem)ServiceConfigNumberPool.this.chargeType.getSelectedItem();
                    if (type == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                        return;
                    }
                    Request request = new Request();
                    request.setModule(ServiceConfigNumberPool.this.module);
                    request.setModuleId(ServiceConfigNumberPool.this.getModuleId());
                    request.setAction("NumberPoolUpdate");
                    request.setAttribute("mode", "updateEntry");
                    request.setAttribute("id", String.valueOf(ServiceConfigNumberPool.this.selectedNode.id));
                    request.setAttribute("np_id", ServiceConfigNumberPool.this.selected);
                    request.setAttribute("pattern", ServiceConfigNumberPool.this.poolEntryPattern.getText());
                    if (ClientUtils.checkStatus((Document)ServiceConfigNumberPool.this.getDocument(request))) {
                        ServiceConfigNumberPool.this.poolEntryEditorPanel.setVisible(false);
                    }
                } else if ("cancel".equals(actionCommand)) {
                    ServiceConfigNumberPool.this.poolEntryEditorPanel.setVisible(false);
                } else if ("help".equals(actionCommand)) {
                    ServiceConfigNumberPool.this.openHelp(ServiceConfigNumberPool.class.getName());
                }
            }
        });
        this.add(this.poolEditorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.poolEntryEditorPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.toolBar.setDefaultButtons(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigNumberPool.this.toolBarAction(e);
            }
        });
        this.toolBar.setFloatable(false);
        Vector<String> buttons = new Vector<String>();
        buttons.add("newItem");
        buttons.add("editItem");
        buttons.add("deleteItem");
        buttons.add("upItem");
        buttons.add("downItem");
        this.toolBar.setToolBar(buttons);
        this.tree.setRowHeight(20);
        this.tree.setSelectionMode(0);
        this.tree.getColumnModel().getColumn(0).setPreferredWidth(500);
        this.tree.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.tree.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.tree.getColumnModel().getColumn(1).setMinWidth(80);
        this.tree.getColumnModel().getColumn(2).setMinWidth(80);
        final JPopupMenu menu = new JPopupMenu();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceConfigNumberPool.this.toolBarAction(e);
            }
        };
        JMenuItem editItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        editItem.setActionCommand("editItem");
        editItem.addActionListener(al);
        JMenuItem deleteItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        deleteItem.setActionCommand("deleteItem");
        deleteItem.addActionListener(al);
        menu.add(editItem);
        menu.add(deleteItem);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = ServiceConfigNumberPool.this.tree.rowAtPoint(e.getPoint());
                    if (row > 0) {
                        ServiceConfigNumberPool.this.tree.getSelectionModel().setSelectionInterval(row, row);
                    }
                    menu.show((Component)ServiceConfigNumberPool.this.tree, e.getX(), e.getY());
                }
            }
        });
    }

    private JPanel wrap(Component comp, String title) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(title));
        panel.add(comp, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setData() {
        this.setData(true);
    }

    public void setData(boolean init) {
        Request req;
        if (init) {
            req = new Request();
            req.setModule("phone");
            req.setModuleId(this.getModuleId());
            req.setAction("NumberPool");
            this.setDocument(this.getDocument(req));
        }
        req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("NumberPool");
        this.setDocument(this.getDocument(req));
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            this.model.load((Object)XMLUtils.selectElement((Node)doc, (String)"//pools"), this.selected, true);
        }
    }

    public void toolBarAction(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            NumberPoolTableNode node;
            TreePath path = this.tree.getTree().getSelectionPath();
            NumberPoolTableNode numberPoolTableNode = node = path != null ? (NumberPoolTableNode)((Object)path.getLastPathComponent()) : null;
            if (command.equals("deleteItem") || command.equals("editItem")) {
                if (node == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0443\u0437\u0435\u043b!");
                    return;
                }
                if (node == this.model.getRoot()) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b!");
                    return;
                }
            }
            if (command.equals("deleteItem")) {
                this.deleteNode(node);
            } else if (command.equals("editItem")) {
                this.editNode(node);
            } else if (command.equals("newItem")) {
                this.newNode(node);
            } else if (command.equals("upItem") || command.equals("downItem")) {
                // empty if block
            }
        }
    }

    public boolean updateCode(CodeNode node) {
        Request req = new Request();
        req.setModule("tariff.voice");
        req.setModuleId(this.getModuleId());
        req.setAction("GeographicCodeUpdate");
        req.setAttribute("code", node.prefix);
        req.setAttribute("start_level", node.levelStart);
        req.setAttribute("end_level", node.levelEnd);
        req.setAttribute("destId", node.destId);
        Document doc = this.getDocument(req);
        boolean status = ClientUtils.checkStatus((Document)doc);
        return status;
    }

    private void deleteNode(NumberPoolTableNode node) {
        if (node.type == 1) {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0443\u043b?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                Request request = new Request();
                request.setModule("phone");
                request.setModuleId(this.getModuleId());
                request.setAction("NumberPoolUpdate");
                request.setAttribute("mode", "delete");
                request.setAttribute("id", String.valueOf(node.id));
                ClientUtils.checkStatus((Document)this.getDocument(request));
                this.setData(false);
            }
        } else if (JOptionPane.showConfirmDialog((Component)((Object)this), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d \u043d\u043e\u043c\u0435\u0440\u0430?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request req = new Request();
            req.setModule("phone");
            req.setModuleId(this.getModuleId());
            req.setAction("NumberPoolUpdate");
            req.setAttribute("mode", "deleteEntry");
            req.setAttribute("id", String.valueOf(node.id));
            ClientUtils.checkStatus((Document)this.getDocument(req));
            this.setData(false);
        }
    }

    private void editNode(NumberPoolTableNode node) {
        if (node.type == 1) {
            Request req = new Request();
            req.setModule("phone");
            req.setModuleId(this.getModuleId());
            req.setAction("NumberPoolGet");
            req.setAttribute("id", String.valueOf(node.id));
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.selectedNode = node;
                Element pool = XMLUtils.selectElement((Node)doc, (String)"//pool");
                if (pool != null) {
                    this.title.setText(pool.getAttribute("title"));
                    this.charge.setText(pool.getAttribute("charge"));
                    this.rangeStart.setText(pool.getAttribute("range_start"));
                    this.rangeEnd.setText(pool.getAttribute("range_end"));
                    ClientUtils.setComboBoxSelection(this.chargeType, (Object)pool.getAttribute("ct_id"));
                }
                this.poolEditorPanel.setVisible(true);
            }
        } else {
            this.selectedNode = node;
            this.selected = String.valueOf(((NumberPoolTableNode)node.getParent()).id);
            this.poolEntryPattern.setText(node.title);
            this.poolEntryEditorPanel.setVisible(true);
        }
    }

    private void newNode(NumberPoolTableNode node) {
        if (node.type == 1) {
            this.selected = String.valueOf(node.id);
            this.selectedNode = new NumberPoolTableNode();
            this.poolEntryPattern.setText("");
            this.poolEntryEditorPanel.setVisible(true);
        } else if (node == this.model.getRoot()) {
            this.selectedNode = new NumberPoolTableNode();
            this.title.setText("");
            this.charge.setText("");
            this.rangeStart.setText("");
            this.rangeEnd.setText("");
            this.poolEditorPanel.setVisible(true);
        }
    }

    private class NumberPoolTableNode
    extends TreeNode<NumberPoolTableNode> {
        private static final int POOL = 1;
        private static final int POOL_ITEM = 2;
        private int type;
        private String title;
        private long range_start;
        private long range_end;

        private NumberPoolTableNode() {
        }

        public int hashCode() {
            return (31 + this.type) * 31 + this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NumberPoolTableNode) {
                NumberPoolTableNode other = (NumberPoolTableNode)((Object)obj);
                return this.id == other.id && this.type == other.type;
            }
            return false;
        }

        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.title;
                }
                case 1: {
                    return String.valueOf(this.range_start);
                }
                case 2: {
                    return String.valueOf(this.range_end);
                }
            }
            return null;
        }

        public String toString() {
            return this.title;
        }

        public Icon getIcon() {
            if (this.type == 1) {
                return folderIcon;
            }
            return leafIcon;
        }
    }
}

