/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.payonline.common.bean.Transaction;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private String USER_DATA_TABLE = null;
    private String TRANSACTION_PAYMENT_MAP = null;
    public static final int PAYMENT_TYPE_PAYMENT = 0;
    public static final int PAYMENT_TYPE_CHARGE = 1;

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "payonline_transaction");
        this.USER_DATA_TABLE = this.getTableName("payonline_user_data", moduleId, null);
        this.TRANSACTION_PAYMENT_MAP = this.getTableName("payonline_transaction_payment_map", moduleId, null);
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("sum", "summa");
    }

    protected void updateImpl(Transaction b) throws BGException, SQLException {
        if (b.getId() > 0) {
            return;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE trans_id =? AND contract_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, b.getTransactionId());
        ps.setInt(2, b.getContractId());
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            query = "INSERT INTO " + this.tableName + " SET trans_id=?, summa=?, contract_id=?, pay_date=?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, b.getTransactionId());
            ps.setBigDecimal(2, b.getSum());
            ps.setInt(3, b.getContractId());
            ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)b.getTransactionDate()));
            if (ps.executeUpdate() > 0) {
                b.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        } else {
            rs.close();
            ps.close();
            throw new BGException("\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u043a\u043e\u0434\u043e\u043c payonline " + b.getTransactionId() + " \u0443\u0436\u0435 \u0431\u044b\u043b \u0440\u0430\u043d\u0435\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
        }
        rs.close();
        ps.close();
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, false);
    }

    protected Transaction getFromRS(ResultSet rs, boolean setContractTitle) throws SQLException, BGException {
        Transaction pot = new Transaction();
        pot.setContractId(rs.getInt("contract_id"));
        pot.setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("pay_date")));
        pot.setSum(rs.getBigDecimal("summa"));
        pot.setId(rs.getInt("id"));
        pot.setTransactionId(rs.getString("trans_id"));
        if (setContractTitle) {
            pot.setContractTitle(rs.getString("c.title"));
        }
        return pot;
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String transactionStatus) throws BGException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        try {
            StringBuilder sql = new StringBuilder("SELECT pt.*, c.title FROM ").append(this.tableName).append(" AS pt");
            if ("rebill".equals(transactionStatus)) {
                sql.append(" INNER JOIN payonline_rebill_transaction_").append(this.moduleId).append(" AS prt ON pt.trans_id=prt.transaction_id");
            } else if ("usual".equals(transactionStatus)) {
                sql.append(" LEFT JOIN payonline_rebill_transaction_").append(this.moduleId).append(" AS prt ON pt.trans_id=prt.transaction_id");
            }
            sql.append(" LEFT JOIN contract c ON c.id=pt.contract_id");
            sql.append(" WHERE true ");
            if (contractId > 0) {
                sql.append(" AND pt.contract_id=").append(contractId);
            }
            if (Utils.notBlankString((String)contractTitle)) {
                sql.append(" AND c.title LIKE ?");
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    sql.append(" AND pt.pay_date>=?");
                }
                if (period.getDateTo() != null) {
                    sql.append(" AND pt.pay_date<?");
                }
            }
            if ("usual".equals(transactionStatus)) {
                sql.append(" AND prt.id IS NULL ");
            }
            sql.append(this.getSQLOrder(sort, this.fields));
            if (page != null) {
                sql.append(page.sqlLimit());
            }
            PreparedStatement ps = this.con.prepareStatement(sql.toString());
            int index = 1;
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs, true));
            }
            rs.close();
            ps.close();
            sql = new StringBuilder("SELECT SUM(summa), COUNT(summa) FROM ").append(this.tableName).append(" AS pt ");
            if ("usual".equals(transactionStatus)) {
                sql.append("LEFT JOIN payonline_rebill_transaction_").append(this.moduleId).append(" AS prt ON pt.trans_id=prt.transaction_id");
            }
            sql.append(" LEFT JOIN contract c ON c.id=pt.contract_id");
            sql.append(" WHERE true");
            if (contractId > 0) {
                sql.append(" AND pt.contract_id=" + contractId);
            }
            if (Utils.notBlankString((String)contractTitle)) {
                sql.append(" AND c.title LIKE ?");
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    sql.append(" AND pt.pay_date>=?");
                }
                if (period.getDateTo() != null) {
                    sql.append(" AND pt.pay_date<?");
                }
            }
            if ("usual".equals(transactionStatus)) {
                sql.append(" AND prt.id IS NULL ");
            }
            ps = this.con.prepareStatement(sql.toString());
            index = 1;
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                BigDecimal summa = rs.getBigDecimal(1);
                if (summa != null) {
                    searchResult.setSum(summa);
                }
                page.setRecordCount(rs.getInt(2));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Transaction> getList() throws BGException {
        return this.list("", "pay_date", new Object[0]);
    }

    public List<Transaction> getList(int contractId) throws BGException {
        return this.list("contract_id=?", "pay_date", new Object[]{contractId});
    }

    public List<Transaction> getList(int contractId, Period period) throws BGException {
        if (period == null) {
            try {
                return this.listImpl(new Page(1, 3), "contract_id=?", "pay_date DESC", new Object[]{contractId});
            }
            catch (SQLException ex) {
                this.processException(ex);
            }
        }
        return this.list("contract_id=? AND (? IS NULL OR pay_date>=?) AND (? IS NULL OR pay_date<=?)", "pay_date DESC", new Object[]{contractId, period.getDateFrom(), period.getDateFrom(), period.getDateTo(), period.getDateTo()});
    }

    public Transaction getByTransId(long transId) throws BGException {
        return (Transaction)this.get("trans_id=?", new Object[]{transId});
    }

    public void addUserData(int contactId, String cardNumber, String rebillAnchor) throws BGException {
        block18: {
            String userDataTableCreateQuery = "CREATE TABLE " + this.USER_DATA_TABLE + " ( `contractId` INT NOT NULL, `cardNumber` VARCHAR(4) NOT NULL, `rebillAnchor` VARCHAR(64) NULL, PRIMARY KEY (`contractId`, `cardNumber`, `rebillAnchor`))";
            try {
                int index;
                ServerUtils.checkTable((Connection)this.con, (String)this.USER_DATA_TABLE, (String)userDataTableCreateQuery);
                String query = "SELECT COUNT(*) FROM " + this.USER_DATA_TABLE + " WHERE contractId=? AND cardNumber=? AND rebillAnchor=?";
                int recordCount = -1;
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    index = 1;
                    ps.setInt(index++, contactId);
                    ps.setString(index++, cardNumber);
                    ps.setString(index++, rebillAnchor);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        recordCount = rs.getInt(1);
                    }
                }
                if (recordCount > 0) break block18;
                query = "INSERT INTO " + this.USER_DATA_TABLE + " (contractId, cardNumber, rebillAnchor) VALUES (?,?,?)";
                try {
                    ps = this.con.prepareStatement(query);
                    try {
                        index = 1;
                        ps.setInt(index++, contactId);
                        ps.setString(index++, cardNumber);
                        ps.setString(index++, rebillAnchor);
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void addPaymentToTransaction(long transactionId, int paymentId, int paymentType) throws BGException {
        String query = "INSERT INTO " + this.TRANSACTION_PAYMENT_MAP + "(transaction_id, payment_id, type) VALUES(?,?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, transactionId);
            ps.setInt(2, paymentId);
            ps.setInt(3, paymentType);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deletePaymentToTransaction(long transactionId) throws BGException {
        String query = "DELETE FROM " + this.TRANSACTION_PAYMENT_MAP + " WHERE transaction_id= ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, transactionId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public int getPaymentIdToTransaction(long transactionId, int paymentType) throws BGException {
        int n;
        block9: {
            int result = -1;
            String query = "SELECT payment_id FROM " + this.TRANSACTION_PAYMENT_MAP + " WHERE transaction_id=? AND type=? ";
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                ps.setLong(1, transactionId);
                ps.setInt(2, paymentType);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result = rs.getInt(1);
                }
                n = result;
                if (ps == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            ps.close();
        }
        return n;
    }
}

