/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paykeeper.server.servlet;

import bitel.billing.server.ActionResultContentType;
import java.io.IOException;
import java.sql.Connection;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paykeeper.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="PaykeeperExecutor", urlPatterns={"/paykeeper/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String PARAM_ID = "id";
    private static final String PARAM_SUM = "sum";
    private static final String PARAM_CLIENT_ID = "clientid";
    private static final String PARAM_ORDER_ID = "orderid";
    private static final String PARAM_KEY = "key";
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con = null;
        TransactionManager transactionManager = null;
        try {
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            con = Setup.getSetup().getDBConnectionFromPool();
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            String transactionId = request.getParameter(PARAM_ID);
            String sum = request.getParameter(PARAM_SUM);
            String clientId = request.getParameter(PARAM_CLIENT_ID);
            String orderId = request.getParameter(PARAM_ORDER_ID);
            String key = request.getParameter(PARAM_KEY);
            String secret = moduleSetup.get("paykeeper.secret");
            StringBuilder dataString = new StringBuilder().append(transactionId).append(sum).append(clientId).append(orderId).append(secret);
            String hash = Utils.getDigest((String)dataString.toString(), (String)"UTF-8");
            if (key == null || !key.toUpperCase().equals(hash)) {
                this.doResponse(request, response, true, "Key is NULL or not valid [" + key + " != " + hash + "]");
                return;
            }
            transactionManager = new TransactionManager(con, moduleId);
            Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderId));
            if (transaction == null) {
                this.doResponse(request, response, true, "Not found transaction for ID = " + orderId);
                return;
            }
            if (transaction.getContractId() != Utils.parseInt((String)clientId, (int)0)) {
                this.doResponse(request, response, true, "Not valid 'clientid' for transaction with ID = " + orderId);
                return;
            }
            transaction.setTransactionId(transactionId);
            transaction.setTransactionDate(new Date());
            transactionManager.addTransactionPayment(transaction, transaction.getParameters());
            this.doResponse(request, response, false, Utils.getDigest((String)(transactionId + secret), (String)"UTF-8"));
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.recycle();
                }
                catch (BGException e) {
                    e.printStackTrace();
                }
            }
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void doResponse(HttpServletRequest request, HttpServletResponse response, boolean error, String message) {
        if (error) {
            logger.error(message);
        }
        request.setAttribute("contentType", (Object)ActionResultContentType.binary);
        response.setContentType("text/plain");
        try {
            ServletOutputStream responseStream = response.getOutputStream();
            responseStream.write(((error ? "ERROR" : "OK") + " " + message).getBytes());
            responseStream.flush();
            responseStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

