/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ServiceService;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class NPayServiceConfigStatusMatrix
extends ServiceConfigTabbedPanel {
    private JPopupMenu popupMenu = null;
    private List<Status> statusList = null;
    private BGUTable matrixTable = null;
    private NPayService npayService = null;
    private ServiceService serviceService = null;
    private MatrixTableModel matrixTableModel = null;
    private ContractStatusService contractStatusService = null;

    public NPayServiceConfigStatusMatrix() {
        this.setLayout(new GridBagLayout());
        this.add(this.getMatrixPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getMatrixPanel() {
        this.matrixTableModel = new MatrixTableModel(MatrixTableModel.class.getName());
        this.matrixTable = new BGUTable(null);
        this.matrixTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !NPayServiceConfigStatusMatrix.this.matrixTableModel.getSelectedRows().isEmpty()) {
                    NPayServiceConfigStatusMatrix.this.openMatrixEditor();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    NPayServiceConfigStatusMatrix.this.getPopupMenu().show((Component)NPayServiceConfigStatusMatrix.this.matrixTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.matrixTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
            menuItem.addActionListener(e -> this.openMatrixEditor());
            this.popupMenu.add(menuItem);
        }
        return this.popupMenu;
    }

    private void openMatrixEditor() {
        List selectedRows = this.matrixTableModel.getSelectedRows();
        if (selectedRows.isEmpty()) {
            ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0438");
        } else {
            new MatrixEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u0430\u0442\u0440\u0438\u0446\u044b", selectedRows).getDialog().setVisible(true);
            this.matrixTableModel.fireTableDataChanged();
        }
    }

    private ServiceService getServiceService() {
        if (this.serviceService == null) {
            this.serviceService = (ServiceService)this.getContext().getPort(ServiceService.class);
        }
        return this.serviceService;
    }

    private NPayService getNPayService() {
        if (this.npayService == null) {
            this.npayService = (NPayService)this.getContext().getPort(NPayService.class);
        }
        return this.npayService;
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = (ContractStatusService)this.getContext().getPort(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    public void setData() {
        try {
            this.statusList = this.getContractStatusService().getStatusList(false);
            this.matrixTableModel = new MatrixTableModel(MatrixTableModel.class.getName());
            this.matrixTable.setModel((TableModel)((Object)this.matrixTableModel));
            List services = this.getServiceService().serviceList(this.getContext().getModuleId());
            Boolean[][] values = this.getNPayService().serviceStatusMatrixGet(services.stream().map(a -> a.getId()).collect(Collectors.toList()), this.statusList.stream().map(a -> a.getId()).collect(Collectors.toList()));
            int r = 0;
            ArrayList<RowData> rows = new ArrayList<RowData>();
            for (Service service : services) {
                JSONObject rowJsonObject = new JSONObject();
                rowJsonObject.put("serviceId", service.getId());
                rowJsonObject.put("serviceTitle", (Object)service.getTitle());
                if (this.statusList != null) {
                    int c = 0;
                    for (Status status : this.statusList) {
                        rowJsonObject.put(String.valueOf(status.getId()), (Object)values[r][c++]);
                    }
                }
                rows.add(new RowData(rowJsonObject));
                ++r;
            }
            this.matrixTableModel.setData(rows);
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void editItem() {
        this.openMatrixEditor();
    }

    class MatrixTableModel
    extends BGTableModel<RowData> {
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SERVIC_TITLE = "serviceTitle";
        public static final String VALUE_ON = "\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c";
        public static final String VALUE_OFF = "\u043d\u0435 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c";

        public MatrixTableModel(String name) {
            super(name);
            if (NPayServiceConfigStatusMatrix.this.statusList != null) {
                for (Status status : NPayServiceConfigStatusMatrix.this.statusList) {
                    this.addColumn(status.getTitle(), 100, 200, -1, String.valueOf(status.getId()), true, (TableCellRenderer)((Object)new MyRenderer()));
                }
            }
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 200, 400, -1, COLUMN_SERVIC_TITLE, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject rowJsonObject = rowData.getJson();
            switch (identifier) {
                case "id": {
                    return rowJsonObject.optInt("serviceId");
                }
                case "serviceTitle": {
                    return rowJsonObject.optString(identifier);
                }
            }
            return rowJsonObject.optBoolean(identifier) ? VALUE_ON : VALUE_OFF;
        }
    }

    class MatrixEditor
    extends BGEditorDialog<List<RowData>> {
        private Map<String, ButtonGroup> buttonGroups;

        public MatrixEditor(String title, List<RowData> data) {
            super(title, data);
            this.buttonGroups = new HashMap<String, ButtonGroup>();
        }

        public void doDialogPanel() {
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433"), new GridBagConstraints(0, gridy++, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 15, 0), 0, 0));
            this.panel.add((Component)new TitleLabel("\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.panel.add((Component)new TitleLabel("  \u041d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c  "), new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.panel.add((Component)new TitleLabel("  \u041d\u0435 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c  "), new GridBagConstraints(2, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.panel.add((Component)new TitleLabel("  \u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435  "), new GridBagConstraints(3, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            for (Status status : NPayServiceConfigStatusMatrix.this.statusList) {
                JRadioButton onButton = new JRadioButton();
                onButton.setActionCommand("true");
                JRadioButton offButton = new JRadioButton();
                offButton.setActionCommand("false");
                JRadioButton currentButton = new JRadioButton();
                currentButton.setActionCommand("current");
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(onButton);
                buttonGroup.add(offButton);
                buttonGroup.add(currentButton);
                String statusId = String.valueOf(status.getId());
                this.buttonGroups.put(statusId, buttonGroup);
                this.panel.add((Component)new TitleLabel("  " + status.getTitle() + "  "), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
                this.panel.add((Component)onButton, new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 5, 0, 0), 0, 0));
                this.panel.add((Component)offButton, new GridBagConstraints(2, gridy, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 5, 0, 0), 0, 0));
                this.panel.add((Component)currentButton, new GridBagConstraints(3, gridy++, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 5, 0, 0), 0, 0));
            }
            block1: for (Status status : NPayServiceConfigStatusMatrix.this.statusList) {
                String statusId = String.valueOf(status.getId());
                String value = null;
                for (RowData rowData : (List)this.data) {
                    boolean statusValue = rowData.getJson().optBoolean(statusId, true);
                    if (value == null) {
                        value = String.valueOf(statusValue);
                        continue;
                    }
                    if (value.equals(String.valueOf(statusValue))) continue;
                    value = "current";
                    break;
                }
                if (value == null) continue;
                Enumeration<AbstractButton> enumeration = this.buttonGroups.get(statusId).getElements();
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (!abstractButton.getActionCommand().equals(value)) continue;
                    abstractButton.setSelected(true);
                    continue block1;
                }
            }
            this.panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 3, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            if (this.data != null) {
                Boolean[][] values = new Boolean[((List)this.data).size()][NPayServiceConfigStatusMatrix.this.statusList.size()];
                int r = 0;
                for (RowData rowData : (List)this.data) {
                    int s = 0;
                    JSONObject rowJsonObject = rowData.getJson();
                    for (Status status : NPayServiceConfigStatusMatrix.this.statusList) {
                        String statusId = String.valueOf(status.getId());
                        String statusValue = this.buttonGroups.get(statusId).getSelection().getActionCommand();
                        if (!"current".equals(statusValue)) {
                            rowJsonObject.put(statusId, (Object)Boolean.valueOf(statusValue));
                        }
                        values[r][s++] = rowJsonObject.optBoolean(statusId);
                    }
                    ++r;
                }
                NPayServiceConfigStatusMatrix.this.getNPayService().serviceStatusMatrixUpdate(((List)this.data).stream().map(a -> a.getJson().optInt("serviceId")).collect(Collectors.toList()), NPayServiceConfigStatusMatrix.this.statusList.stream().map(a -> a.getId()).collect(Collectors.toList()), values);
            }
            return true;
        }
    }

    class MyRenderer
    extends HorizontalAlignmentTableCellRenderer {
        public MyRenderer() {
            super(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                component.setBackground("\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0442\u044c".equals(value) ? Color.GREEN : Color.LIGHT_GRAY);
            }
            return component;
        }
    }

    class TitleLabel
    extends JLabel {
        public TitleLabel(String text) {
            super(text);
            this.setHorizontalAlignment(0);
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
        }
    }
}

