/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.news.client;

import bitel.billing.module.common.BGControlPanelDate;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.plugins.news.common.bean.News;
import ru.bitel.bgbilling.plugins.news.common.service.NewsService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;

public class NewsEditor
extends BGTabPanel {
    public static final String TAB_ID = "newsEditor";
    private News current = null;
    private BGButtonPanelRestoreOkCancelHelp restoreOkCancelHelpPanel = new BGButtonPanelRestoreOkCancelHelp();
    private ContractLabelTree contractLabelTree = new ContractLabelTree();
    private BGControlPanelDate datePanel = new BGControlPanelDate();
    private BGTextField newsTitle = new BGTextField();
    private CardLayout cardLayout = new CardLayout();
    private JTextArea source = new JTextArea();
    private JPanel cardPanel = new JPanel();
    private JCheckBox checkBox = new JCheckBox();
    private NewsService newsService = null;
    private NewsListTableModel newsListTableModel = null;

    public NewsEditor() {
        super(TAB_ID, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043d\u043e\u0432\u043e\u0441\u0442\u0435\u0439");
        this.module = "admin.news";
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.restoreOkCancelHelpPanel.addActionListener(e -> this.bGControlPanel_02_actionPerformed(e));
        this.checkBox.addActionListener(e -> this.source.setLineWrap(this.checkBox.isSelected()));
        this.source.setWrapStyleWord(true);
        this.source.setMargin(new Insets(3, 3, 3, 3));
    }

    private void jbInit() throws Exception {
        this.newsListTableModel = new NewsListTableModel(NewsListTableModel.class.getName());
        this.cardPanel.setLayout(this.cardLayout);
        this.restoreOkCancelHelpPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        BGUTable table = new BGUTable((TableModel)((Object)this.newsListTableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NewsEditor.this.current = (News)NewsEditor.this.newsListTableModel.getSelectedRow();
                    NewsEditor.this.setNewsData();
                }
            }
        });
        JPanel newsListPanel = new JPanel(new GridBagLayout());
        newsListPanel.setBorder((Border)new BGTitleBorder(" \u0421\u043f\u0438\u0441\u043e\u043a \u043d\u043e\u0432\u043e\u0441\u0442\u0435\u0439 "));
        newsListPanel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel newsEditorPanel = new JPanel(new GridBagLayout());
        newsEditorPanel.add((Component)this.getMiddlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        newsEditorPanel.add((Component)this.restoreOkCancelHelpPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cardPanel.add((Component)newsEditorPanel, "editor");
        JLabel infoLabel = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        infoLabel.setHorizontalAlignment(0);
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)infoLabel, "Center");
        this.cardPanel.add((Component)infoPanel, "info");
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, (Component)newsListPanel, (Component)this.cardPanel, 200L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getMiddlePanel() {
        this.checkBox.setText(" \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0442\u0440\u043e\u043a");
        JPanel newsTextPanel = new JPanel(new GridBagLayout());
        newsTextPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        newsTextPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        newsTextPanel.add((Component)new JScrollPane(this.source), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        newsTextPanel.add((Component)this.checkBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane((Component)this.contractLabelTree);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)scrollPane, (Component)newsTextPanel, 400L);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTopPanel() {
        JPanel newsTitlePanel = new JPanel(new GridBagLayout());
        newsTitlePanel.setBorder((Border)new BGTitleBorder(" \u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a "));
        newsTitlePanel.add((Component)this.newsTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.datePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)newsTitlePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        return panel;
    }

    public void setData() {
        try {
            this.contractLabelTree.setData(((ContractLabelService)this.getContext().getPort(ContractLabelService.class)).getContractLabelTreeItemList(-1, false));
            this.newsListTableModel.setData(this.getNewsService().newsList(new Page(1, 30)));
            this.cardLayout.show(this.cardPanel, "info");
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void onOpening() {
        this.setData();
    }

    public void setNewsData() {
        this.newsTitle.setText(Utils.maskBlank((String)this.current.getTitle(), (String)"\u0411\u0435\u0437 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430"));
        this.setLabelSelected(this.current.getContractLabelIds());
        this.datePanel.setDate(this.current.getDate() == null ? new Date() : this.current.getDate());
        this.source.setText(this.current.getBody());
        this.cardLayout.show(this.cardPanel, "editor");
    }

    public void newItem() {
        this.current = new News();
        this.setNewsData();
    }

    public void editItem() {
        News news = (News)this.newsListTableModel.getSelectedRow();
        if (news == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
            return;
        }
        this.current = news;
        this.setNewsData();
    }

    public void deleteItem() {
        News news = (News)this.newsListTableModel.getSelectedRow();
        if (news == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
            return;
        }
        if (!ClientUtils.confirmDelete((Object)news)) {
            return;
        }
        try {
            this.getNewsService().newsDelete(news.getId());
            this.setData();
        }
        catch (BGException e) {
            this.getContext().processException((Throwable)e);
        }
    }

    void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.setNewsData();
        } else if ("ok".equals(actionCommand)) {
            this.current.setDate(this.datePanel.getDate());
            this.current.setTitle(this.newsTitle.getText().trim());
            this.current.setBody(this.source.getText().trim());
            this.current.setContractLabelIds(this.getLabelSelected());
            try {
                this.getNewsService().newsUpdate(this.current);
                this.setData();
            }
            catch (BGException e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
            }
        } else if ("cancel".equals(actionCommand)) {
            this.cardLayout.show(this.cardPanel, "info");
        }
    }

    private NewsService getNewsService() {
        if (this.newsService == null) {
            this.newsService = (NewsService)this.getContext().getPort(NewsService.class);
        }
        return this.newsService;
    }

    private List<Integer> getLabelSelected() {
        return this.contractLabelTree.getSelectedIds();
    }

    private void setLabelSelected(List<Integer> ids) {
        this.contractLabelTree.setSelectedIds(ids);
        this.contractLabelTree.revalidate();
        this.contractLabelTree.repaint();
    }

    class NewsListTableModel
    extends BGTableModel<News> {
        public NewsListTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", 150, 150, 150, "date", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

