/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.netpay.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.netpay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.netpay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.netpay.server.bean.Constants;
import ru.bitel.bgbilling.modules.netpay.server.bean.NetpayUtils;
import ru.bitel.bgbilling.modules.netpay.server.bean.TransactionManager;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Netpay")
public class ActionDoTransaction
extends AbstractAction {
    private static final Logger logger = LogManager.getLogger();
    private final String moduleName = "netpay";

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        this.setResultParam("gateUrl", this.moduleSetup.get("netpay.gate.url", "https://my.net2pay.ru/billingService/paypage/"));
        this.paymentForm("netpay", Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus(TransactionStatus.ALL.getStatusByCode(this.moduleSetup.get("netpay.status.default", TransactionStatus.ALL.getCode()))));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws BGException {
        this.execute();
    }

    public void fail() throws BGException {
        this.execute();
    }

    public void cancel() throws BGException {
        this.execute();
    }

    @WebOperation(title="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void getOrderId() throws BGException {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("netpay.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("netpay.sum.max", new BigDecimal(5000));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        Transaction transaction = new Transaction();
        transaction.setSum(sum);
        transaction.setContractId(this.contractId);
        transaction.setCreateDate(new Date());
        transaction.setTransactionId("");
        transaction.setParameters("");
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        transactionManager.update(transaction);
        transactionManager.close();
        GregorianCalendar date = new GregorianCalendar();
        ((Calendar)date).add(5, this.moduleSetup.getInt("netpay.expired.day", 30));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'V'HH:mm:ss");
        dateFormat.getCalendar().setTimeZone(TimeZone.getTimeZone("Europe/Moscow"));
        String orderDate = dateFormat.format(date.getTime());
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        String description = this.moduleSetup.get("netpay.order.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
        ArrayList<String> params = new ArrayList<String>();
        params.add("description=" + description);
        params.add("amount=" + sum.toPlainString().replace(',', '.'));
        params.add("currency=" + this.moduleSetup.get("netpay.order.currency.code", "RUB"));
        params.add("orderID=" + transaction.getId());
        params.add("successUrl=" + this.moduleSetup.get("netpay.order.success.url", ""));
        params.add("failUrl=" + this.moduleSetup.get("netpay.order.fail.url", ""));
        String apiKey = this.moduleSetup.get("netpay.api.key", "js4cucpn4kkc6jl1p95np054g2");
        String auth = this.moduleSetup.get("netpay.auth.signature", "1");
        String cryptoKey = NetpayUtils.getCryptoKey(apiKey, orderDate);
        if (logger.isDebugEnabled()) {
            logger.debug("apiKey: " + apiKey);
            logger.debug("auth: " + auth);
            logger.debug("orderDate: " + orderDate);
            logger.debug("cryptoKey: " + cryptoKey);
        }
        try {
            this.setResultParam("data", URLEncoder.encode(NetpayUtils.encrypt(params, cryptoKey), "utf-8"));
            this.setResultParam("expire", URLEncoder.encode(orderDate, "utf-8"));
            this.setResultParam("auth", auth);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.context.getResponse().setHeader("Pragma", "no-cache");
        this.context.getResponse().setHeader("Cache-Control", "no-cache");
    }
}

