<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
	<xsl:choose>
		<xsl:when test="data/@action='LicenseCommon'">Управление лицензиями</xsl:when>
		<xsl:when test="data/@action='Orders'">Заказы</xsl:when>
		<xsl:when test="data/@action='GetBills'">Заказы</xsl:when>
		<xsl:when test="data/@action='Components'">Компоненты</xsl:when>
		<xsl:when test="data/@action='License'">Текущая лицензия</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="/data">
	<xsl:choose>
		<xsl:when test="@action='LicenseCommon'">
			<xsl:call-template name="MainMenu"/>
		</xsl:when>
		<xsl:when test="@action='Orders'">
			<xsl:call-template name="Orders"/>
		</xsl:when>
		<xsl:when test="@action='GetBills'">
			<xsl:call-template name="Bills"/>
		</xsl:when>
		<xsl:when test="@action='Components'">
			<xsl:call-template name="Components"/>
		</xsl:when>
		<xsl:when test="@action='License'">
			<xsl:call-template name="License"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>


<xsl:template name="head">
<xsl:text disable-output-escaping="yes">
	<![CDATA[    
<script type="text/javascript">

window.onload=function()
{
	selectedItemChanged();
}

function selectedItemChanged()
{
	var combo = $('productItem');
	if (combo != null)
	{
		var selectedId = combo.value;
		
		var isUnlimited = ($('unlimited_' + selectedId).value == 1);
	
		$('unlimited').checked=isUnlimited;
		$('unlimited').disabled=isUnlimited;
		$('count').disabled=isUnlimited;
		
		unlimitedChecked();
	}
}

function newOrderButtonClicked()
{
	 $('copy').disabled=true;
	 $('newOrderEditor').style.display='block';
	 $('orderControlButtons').style.display='none';
}

function newOrderCancelClicked()
{
	 $('copy').disabled=false;
	 $('newOrderEditor').style.display='none';
	 $('orderControlButtons').style.display='block';
}

function unlimitedChecked()
{
	var isChecked = $('unlimited').checked;
	var inputCount = $('count');
	if (isChecked == true)
	{
		inputCount.value="-";
		inputCount.disabled=true;
	}
	else
	{
		inputCount.value="";
		inputCount.disabled=false;
	}
}

function typeChanged()
{
	var type = $('type').value;
	var term = $('term');
	if (type == 0)
	{
		term.value="";
		term.disabled=false;
		$('amountTitle').innerHTML = "Общее количество";
	}
	else
	{
		term.value="-";
		term.disabled=true;
		$('amountTitle').innerHTML = "Докупаемое количество";
	}
}

function setChecked(key, value) { jQuery('input.' + key).each( function() { this.checked = value; } ); }

function enableHelp() 
{
	var helpButtons = document.getElementsByName('help');
	var helpBlocks = document.getElementsByName('helpBlock');

    for(var i = 0; i < helpButtons.length; i++)
    {
    	var but = helpButtons.item(i); 
    	var bl = helpBlocks.item(i);
        bl.style.display='none';
        
        if (but.style.display=='block')
        {
        	but.style.display='none';
        }
        else
        {
        	but.style.display='block';
        }
    }
    $('helpEnabledIndicator').value="on";
}

function toggleHelpBlock(id)
{
	var blocks = document.getElementsByName('helpBlock');
	var blockDisplay = $(id).style.display;
	
	for (var i = 0; i < blocks.length; i++)	{
		blocks.item(i).style.display='none';
	}
	
	if (blockDisplay=='block') {
		$(id).style.display='none';
	}
	else {
		$(id).style.display='block';
	}
}
</script>   
]]>
</xsl:text>
</xsl:template>

<!-- Комбобокс со списком продуктов + кнопки для переключения между заказами, компонентами и лицензиями -->
<xsl:template name="MainMenu">
		<form id="menuForm" method="post" action="{$WEBEXECUTER}">
			<xsl:call-template name="module"/>
			<input type="hidden" id="action" name="action" value="" />
			<input type="hidden" id="helpEnabledIndicator" value="off"/>
			<table border='0' class="filter">
			 	<tr>
					<td>Доступные продукты:</td>
					<td>
						<select class="gradbtn " id="copy" name="copy">
				  		<xsl:for-each select="copies/copy">
				  			<option>
				  				<xsl:attribute name="value"> <xsl:value-of select="@id"/> </xsl:attribute>
				  				<xsl:if test="@selected='true'"> <xsl:attribute name="selected"/> </xsl:if>
				  				<xsl:value-of select="@title"/>
				  			</option>
				  		</xsl:for-each>
						</select>
					</td>
			  	</tr>
			</table>
			<table cellspacing="0">
				<tr>
					<td>
						<xsl:call-template name="button">
							<xsl:with-param name="title" select="'Заказы'"/>
							<xsl:with-param name="onclick">$('action').value='Orders'; $('copy').disabled=false; $('menuForm').submit();</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="Help">
							<xsl:with-param name="text">Просмотр списка заказов, создание и удаление заказов. </xsl:with-param>
							<xsl:with-param name="blockId">ordersHelpBlock</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="button">
							<xsl:with-param name="title" select="'Компоненты'"/>
							<xsl:with-param name="onclick">$('action').value='Components'; $('copy').disabled=false; $('menuForm').submit();</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="Help">
							<xsl:with-param name="text">Просмотр списка компонентов, генерация новой лицензии. </xsl:with-param>
							<xsl:with-param name="blockId">componentsHelpBlock</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="button">
							<xsl:with-param name="title" select="'Лицензия'"/>
							<xsl:with-param name="onclick">$('action').value='License'; $('copy').disabled=false; $('menuForm').submit();</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="Help">
							<xsl:with-param name="text">Информация о текущей лицензии.</xsl:with-param>
							<xsl:with-param name="blockId">licenseHelpBlock</xsl:with-param>
						</xsl:call-template>
					</td>
					<td style="padding-right: 0; text-align: right;" width="100%">
						<a href="#" onclick="enableHelp();"><img src="img/help.png" alt="Помощь"/></a>
					</td>
				</tr>
			</table>
		</form>
</xsl:template>

<xsl:template name="Orders">
	<xsl:call-template name="MainMenu"/>
		<form id="orderTableForm" method="post" action="{$WEBEXECUTER}">
			<xsl:call-template name="module"/>
			<input type="hidden" id="ordersAction" name="action" value="Orders" />
			<input type="hidden" id="orderTableCopyId" name="copy" value="" />
			<input type="hidden" id="orderCopyTerm" name="copyTerm" value=""/>
			
			<xsl:call-template name="OrderFilters"/>
			
			<!-- таблица заказов -->
			<table cellspacing="1" style="margin: 10px; border: 0px; width: auto;" class="table800">
				<col width="30"/>
				<col width="50"/>
				<col width="150"/>
				<col width="150"/>
				<col/>
				<col width="100"/>
				<col width="150"/>
				<col width="150"/>
				<thead>
					<tr>
						<td></td>
						<td>ID</td>
						<td>Статус</td>				
						<td>Тип</td>				
						<td>Наименование</td>
						<td>Количество</td>
						<td>Дата создания</td>
						<td>Пользователь</td>
					</tr>
				</thead>
				
				<tbody>
					<xsl:for-each select="ordersList/item">
					<xsl:variable name="i" select="position()"/>
					<tr>
						<td>
							<input type="checkbox">
								<xsl:attribute name="name">chbx_<xsl:value-of select="$i"/></xsl:attribute>
								<xsl:attribute name="value"> <xsl:value-of select="@id"/>	</xsl:attribute>
							</input>
						</td>
						<td><xsl:value-of select="@id"/></td>
						<td><xsl:value-of select="@status"/></td>
						<td><xsl:value-of select="@type"/></td>
						<td style="text-align: left;"><xsl:value-of select="@title"/></td>
						<td><xsl:value-of select="@count"/></td>
						<td nowrap="true"><xsl:value-of select="@create_date"/></td>
						<td nowrap="true"><xsl:value-of select="@user"/></td>
					</tr>
					</xsl:for-each>
				</tbody>
				
			</table>
			
			<input type="hidden" name="ordersCount">
				<xsl:attribute name="value"> <xsl:value-of select="ordersCount"/> </xsl:attribute>
			</input>
		</form>
		
		<xsl:call-template name="OrderControlButtons"/>
		<xsl:call-template name="NewOrder"/>
		
		<xsl:if test="error!=''">
				<script language="JavaScript"> errorText = "<xsl:value-of select="error"/>"; <![CDATA[ alert( errorText );]]> </script>
		</xsl:if>
</xsl:template>

<xsl:template name="Components">
	<div class="report">
		<xsl:call-template name="MainMenu"/>

		<xsl:if test="licenseCreatedMessage!=''">
			<div class="infoMessage"><xsl:value-of select="licenseCreatedMessage"/></div>
		</xsl:if>
		
		<form id="componentTableForm" method="post" action="{$WEBEXECUTER}">
			<xsl:call-template name="module"/>
			<input type="hidden" id="componentsAction" name="action" value="Components" />
			<input type="hidden" id="componentTableCopyId" name="copy" value="" />

			Отображать компоненты:
			<select class="gradbtn " name="componentsFilter" onchange="$('componentTableCopyId').value=$('copy').value; $('componentTableForm').submit();">
		  		<option value="0">
		  			<xsl:if test="componentsFilter='0'"><xsl:attribute name="selected"/></xsl:if>
		  			с наибольшим количеством
		  		</option>
		  		<option value="1">
		  			<xsl:if test="componentsFilter='1'"><xsl:attribute name="selected"/></xsl:if>
		  			только купленные
		  		</option>
		  		<option value="2">
		  			<xsl:if test="componentsFilter='2'"><xsl:attribute name="selected"/></xsl:if>
		  			все
		  		</option>
			</select>
			
			<br/><br/>
			
			<table cellspacing="1" style="border: 0px;" class="table800">
				<col width="30"/>
				<col width="150"/>
				<col/>
				<col width="100"/>
				<thead>
					<tr>
						<td></td>
						<td>Тип</td>				
						<td>Наименование</td>
						<td>Количество</td>
						<td>Дата окончания</td>
					</tr>
				</thead>
				<tbody>
					<xsl:for-each select="componentsList/item">
					<xsl:variable name="i" select="position()"/>
					<tr>
						<td>
							<input type="checkbox">
								<xsl:attribute name="class">componentItem <xsl:choose><xsl:when test="@type='постоянный'">componentItemPersistent</xsl:when><xsl:otherwise>componentItemTemporary</xsl:otherwise></xsl:choose></xsl:attribute>
								<xsl:attribute name="id">chbx_<xsl:value-of select="$i"/></xsl:attribute>
								<xsl:attribute name="name">chbx_<xsl:value-of select="$i"/></xsl:attribute>
								<xsl:attribute name="value"> <xsl:value-of select="@ids"/> </xsl:attribute>
							</input>
							
							<input type="hidden">
								<xsl:attribute name="name">product_item_id_<xsl:value-of select="$i"/></xsl:attribute>
								<xsl:attribute name="value"> <xsl:value-of select="@product_item_id"/> </xsl:attribute>
							</input>
						</td>
						<td><xsl:value-of select="@type"/></td>
						<td style="text-align: left;"><xsl:value-of select="@title"/></td>
						<td><xsl:value-of select="@count"/></td>
						<td nowrap="true"><xsl:value-of select="@to_date"/></td>
					</tr>
					</xsl:for-each>
				</tbody>
			</table>
			
			<input type="hidden" name="itemsCount"><xsl:attribute name="value"> <xsl:value-of select="itemsCount"/> </xsl:attribute></input><br/>
			
			<div id="copyItemButtons" style="display:block;">
				<table cellspacing="0">
					<tr>
						<td><input type="button" value="Выделить все" onclick="setChecked('componentItem', true );" /></td>
						<td><input type="button" value="Выделить постоянные" onclick="setChecked('componentItem', false ); setChecked('componentItemPersistent', true );"/></td>
						<td><input type="button" value="Выделить тестовые" onclick="setChecked('componentItem', false ); setChecked('componentItemTemporary', true );"/></td>
						<td><input type="button" value="Снять выделение" onclick="setChecked('componentItem', false );" /></td>
						<td><input type="button" value="Создать лицензию"><xsl:attribute name="onclick"> $('componentsAction').value='GenerateLicense'; $('componentTableCopyId').value=$('copy').value; $('componentTableForm').submit(); </xsl:attribute></input></td>
						<td>
							<xsl:call-template name="Help">
								<xsl:with-param name="text">Создание лицензии для выбранных компонентов. В лицензию не могут быть включены несколько одинаковых компонентов.</xsl:with-param>
								<xsl:with-param name="blockId">orderCopyHelpBlock</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</div>
</xsl:template>

<xsl:template name="License">
	<div class="report">
		<xsl:call-template name="MainMenu"/>
	
		<xsl:if test="sendEmailMessage!=''">
			<div class="infoMessage"><xsl:value-of select="sendEmailMessage"/></div>
		</xsl:if>
		<xsl:if test="sendEmailError!=''">
			<xsl:call-template name="error"> <xsl:with-param name="text" select="sendEmailError"/> </xsl:call-template>
		</xsl:if>
		<h3>Компоненты лицензии</h3>
		<table cellspacing="1" style="border: 0px;" class="table800">
			<col width="150"/>
			<col/>
			<col width="100"/>
			<col width="150"/>
			<col width="150"/>
			<thead>
				<tr>
					<td>Тип</td>				
					<td>Наименование</td>
					<td>Количество</td>
					<td>Дата окончания</td>
					<td>Стоимость</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="licenseItemsList/item">
				<tr>
					<td><xsl:value-of select="@type"/></td>
					<td style="text-align: left;"><xsl:value-of select="@title"/></td>
					<td><xsl:value-of select="@count"/></td>
					<xsl:choose>
						<xsl:when test="@dateOf='true'">
							<td nowrap="true"><xsl:value-of select="@to_date"/> <span style="color: red"> Просрочено</span> </td>
						</xsl:when>
						<xsl:otherwise>
							<td nowrap="true"><xsl:value-of select="@to_date"/></td>
						</xsl:otherwise>
					</xsl:choose>
					<td><xsl:value-of select="@cost"/></td>
				</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
		Общая стоимость : 
		<input type="text" readonly="true">
			<xsl:attribute name="value">
				<xsl:value-of select="totalCost"/>
			</xsl:attribute>
		</input>
		<br/>
		<form id="sendLicenseTextForm" method="post" action="{$WEBEXECUTER}">
			<xsl:call-template name="module"/>
			<input type="hidden" id="licenseTextFormCopyId" name="copy" value=""/>
			<input type="hidden" id="licenseTextAction" name="action" value="GetLicense"/>
			<input type="hidden" name="licenseId">
				<xsl:attribute name="value">
					<xsl:value-of select="licenseId"/>
				</xsl:attribute>
			</input>
			<br/>
			<table cellspacing="0">
				<tr>
					<td>
						<xsl:call-template name="button">
							<xsl:with-param name="title" select="'Получить текст лицензии по e-mail'"/>
							<xsl:with-param name="onclick">
								$('licenseTextAction').value='GetLicenseByEmail'; $('licenseTextFormCopyId').value=$('copy').value; $('sendLicenseTextForm').submit();
							</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="Help">
							<xsl:with-param name="text">
								Отправка лицензии на электронный ящик, указанный в параметрах договора.
								Если адресов несколько, лицензия будет отправлена на каждый из них.
							</xsl:with-param>
							<xsl:with-param name="blockId">getLicenseByEmailHelpBlock</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="button">
							<xsl:with-param name="title" select="'Скачать файл лицензии'"/>
							<xsl:with-param name="onclick">
								$('licenseTextAction').value='GetLicense'; $('licenseTextFormCopyId').value=$('copy').value; $('sendLicenseTextForm').submit();
							</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="Help">
							<xsl:with-param name="text">
								Получение файла лицензии без отправки на e-mail. Для версии 4.6 и старше: 
								файл необходимо положить в BGBillingServer/data/.
								Для версии 4.5 и младше: необходимо заменить все ключи lic.* и licence.*, 
								расположенные после lic.key в файле BGBillingServer/data/data.properties на 
								содержимое полученного файла lic.properties.
							</xsl:with-param>
							<xsl:with-param name="blockId">getLicenseHelpBlock</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</form>	
		
	</div>
</xsl:template>

<xsl:template name="OrderFilters">
	<div class="report">
	
		<table cellspacing="0"  style="border: 0px;">
			<tr>
				<td>
					статус
					<select class="gradbtn " id="statusFilter" name="statusFilter" onchange="$('orderTableCopyId').value=$('copy').value; $('orderTableForm').submit();">
						<option value="-1">
							<xsl:if test="filterStatus='-1'"> <xsl:attribute name="selected"/> </xsl:if>
							любой
						</option>
						<option value="0">
							<xsl:if test="filterStatus='0'"> <xsl:attribute name="selected"/> </xsl:if>
							новый
						</option>
						<option value="1">
							<xsl:if test="filterStatus='1'"> <xsl:attribute name="selected"/> </xsl:if>
							отказано
						</option>
						<option value="2">
							<xsl:if test="filterStatus='2'"> <xsl:attribute name="selected"/> </xsl:if>
							подтвержденный и выполненный
						</option>
					</select>
				</td>
				<td>
					тип
					<select class="gradbtn " id="typeFilter" name="typeFilter" onchange="$('orderTableCopyId').value=$('copy').value; $('orderTableForm').submit();">
						<option value="-1">
							<xsl:if test="filterType='-1'">	<xsl:attribute name="selected"/> </xsl:if>
							любой
						</option>
						<option value="0">
							<xsl:if test="filterType='0'"> <xsl:attribute name="selected"/>	</xsl:if>
							тестовый
						</option>
						<option value="1">
							<xsl:if test="filterType='1'"> <xsl:attribute name="selected"/>	</xsl:if>
							постоянный
						</option>
					</select>
				</td>
				<td>
					компонент
					<select class="gradbtn " id="componentFilter" name="componentFilter" onchange="$('orderTableCopyId').value=$('copy').value; $('orderTableForm').submit();">
						<option value="-1">
							<xsl:if test="filterComponent='-1'"> <xsl:attribute name="selected"/> </xsl:if>
							все
						</option>
					  	<xsl:for-each select="componentsList/item">
					  		<option>
					  			<xsl:attribute name="value"> <xsl:value-of select="@id"/> </xsl:attribute>
					  			<xsl:if test="@selected='true'"> <xsl:attribute name="selected"/> </xsl:if>
					  			<xsl:value-of select="@title"/>
					  		</option>
					  	</xsl:for-each>
					</select>
				</td>
			</tr>
		</table>
			
	</div>
</xsl:template>

<xsl:template name="OrderControlButtons">
	<div id="orderControlButtons" style="display:block;">
		<table cellspacing="0" valign="top">
			<tr>
				<td valign="top">
					<xsl:call-template name="button">
						<xsl:with-param name="title" select="'Новый заказ'"/>
						<xsl:with-param name="onclick"> newOrderButtonClicked(); </xsl:with-param> 
					</xsl:call-template>	
				</td>
				<td>
					<xsl:call-template name="Help">
						<xsl:with-param name="text">
							Добавление нового заказа. После добавлении заказа на покупку компонента следует
							отправить уведомление из пункта "Счет для выделенных заказов". При добавлении 
							тестовых заказов уведомления отправляются автоматически.
						</xsl:with-param>
						<xsl:with-param name="blockId">addOrderHelpBlock</xsl:with-param>
					</xsl:call-template>
				</td>
				<td valign="top">
					<xsl:call-template name="button">
						<xsl:with-param name="title" select="'Копировать выбранные в тестовые'"/>
						<xsl:with-param name="onclick"> document.getElementById('copyOrders').style.display='block'; </xsl:with-param> 
					</xsl:call-template>
					<div id="copyOrders" style="display: none;">
						<table cellspacing="0" width="100%">
							<tr><td style="text-align: left;" colspan="2">на срок <input type="text" id="copyTerm" name="copyTerm" size="5"/> дней</td></tr>
							<tr>
								<td width="10%">
									<xsl:call-template name="button">
										<xsl:with-param name="title" select="'OK'"/>
										<xsl:with-param name="onclick"> 
											$('ordersAction').value='CopyOrders'; 
											$('orderTableCopyId').value = $('copy').value; 
											$('orderCopyTerm').value = $('copyTerm').value;
											$('orderTableForm').submit(); 
											</xsl:with-param> 
									</xsl:call-template>
								</td>
								<td>
									<xsl:call-template name="button">
										<xsl:with-param name="title" select="'Отмена'"/>
										<xsl:with-param name="onclick"> $('copyOrders').style.display='none'; </xsl:with-param> 
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</div>	
				</td>
				<td>
					<xsl:call-template name="Help">
						<xsl:with-param name="text">
							Для новых заказов на покупку компонентов, позволяет создать аналогичный 
							заказ на тестовые компоненты для пользования на время до проведения оплаты счета.
						</xsl:with-param>
						<xsl:with-param name="blockId">orderCopyHelpBlock</xsl:with-param>
					</xsl:call-template>
				</td>
				<td valign="top">
					<xsl:call-template name="button">
						<xsl:with-param name="title" select="'Удалить выбранные'"/>
						<xsl:with-param name="onclick"> $('ordersAction').value='DeleteOrder'; $('orderTableCopyId').value=$('copy').value; $('orderTableForm').submit(); </xsl:with-param> 
					</xsl:call-template>
				</td>
				<td>
				</td>
				<td valign="top">
					<xsl:call-template name="button">
						<xsl:with-param name="title" select="'Счет для выбранных заказов'"/>
						<xsl:with-param name="onclick"> $('ordersAction').value='GetBills'; $('orderTableCopyId').value=$('copy').value; $('orderTableForm').submit(); </xsl:with-param> 
					</xsl:call-template>
				</td>						
				<td>
					<xsl:call-template name="Help">
						<xsl:with-param name="text">
							Выводит счет для выбранных заказов в виде таблицы. В таблице отражены количество и стоимость 
							уже приобретенных компонентов, компонентов из новых заказов (еще не подтвержденных), а также
							суммарные значения (сколько будет после подтверждения). В таблицу не выводится информация о 
							заказах для тестовых компонентов. Данные таблицы должны быть отправлены на электронный ящик 
							BiTel в качестве уведомления о добавлении новых заказов на покупку.
						</xsl:with-param>
						<xsl:with-param name="blockId">billsHelpBlock</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</div>
</xsl:template>

<xsl:template name="NewOrder">
	<div id="newOrderEditor" style="display:none;">
		<form id="newOrderForm" method="post" action="{$WEBEXECUTER}">
			<xsl:call-template name="module"/>
			<input type="hidden" id="action" name="action" value="AddOrder" />
			<input type="hidden" id="newOrderFormCopyId" name="copy" value="" />
			<h4>Новый заказ</h4>
			<table style="border: 0px;" cellspacing="0">
				<tr>
					<td  style="text-align: left;">Добавляемый компонент</td>
					<td>
						<xsl:for-each select="componentsList/item">
					  		<input type="hidden">
					  			<xsl:attribute name="id">unlimited_<xsl:value-of select="@id"/></xsl:attribute>
					  			<xsl:attribute name="value"><xsl:value-of select="@unlimited"/></xsl:attribute>
					  		</input>
					  	</xsl:for-each>
						<select class="gradbtn " id="productItem" name="productItem" style="width:100%" onchange="selectedItemChanged();">
						  	<xsl:for-each select="componentsList/item">
						  		<xsl:choose>
								<xsl:when test="@canAdded='true'">
									<option onclick="selectedItemChanged();">
						  			<xsl:attribute name="value"> <xsl:value-of select="@id"/> </xsl:attribute>
						  			<xsl:value-of select="@title"/>
						  			</option>
								</xsl:when>
								</xsl:choose>
						  	</xsl:for-each>
						</select>
					</td>
				</tr>
				<tr>
					<td style="text-align: left;">Тип</td>
					<td valign="center">
						<select class="gradbtn " id="type" style="width:100%;" name="type" onchange="typeChanged();">
							<option value="0" selected="true">тестовый</option>
							<option value="1">постоянный</option>
						</select>
					</td>
				</tr>
				<tr>
					<td style="text-align: left;"><span id="amountTitle">Общее количество</span></td>
					<td  style="vertical-align: middle;">
						<input id="count" type="text" name="count" size="5" value=""/>
						<input id="unlimited" style="vertical-align: middle;" type="checkbox" name="unlimited" value="on" onclick="unlimitedChecked();">неограничено</input>
					</td>
				</tr>
				<tr>
					<td style="text-align: left;">Срок (дней)</td>
					<td> <input id="term" style="width:100%;" type="text" name="term"/>	</td>
				</tr>
				<tr>
					<td>
						<table cellspacing="0">
							<tr>
								<td>
									<xsl:call-template name="button">
										<xsl:with-param name="title" select="'Сохранить'"/>
										<xsl:with-param name="onclick"> 
											$('unlimited').disabled=false; $('action').value='AddOrder'; $('newOrderFormCopyId').value=$('copy').value; $('newOrderForm').submit();
										</xsl:with-param> 
									</xsl:call-template>
								</td>
								<td>
									<xsl:call-template name="button">
										<xsl:with-param name="title" select="'Отмена'"/>
										<xsl:with-param name="onclick"> newOrderCancelClicked(); </xsl:with-param> 
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
					<td></td>
				</tr>
			</table>
		</form>
	</div>
</xsl:template>

<xsl:template name="Bills">
	<div class="report">
		<xsl:call-template name="Orders"/>
		<form id="itemBillsForm" method="post" action="{$WEBEXECUTER}">
			<xsl:call-template name="module"/>
			<input type="hidden" id="action" name="action" value="SendBills"/>
			<input type="hidden" id="itemBillsCopyId" name="copy" value=""/>
			<table width="100%" border="0" cellspacing="0" >
				<tr>
					<td style="text-align:left;">
						<h3>Счет для выбранных заказов</h3>
						<table style="width: auto;" border="0" cellspacing="1" class="table800">
							<col />
							<col width="120"/>
							<col width="120"/>
							<col width="120"/>
							<col width="120"/>
							<col width="120"/>
							<col width="120"/>
							<col width="120"/>
							<thead>
								<tr>
									<td rowspan="2">Наименование компонента</td>
									<td colspan="2">В наличии</td>
									<td colspan="2">Новые заказы</td>				
									<td colspan="2">После оплаты заказов</td>				
									<td rowspan="2">Сумма доплаты</td>
								</tr>
								<tr>
									<td>Количество</td>
									<td>Cумма</td>
									<td>Количество</td>
									<td>Cумма</td>
									<td>Количество</td>
									<td>Cумма</td>	
								</tr>
							</thead>
							<tbody>
								<xsl:for-each select="bills/item">
									<xsl:variable name="i" select="position()"/>
									<tr>
										<td style="text-align: left;">
											<xsl:value-of select="@title"/>
											<input type="hidden">
												<xsl:attribute name="name">title_<xsl:value-of select="$i"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="@title"/></xsl:attribute>
											</input> 
										</td>
										<td>
											<xsl:value-of select="@existCount"/>
											<input type="hidden">
												<xsl:attribute name="name">existCount_<xsl:value-of select="$i"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="@existCount"/></xsl:attribute>
											</input> 
										</td>
										<td>
											<xsl:value-of select="@existCost"/>
											<input type="hidden">
												<xsl:attribute name="name">existCost_<xsl:value-of select="$i"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="@existCost"/></xsl:attribute>
											</input> 
										</td>
										<td>
											<xsl:value-of select="@newCount"/>
											<input type="hidden">
												<xsl:attribute name="name">newCount_<xsl:value-of select="$i"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="@newCount"/></xsl:attribute>
											</input> 
										</td>
										<td>
											<xsl:value-of select="@newCost"/>
											<input type="hidden">
												<xsl:attribute name="name">newCost_<xsl:value-of select="$i"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="@newCost"/></xsl:attribute>
											</input> 
										</td>
										<td>
											<xsl:value-of select="@totalCount"/>
											<input type="hidden">
												<xsl:attribute name="name">totalCount_<xsl:value-of select="$i"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="@totalCount"/></xsl:attribute>
											</input> 
										</td>
										<td>
											<xsl:value-of select="@totalCost"/>
											<input type="hidden">
												<xsl:attribute name="name">totalCost_<xsl:value-of select="$i"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="@totalCost"/></xsl:attribute>
											</input> 
										</td>
										<td>
											<xsl:value-of select="@paySum"/>
											<input type="hidden">
												<xsl:attribute name="name">paySum_<xsl:value-of select="$i"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="@paySum"/></xsl:attribute>
											</input> 
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
						<div style="margin-top: 10px; font-size: 130%;"><b>Итого к оплате: <xsl:value-of select="totalPaySum"/></b></div>
						<input type="hidden" name="totalPaySum"><xsl:attribute name="value"><xsl:value-of select="totalPaySum"/></xsl:attribute></input> 
					</td>
				</tr>
			</table>
			<xsl:if test="billsCount!='0'">
				<div style="margin-top: 10px;">Комментарий:<br/><textarea name="comment" style="width: 500px;" rows="5"></textarea></div>
				<div style="margin-top: 10px;">E-mail для отправки счета:<br/><input name="email" type="text" style="width:200px;"/></div>
				<div style="margin-top: 10px;"><xsl:call-template name="button">
					<xsl:with-param name="title" select="'Отправить запрос на выписку счета'"/>
					<xsl:with-param name="onclick"> $('itemBillsCopyId').value = $('copy').value; $('itemBillsForm').submit(); </xsl:with-param> 
				</xsl:call-template></div>
    				<div style="margin: 10px 0px;">После обработки Вашего запроса менеджером, счёт будет доступен в разделе "Счета", а дополнительное соглашение в разеделе "Документы".</div>
			</xsl:if>
		</form>
	</div>
</xsl:template>

<xsl:template name="Help">
	<xsl:param name="text"/>
	<xsl:param name="blockId"/>
	<div name="help" style="display: none;"><img src="img/help_16.png" alt="Помощь" onclick="toggleHelpBlock('{$blockId}');"/></div>
	<div name="helpBlock"
		style="text-align: left; width: 300px; padding: 5px; background-color: white; border: 1px solid black; position: absolute; display: none;"
		onmouseout="">
		<xsl:attribute name="id">
			<xsl:value-of select="$blockId"/>
		</xsl:attribute>
		<xsl:value-of select="$text"/>
	</div>
</xsl:template>

</xsl:stylesheet>