/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.inet;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;

public class IpNet
implements Serializable {
    private static final long serialVersionUID = -3930104923642129612L;
    private static final byte[] ffBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    protected byte[] subnet;
    protected int mask;

    public IpNet() {
    }

    public IpNet(byte[] subnet, int mask) {
        this.subnet = subnet;
        this.mask = mask;
    }

    @XmlAttribute(name="net")
    public byte[] getSubnet() {
        return this.subnet;
    }

    public void setSubnet(byte[] subnet) {
        this.subnet = subnet;
    }

    @XmlAttribute(name="mask")
    public int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public String toString() {
        return IpNet.toString(this.subnet, this.mask);
    }

    public static String toString(byte[] subnet, int mask) {
        StringBuilder sb = new StringBuilder(subnet != null ? subnet.length * 3 + 4 : 32);
        return sb.append(IpAddress.toString(subnet)).append('/').append(mask).toString();
    }

    public static String toString(byte[] addressFrom, byte[] addressTo) {
        if (addressTo == null) {
            return IpAddress.toString(addressFrom);
        }
        int mask = addressTo != null ? IpNet.getMask(addressFrom, addressTo) : addressFrom.length * 8;
        StringBuilder sb = new StringBuilder(addressFrom != null ? addressFrom.length * 3 + 4 : 32);
        IpAddress.toString(addressFrom, sb);
        return sb.append('/').append(mask).toString();
    }

    public static String toRFCString(byte[] addressFrom, byte[] addressTo) {
        if (addressTo == null) {
            return IpAddress.toRFCString(addressFrom);
        }
        int mask = addressTo != null ? IpNet.getMask(addressFrom, addressTo) : addressFrom.length * 8;
        StringBuilder sb = new StringBuilder(addressFrom != null ? addressFrom.length * 3 + 4 : 32);
        IpAddress.toRFCString(addressFrom, sb);
        return sb.append('/').append(mask).toString();
    }

    public static int maskToInt(byte[] mask) {
        int result = 0;
        for (int i = mask.length - 1; i >= 0; --i) {
            int num = Integer.numberOfTrailingZeros(mask[i]);
            if (num >= 8) {
                result += 8;
                continue;
            }
            result += num;
            break;
        }
        return result;
    }

    public byte[] getHostMin() {
        return IpNet.getHostMin(this.subnet, this.mask);
    }

    public byte[] getHostMax() {
        if (this.subnet.length == 4 && this.mask == 32) {
            byte[] result = new byte[4];
            System.arraycopy(this.subnet, 0, result, 0, 4);
            return result;
        }
        if (this.subnet.length == 16 && this.mask == 128) {
            byte[] result = new byte[4];
            System.arraycopy(this.subnet, 0, result, 0, 16);
            return result;
        }
        byte[] broadcast = IpNet.getBroadcast(this.subnet, this.mask);
        IpAddress.decrement(broadcast);
        return broadcast;
    }

    public byte[] getBroadcast() {
        return IpNet.getBroadcast(this.subnet, this.mask);
    }

    public byte[] getNetmaskWildcard() {
        return IpNet.getNetmaskWildcard(this.subnet.length, this.mask);
    }

    public byte[] getNetmask() {
        return IpNet.getNetmask(this.subnet.length, this.mask);
    }

    public byte[] getMaxIp() {
        int i;
        if (this.subnet.length == 4 && this.mask == 32) {
            byte[] result = new byte[4];
            System.arraycopy(this.subnet, 0, result, 0, 4);
            return result;
        }
        if (this.subnet.length == 16 && this.mask == 128) {
            byte[] result = new byte[4];
            System.arraycopy(this.subnet, 0, result, 0, 16);
            return result;
        }
        byte[] addressTo = new byte[this.subnet.length];
        System.arraycopy(this.subnet, 0, addressTo, 0, this.subnet.length);
        for (i = this.subnet.length - 1; i > this.mask / 8; --i) {
            addressTo[i] = -1;
        }
        if (this.mask % 8 != 0) {
            int n = i;
            addressTo[n] = (byte)(addressTo[n] | (byte)(255 >> this.mask % 8));
        } else if (this.mask / 8 == 15) {
            int n = i;
            addressTo[n] = (byte)(addressTo[n] | 0);
        } else {
            int n = i;
            addressTo[n] = (byte)(addressTo[n] | (byte)(255 >> this.mask % 8));
        }
        return addressTo;
    }

    public static int getMask(byte[] addressFrom, byte[] addressTo) {
        assert (addressFrom.length == addressTo.length);
        int size = addressFrom.length;
        for (int i = 0; i < size; ++i) {
            if (addressFrom[i] == addressTo[i]) continue;
            return i * 8 + (Integer.numberOfLeadingZeros(addressFrom[i] & 0xFF ^ addressTo[i] & 0xFF) - 24);
        }
        return size * 8;
    }

    public static IpNet newInstance(byte[] addressFrom, byte[] addressTo) {
        int mask = addressTo != null ? IpNet.getMask(addressFrom, addressTo) : addressFrom.length * 8;
        return new IpNet(addressFrom, mask);
    }

    public boolean inNet(byte[] address) {
        return IpNet.inNet(address, this.subnet, this.mask);
    }

    public static boolean inNet(byte[] address, byte[] subnet, int mask) {
        if (mask == 0) {
            return true;
        }
        int end = mask / 8;
        int i = end - 1;
        if (i < 0) {
            int remainder = mask;
            if (Integer.numberOfLeadingZeros(address[end] & 0xFF ^ subnet[end] & 0xFF) - 24 < remainder) {
                return false;
            }
        } else {
            int remainder;
            if (address[i] != subnet[i]) {
                return false;
            }
            if (end < subnet.length && (remainder = mask % 8) > 0 && Integer.numberOfLeadingZeros(address[end] & 0xFF ^ subnet[end] & 0xFF) - 24 < remainder) {
                return false;
            }
            --i;
            while (i >= 0) {
                if (address[i] != subnet[i]) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    public static byte[] getNetmaskWildcard(int size, int mask) {
        int i;
        byte[] result = new byte[size];
        int max = mask / 8;
        if (max == size) {
            return result;
        }
        int part = mask % 8;
        if (part != 0) {
            for (i = size - 1; i > max; --i) {
                result[i] = -1;
            }
            int n = i;
            result[n] = (byte)(result[n] | (byte)(255 >> part));
        } else {
            while (i >= max) {
                result[i] = -1;
                --i;
            }
        }
        return result;
    }

    public static byte[] getNetmask(int size, int mask) {
        int i;
        byte[] result = new byte[size];
        System.arraycopy(ffBytes, 0, result, 0, size);
        int max = mask / 8;
        if (max == size) {
            return result;
        }
        int part = mask % 8;
        if (part != 0) {
            for (i = size - 1; i > max; --i) {
                result[i] = 0;
            }
            int n = i;
            result[n] = (byte)(result[n] & (byte)(~(255 >> part)));
        } else {
            while (i >= max) {
                result[i] = 0;
                --i;
            }
        }
        return result;
    }

    public static byte[] getBroadcast(byte[] subnet, int mask) {
        int i;
        byte[] addressTo = new byte[subnet.length];
        System.arraycopy(subnet, 0, addressTo, 0, subnet.length);
        int max = mask / 8;
        if (max == subnet.length) {
            return addressTo;
        }
        int part = mask % 8;
        if (part != 0) {
            for (i = subnet.length - 1; i > max; --i) {
                addressTo[i] = -1;
            }
            int n = i;
            addressTo[n] = (byte)(addressTo[n] | (byte)(255 >> part));
        } else {
            while (i >= max) {
                addressTo[i] = -1;
                --i;
            }
        }
        return addressTo;
    }

    static byte[] getHostMin(byte[] subnet, int mask) {
        int i;
        byte[] addressFrom = new byte[subnet.length];
        System.arraycopy(subnet, 0, addressFrom, 0, subnet.length);
        int max = mask / 8;
        if (max == subnet.length) {
            return addressFrom;
        }
        int part = mask % 8;
        if (part != 0) {
            for (i = subnet.length - 1; i > max; --i) {
                addressFrom[i] = 0;
            }
            int n = i;
            addressFrom[n] = (byte)(addressFrom[n] & (byte)(~(255 >> part)));
        } else {
            while (i >= max) {
                addressFrom[i] = 0;
                --i;
            }
        }
        IpAddress.increment(addressFrom);
        if (IpAddress.compare(subnet, addressFrom) > 0) {
            System.arraycopy(subnet, 0, addressFrom, 0, subnet.length);
            return addressFrom;
        }
        return addressFrom;
    }

    public int hashCode() {
        if (this.subnet == null) {
            return 0;
        }
        if (this.subnet.length == 16) {
            if (this.mask >= 48) {
                return 0xFF & this.subnet[5] | 0xFF00 & this.subnet[4] << 8 | 0xFF0000 & this.subnet[3] << 16 | 0xFF000000 & this.subnet[2] << 24;
            }
            if (this.mask >= 40) {
                return 0xFF & this.subnet[4] | 0xFF00 & this.subnet[3] << 8 | 0xFF0000 & this.subnet[2] << 16 | 0xFF000000 & this.subnet[1] << 24;
            }
            if (this.mask >= 32) {
                return 0xFF & this.subnet[3] | 0xFF00 & this.subnet[2] << 8 | 0xFF0000 & this.subnet[1] << 16 | 0xFF000000 & this.subnet[0] << 24;
            }
            return Utils.bytesToInt(this.subnet, 1, 4);
        }
        return Utils.bytesToInt(this.subnet, 0, 3);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IpNet)) {
            return false;
        }
        IpNet other = (IpNet)obj;
        return this.mask == other.mask && IpAddress.equals(this.subnet, other.subnet);
    }
}

