/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.update.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.update.server.LibInfo;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class LibInfoUtil {
    private static final String SHA_256 = "SHA-256";
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private static Map<String, LibInfo> clientLibInfos = null;
    private static Map<String, List<LibInfo>> appsLibInfos = null;

    public static Map<String, LibInfo> getClientLibInfos() {
        if (clientLibInfos == null) {
            clientLibInfos = new HashMap<String, LibInfo>();
            Logger logger = LogManager.getLogger();
            ArrayList<LibInfo> list = new ArrayList<LibInfo>();
            LibInfoUtil.doLibInfos(logger, list, "lib/client");
            LibInfoUtil.doLibInfos(logger, list, "lib/common");
            LibInfoUtil.doLibInfos(logger, list, "lib/ext/client");
            LibInfoUtil.doLibInfos(logger, list, "lib/ext/common");
            StringBuilder versions = new StringBuilder();
            Collections.sort(list, new LibInfo());
            for (LibInfo libInfo : list) {
                versions.append(libInfo.getHash());
            }
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(versions.toString().getBytes("UTF-8"));){
                String clientVersion = LibInfoUtil.sha256Hex(byteArrayInputStream);
                Setup.getSetup().set("bg.client.version", clientVersion);
                System.out.println("Set bg.client.version=" + clientVersion);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return clientLibInfos;
    }

    private static void doLibInfos(Logger logger, List<LibInfo> list, String dir) {
        Path libsDir;
        URI jars = null;
        try {
            jars = ClassLoader.getSystemResource(dir).toURI();
            if (logger.isDebugEnabled()) {
                logger.debug(dir + " = " + jars);
            }
        }
        catch (Exception e) {
            logger.warn("Folder \"" + dir + "\" not found!");
        }
        if (jars != null && Files.exists(libsDir = Paths.get(jars), new LinkOption[0]) && Files.isDirectory(libsDir, new LinkOption[0])) {
            for (File libFile : new File(jars).listFiles()) {
                LibInfo libInfo = new LibInfo();
                libInfo.setFile(libFile);
                libInfo.setName(LibInfoUtil.getLibName(libFile.getName()));
                libInfo.setHash(LibInfoUtil.sha256Hex(libFile.getPath()));
                clientLibInfos.put(libInfo.getName(), libInfo);
                list.add(libInfo);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\t" + libFile.getPath());
            }
        }
    }

    public static Map<String, List<LibInfo>> getAppsLibInfos() {
        if (appsLibInfos == null) {
            appsLibInfos = new HashMap<String, List<LibInfo>>();
            Document appsDocument = null;
            try {
                appsDocument = XMLUtils.parseDocument(new InputSource(LibInfoUtil.class.getResourceAsStream("/data/apps.xml")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (appsDocument != null) {
                for (Element apps : XMLUtils.selectElements(appsDocument.getDocumentElement(), "/data/apps")) {
                    String type = apps.getAttribute("type");
                    if (!Utils.notBlankString(type)) continue;
                    ArrayList list = new ArrayList();
                    XMLUtils.selectElements(apps, "lib").forEach(e -> {
                        if ("*".equals(e.getAttribute("name"))) {
                            list.addAll(LibInfoUtil.addAppLib(e.getAttribute("type"), e.getAttribute("dir")));
                        } else {
                            list.add(new LibInfo(e.getAttribute("type"), e.hasAttribute("dir") ? e.getAttribute("dir") : null, e.getAttribute("name")));
                        }
                    });
                    appsLibInfos.put(type, list);
                }
            }
        }
        return appsLibInfos;
    }

    private static List<LibInfo> addAppLib(String type, String subdir) {
        ArrayList<LibInfo> list = new ArrayList<LibInfo>();
        if (subdir == null) {
            return list;
        }
        String libDir = System.getProperty("lib.dir");
        try {
            File libAppDir = null;
            if (libDir != null) {
                libAppDir = new File(libDir + File.separator + "lib/" + subdir);
            } else {
                URL url = LibInfoUtil.class.getResource("/lib/" + subdir);
                if (url != null) {
                    libAppDir = new File(url.toURI());
                }
            }
            if (libAppDir != null) {
                for (File libAppFile : libAppDir.listFiles()) {
                    if (!libAppFile.exists() || !libAppFile.isFile() || !libAppFile.getName().endsWith(".jar")) continue;
                    String name = libAppFile.getName();
                    name = name.substring(0, name.length() - 4);
                    list.add(new LibInfo(type, subdir, name));
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static String getLibName(String name) {
        int index;
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        if ((index = name.lastIndexOf(45)) > -1 && index + 1 < name.length() && Character.isDigit(name.charAt(index + 1))) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String sha256Hex(String fileName) {
        String string;
        block8: {
            InputStream is = Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
            try {
                string = LibInfoUtil.sha256Hex(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    public static String sha256Hex(InputStream data) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(SHA_256);
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return Utils.bytesToHexString(digest.digest());
    }
}

