/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Pair;

public class TaskConverter {
    private static final Logger logger = LogManager.getLogger();
    private static String oldKernelTasks = "bitel.billing.server.contract.CleanerContract;bitel.billing.server.load.TaskGenerator;bitel.billing.server.mail.MailSender;bitel.billing.server.contract.LimitRestorer;bitel.billing.server.mail.UserDispatchSender;bitel.billing.server.script.TimerEventGenerate;bitel.billing.server.contract.DebtMailSender;bitel.billing.server.contract.ContractStatusSetter;bitel.billing.server.admin.integration.PaymentLoader;ru.bitel.bgbilling.kernel.task.server.Validator;bitel.billing.server.script.global.bean.GlobalScriptTimer;ru.bitel.bgbilling.kernel.task.server.TaskChekNewAddressCustom";

    public TaskConverter() {
        Setup setup = new Setup("data.data");
        Setup.setSetup((Setup)setup);
        try (Connection con = setup.getDBConnectionFromPool();){
            BGPluginManagerServer.getManager().init(con, "?");
            logger.info("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430 \u0437\u0430\u0434\u0430\u0447");
            String query = "SELECT st.class_id, sc.class, sc.title, st.params FROM scheduled_tasks st LEFT JOIN scheduled_class sc ON st.class_id=sc.id";
            HashMap<Integer, Pair<String, String>> classMap = new HashMap<Integer, Pair<String, String>>();
            HashMap<String, String> taskTitleMap = new HashMap<String, String>();
            try (PreparedStatement ps = con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int classId = rs.getInt("st.class_id");
                    String taskClass = rs.getString("sc.class");
                    String taskTitle = rs.getString("sc.title");
                    String params = rs.getString("st.params");
                    Pair<String, String> pair = new Pair<String, String>(taskClass, params);
                    classMap.put(classId, pair);
                    taskTitleMap.put(taskClass, taskTitle);
                }
                logger.info("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + classMap.size() + " \u0437\u0430\u0434\u0430\u0447");
            }
            query = "UPDATE scheduled_tasks SET class=?, module_id=? WHERE class_id=?";
            ps = con.prepareStatement(query);
            try {
                logger.info("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447...");
                Iterator iterator = classMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Pattern pattern;
                    Matcher matcher;
                    int key = (Integer)iterator.next();
                    String clazz = (String)((Pair)classMap.get(key)).getFirst();
                    if (!Utils.notBlankString(clazz)) continue;
                    ps.setString(1, clazz);
                    ps.setInt(3, key);
                    String params = (String)((Pair)classMap.get(key)).getSecond();
                    Object moduleId = null;
                    if (params.contains("mid") && (matcher = (pattern = Pattern.compile("mid=(\\d*)")).matcher(params)).find()) {
                        String singleParam = matcher.group();
                        moduleId = singleParam.replace("mid=", "");
                    }
                    if (Utils.isBlankString(moduleId) && oldKernelTasks.contains(clazz)) {
                        moduleId = "0";
                    }
                    if (Utils.isBlankString(moduleId)) {
                        for (BGPlugInElement element : BGPluginManagerServer.getManager().getExtensions("ru.bitel.bgbilling.kernel.task.server.TaskExecuter", false)) {
                            for (Element elem : XMLUtils.selectElements(element.getElement(), "//task")) {
                                String pluginClazz = elem.getAttribute("class");
                                if (!pluginClazz.equals(clazz)) continue;
                                moduleId = "p" + ((BGPluginServer)element.getPlugin()).getPluginUID();
                            }
                        }
                    }
                    if (Utils.isBlankString(moduleId)) {
                        logger.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443 " + (String)taskTitleMap.get(clazz) + "(" + clazz + ").");
                        continue;
                    }
                    ps.setString(2, (String)moduleId);
                    ps.executeUpdate();
                    logger.info("\t\u0417\u0430\u0434\u0430\u0447\u0430 " + (String)taskTitleMap.get(clazz) + " \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e (class =  " + clazz + "; moduleId = " + (String)moduleId + " )");
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException | BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        new TaskConverter();
        System.exit(0);
    }
}

