/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffItem;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.tariff.common.service.TariffService")
public class TariffServiceImpl
extends AbstractService
implements TariffService {
    private Directory<TariffPlan> tariffPlanDirectory = null;
    private Directory<TariffGroup> tariffGroupDirectory = null;
    private TariffPlanDao tariffPlanDao = null;

    @PostConstruct
    void init() throws BGException {
        this.tariffPlanDirectory = this.context.newDirectory(TariffPlan.class, 0);
        this.tariffGroupDirectory = this.context.newDirectory(TariffGroup.class, 0);
        this.tariffPlanDao = new TariffPlanDao(this.getConnection());
    }

    @PreDestroy
    void destroy() throws BGException {
        this.tariffPlanDirectory = null;
        if (this.tariffPlanDao != null) {
            this.tariffPlanDao.recycle();
        }
        this.tariffPlanDao = null;
    }

    @Override
    public SearchResult<TariffItem> searchTariffPlans(List<Integer> labelIds, List<Integer> moduleIds, int showUsed, Page page) throws BGException {
        SearchResult<TariffItem> searchResult = new SearchResult<TariffItem>();
        searchResult.setPage(page);
        return searchResult;
    }

    @Override
    public List<TariffPlan> tariffPlanList(List<Integer> contractLabelIds, Integer personType, String title) throws BGException {
        if ((contractLabelIds == null || contractLabelIds.isEmpty()) && (personType == null || personType < 0) && Utils.isEmptyString(title)) {
            return this.tariffPlanDirectory.list();
        }
        return this.tariffPlanDao.getTariffPlanList(0, contractLabelIds, personType, title);
    }

    @Override
    public TariffPlan tariffPlanGet(int id) throws BGException {
        return this.tariffPlanDirectory.get(id);
    }

    @Override
    public void tariffPlanDelete(int id) throws BGException {
        this.tariffPlanDirectory.delete(id);
    }

    @Override
    public int tariffPlanUpdate(TariffPlan tariffPlan) throws BGException {
        this.tariffPlanDirectory.update(tariffPlan);
        return tariffPlan.getId();
    }

    @Override
    public TariffGroup tariffGroupGet(int id) throws BGException {
        return this.tariffGroupDirectory.get(id);
    }

    @Override
    public void tariffGroupDelete(int id) throws BGException {
        this.tariffGroupDirectory.delete(id);
    }

    @Override
    public int tariffGroupUpdate(TariffGroup tariffGroup) throws BGException {
        this.tariffGroupDirectory.update(tariffGroup);
        return tariffGroup.getId();
    }

    @Override
    public List<TariffGroup> tariffGroupList() throws BGException {
        return this.tariffGroupDirectory.list();
    }
}

