/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.TariffOptionActivateModeDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.TariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.ContractTariffOptionChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.TariffOptionActivatedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.TariffOptionBeforeActivateEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.TariffOptionDeactivatedEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Tied;
import ru.bitel.common.util.Ranger;
import ru.bitel.common.worker.Recyclable;

public class ContractTariffOptionActivateManager
implements Recyclable {
    private static final Logger logger = LogManager.getLogger();
    private final Connection con;
    private ContractManager contractManager;
    private TariffOptionDao tariffOptionDao;
    private ContractTariffOptionDao contractTariffOptionDao;
    private Tied.Utils<ContractTariffOption, TariffOption> tiedUtils = null;

    public ContractTariffOptionActivateManager(Connection con) {
        this.con = con;
    }

    private TariffOptionDao getTariffOptionDao() {
        if (this.tariffOptionDao == null) {
            this.tariffOptionDao = new TariffOptionDao(this.con);
        }
        return this.tariffOptionDao;
    }

    private ContractManager getContractManager() {
        if (this.contractManager == null) {
            this.contractManager = new ContractManager(this.con);
        }
        return this.contractManager;
    }

    private ContractTariffOptionDao getContractTariffOptionDao() {
        if (this.contractTariffOptionDao == null) {
            this.contractTariffOptionDao = new ContractTariffOptionDao(this.con);
        }
        return this.contractTariffOptionDao;
    }

    public void activateOption(TariffOptionService tariffOptionService, int userId, int cid, int optionId, int modeId, boolean web) throws BGException, BGMessageException {
        this.activateOptionWhithSum(tariffOptionService, userId, cid, optionId, modeId, null, web);
    }

    public int activateOptionWhithSum(TariffOptionService tariffOptionService, int userId, int cid, int optionId, int modeId, BigDecimal sum, boolean web) throws BGException, BGMessageException {
        return this.activateOptionWhithSumAndPeriod(tariffOptionService, userId, cid, optionId, modeId, sum, null, web);
    }

    public int activateOptionWhithSumAndPeriod(TariffOptionService tariffOptionService, int userId, int cid, int optionId, int modeId, BigDecimal sum, Period period, boolean web) throws BGException, BGMessageException {
        if (cid <= 0 || optionId <= 0 || modeId <= 0) {
            throw new BGIllegalArgumentException();
        }
        Date date = new Date(TimeUtils.rountToSeconds(System.currentTimeMillis()));
        ContractTariffOptionDao ctom = this.getContractTariffOptionDao();
        TariffOptionActivateModeDao amm = new TariffOptionActivateModeDao(this.con);
        TariffOption option = null;
        Setup setup = Setup.getSetup();
        List<ContractTariffOption> currentOptionList = ctom.list(cid, date);
        if (setup.getBoolean("tariffOption.dontCheckOnActivateAlreadyActivated", setup.getBoolean("allow.parallel.option.activate", false))) {
            currentOptionList = new ArrayList<ContractTariffOption>();
        }
        List<TariffOption> availableOptions = tariffOptionService.tariffOptionListAvailable(cid, date, currentOptionList, true, web);
        for (TariffOption availableOption : availableOptions) {
            if (availableOption.getId() != optionId) continue;
            option = availableOption;
            break;
        }
        if (option == null) {
            throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
        }
        TariffOptionActivateMode mode = amm.get(modeId);
        if (mode == null || mode.getOptionId() != optionId) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0441 \u043a\u043e\u0434\u043e\u043c " + modeId + ".");
        }
        if (!TimeUtils.dateInRange(date, mode.getDateFrom(), mode.getDateTo())) {
            throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430!");
        }
        ContractManager cm = this.getContractManager();
        Contract contract = cm.getContractById(cid);
        if (contract == null) {
            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + cid + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        }
        ContractTariffOption contractOption = new ContractTariffOption();
        contractOption.setActivatedTime(new Date());
        contractOption.setActivatedMode(modeId);
        contractOption.setUserId(userId);
        contractOption.setContractId(cid);
        contractOption.setTimeFrom(date);
        contractOption.setOptionId(option.getId());
        Charge charge = null;
        if (sum != null && sum.compareTo(BigDecimal.ZERO) != 0 || mode.getChargeSumma().compareTo(BigDecimal.ZERO) != 0) {
            charge = new Charge();
            charge.setContractId(cid);
            charge.setComment("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 " + option.getTitle());
            charge.setTypeId(mode.getChargeTypeId());
            charge.setDate(date);
            charge.setUserId(userId);
        }
        if (period != null && period.getDateFrom() != null) {
            if (period.getDateTo() != null && period.getDateFrom().after(period.getDateTo())) {
                throw new BGMessageException("\u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434!");
            }
            if (!TimeUtils.dateInRange(period.getDateFrom(), mode.getDateFrom(), mode.getDateTo())) {
                throw new BGMessageException("\u0422\u041e \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!");
            }
            contractOption.setTimeFrom(period.getDateFrom());
            contractOption.setTimeTo(period.getDateTo());
        } else {
            int[] modeValue = TariffOptionActivateMode.mode(mode.getPeriodMode());
            int modeField = modeValue[0];
            int modeBegin = modeValue[1];
            int modeEnd = modeValue[2];
            int calendarField = switch (modeField) {
                case 1 -> 12;
                case 2 -> 11;
                case 3 -> 5;
                case 4 -> 3;
                case 5 -> 2;
                case 6 -> 1;
                default -> 2;
            };
            Calendar calendar = TimeUtils.convertDateToCalendar(contractOption.getTimeFrom());
            if (modeBegin == 2 || modeBegin == 3) {
                TimeUtils.floor(calendar, calendarField);
                if (modeBegin == 3) {
                    calendar.add(calendarField, 1);
                }
            } else if (modeBegin == 4) {
                TimeUtils.clear_MIN_MIL_SEC(calendar);
                calendar.add(11, 1);
            }
            contractOption.setTimeFrom(TimeUtils.convertCalendarToDate(calendar));
            if (mode.getPeriodCol() == 0) {
                contractOption.setTimeTo(null);
            } else {
                if (modeEnd == 2) {
                    TimeUtils.floor(calendar, calendarField);
                }
                calendar.add(calendarField, mode.getPeriodCol());
                contractOption.setTimeTo(TimeUtils.convertCalendarToDate(calendar));
            }
        }
        if (charge != null) {
            if (sum != null) {
                charge.setSum(sum);
            } else {
                charge.setSum(mode.getChargeSumma());
            }
        }
        try {
            this.getTieUtils().checkAdd(ctom.list(cid, null, false, false), contractOption, 14);
        }
        catch (Tied.TieUnresolvedException ex) {
            this.processTieException(ex, cid);
        }
        TariffOptionBeforeActivateEvent beforeActivate = EventProcessor.getInstance().request(new TariffOptionBeforeActivateEvent(cid, userId, contract, option, mode, charge, contractOption, true));
        if (!beforeActivate.isActivate()) {
            throw new BGMessageException(beforeActivate.getMessage());
        }
        charge = beforeActivate.getCharge();
        contractOption = beforeActivate.getContractTariffOption();
        if (charge != null) {
            try (BalanceUtils bu = new BalanceUtils(this.con);
                 ChargeDao chm = new ChargeDao(this.con);){
                BigDecimal balance = bu.getBalance(contractOption.getTimeFrom(), cid);
                if (balance.subtract(charge.getSum()).compareTo(contract.getBalanceLimit()) < 0) {
                    bu.close();
                    throw new BGMessageException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043e\u043f\u0446\u0438\u0438!");
                }
                chm.update(charge);
                contractOption.setChargeId(charge.getId());
                contractOption.setSumma(charge.getSum());
                bu.updateBalance(date, cid);
                EventProcessor.getInstance().publishAfterCommit(new ChargeEvent(userId, charge));
                EventProcessor.getInstance().publishAfterCommit(new ContractBalanceChangedEvent(contract.getId(), 4, charge.getSum()));
            }
        }
        ctom.update(contractOption);
        EventProcessor ep = EventProcessor.getInstance();
        ep.publishAfterCommit(new TariffOptionActivatedEvent(userId, contractOption, mode, option, false));
        ep.publishAfterCommit(new ContractTariffOptionChangedEvent(contract.getId(), userId, 1, contractOption));
        return charge != null ? charge.getId() : 0;
    }

    protected void processTieException(Tied.TieUnresolvedException ex, int cid) throws BGMessageException {
        StringBuilder sb = new StringBuilder();
        if (ex.getDependsUnresolved().size() > 0) {
            for (Map.Entry<? extends Tied, Set<Object>> e : ex.getDependsUnresolved().entrySet()) {
                sb.append(MessageFormat.format("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043e\u043f\u0446\u0438\u044e {0} \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 {2,choice,1#\u043e\u043f\u0446\u0438\u044e|1<\u043e\u043f\u0446\u0438\u0438:} {1} (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cid + ").", e.getKey(), Utils.toString((Iterable)e.getValue()), e.getValue().size())).append("\n");
            }
        }
        if (ex.getIncompatibleUnresolved().size() > 0) {
            for (Map.Entry<? extends Tied, Set<Object>> e : ex.getIncompatibleUnresolved().entrySet()) {
                sb.append(MessageFormat.format("\u041e\u043f\u0446\u0438\u044f {0} \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430 \u0441 {2,choice,1#\u043e\u043f\u0446\u0438\u0435\u0439|1<\u043e\u043f\u0446\u0438\u044f\u043c\u0438:} {1} (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cid + ") .", e.getKey(), Utils.toString((Iterable)e.getValue()), e.getValue().size())).append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        throw new BGMessageException(sb.toString());
    }

    public void deactivateOption(int userId, int cid, int contractOptionId) throws BGException {
        if (cid <= 0 || contractOptionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractTariffOptionDao ctom = this.getContractTariffOptionDao();
        Date now = new Date();
        ContractTariffOption contractOption = (ContractTariffOption)ctom.get(contractOptionId);
        if (contractOption == null || contractOption.getContractId() != cid) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043e\u043f\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOptionId + ".");
        }
        if (contractOption.getTimeTo() != null) {
            throw new BGMessageException("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430!");
        }
        this.deactivateOptionImpl(userId, cid, contractOptionId, contractOption, ctom, now, true, false);
    }

    public boolean tryDeactivateOption(int userId, int cid, int contractOptionId, boolean checkDeactivated, boolean deactivateNow) throws BGException {
        if (cid <= 0 || contractOptionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractTariffOptionDao ctom = this.getContractTariffOptionDao();
        Date now = new Date();
        ContractTariffOption contractOption = (ContractTariffOption)ctom.get(contractOptionId);
        if (contractOption == null || contractOption.getContractId() != cid) {
            return false;
        }
        if (contractOption.getTimeTo() != null) {
            if (checkDeactivated) {
                return false;
            }
            if (!now.before(contractOption.getTimeTo())) {
                return false;
            }
        }
        this.deactivateOptionImpl(userId, cid, contractOptionId, contractOption, ctom, now, checkDeactivated, deactivateNow);
        return true;
    }

    private void deactivateOptionImpl(int userId, int cid, int contractOptionId, ContractTariffOption contractOption, ContractTariffOptionDao ctom, Date now, boolean checkDeactivated, boolean deactivateNow) throws BGException {
        TariffOptionDao tom = this.getTariffOptionDao();
        TariffOptionActivateModeDao amm = new TariffOptionActivateModeDao(this.con);
        TariffOption option = (TariffOption)tom.get(contractOption.getOptionId());
        if (option == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043e\u043f\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOption.getOptionId() + ".");
        }
        TariffOptionActivateMode mode = amm.get(contractOption.getActivatedMode());
        if (mode == null || mode.getOptionId() != contractOption.getOptionId()) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOption.getActivatedMode() + ".");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(now);
            calendar.set(14, 0);
            now = calendar.getTime();
            if (contractOption.getTimeFrom().compareTo(now) > 0) {
                Date close = now;
                contractOption.setTimeTo(close);
                this.getTieUtils().checkRemove(ctom.list(cid, null, false, false), contractOption, 14);
            } else {
                Date close = now;
                if (!deactivateNow) {
                    calendar.setTime(close);
                    calendar.set(14, 0);
                    switch (mode.getDeactivationMode()) {
                        case 0: {
                            break;
                        }
                        case 4: {
                            TimeUtils.clear_MIN_MIL_SEC(calendar);
                            ((Calendar)calendar).add(11, 1);
                            break;
                        }
                        case 1: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
                            ((Calendar)calendar).add(5, 1);
                            break;
                        }
                        case 2: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
                            calendar.set(7, calendar.getFirstDayOfWeek());
                            ((Calendar)calendar).add(3, 1);
                            break;
                        }
                        case 3: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
                            calendar.set(5, 1);
                            ((Calendar)calendar).add(2, 1);
                            break;
                        }
                        case 5: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
                            calendar.set(5, 1);
                            calendar.set(2, 0);
                            ((Calendar)calendar).add(1, 1);
                            break;
                        }
                        default: {
                            throw new BGIllegalArgumentException();
                        }
                    }
                    close = TimeUtils.convertCalendarToDate(calendar);
                }
                contractOption.setTimeTo(close);
                this.getTieUtils().checkClose(ctom.list(cid, null, false, false), contractOption, close, 14);
            }
        }
        catch (Tied.TieUnresolvedException ex) {
            this.processTieException(ex, cid);
        }
        contractOption.setDeactivatedTime(now);
        ctom.update(contractOption, checkDeactivated);
        EventProcessor ep = EventProcessor.getInstance();
        ep.publishAfterCommit(new TariffOptionDeactivatedEvent(userId, contractOption, mode, option));
        ep.publishAfterCommit(new ContractTariffOptionChangedEvent(contractOption.getContractId(), userId, 2, contractOption));
    }

    public void reactivateOption(int userId, int cid, int contractOptionId) throws BGException {
        if (cid <= 0 || contractOptionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        TariffOptionDao tom = this.getTariffOptionDao();
        ContractTariffOptionDao ctom = this.getContractTariffOptionDao();
        TariffOptionActivateModeDao amm = new TariffOptionActivateModeDao(this.con);
        ContractTariffOption contractOption = (ContractTariffOption)ctom.get(contractOptionId);
        if (contractOption == null || contractOption.getContractId() != cid) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043e\u043f\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOptionId + ".");
        }
        TariffOption option = (TariffOption)tom.get(contractOption.getOptionId());
        if (option == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043e\u043f\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOption.getOptionId() + ".");
        }
        TariffOptionActivateMode mode = amm.get(contractOption.getActivatedMode());
        if (mode == null || mode.getOptionId() != contractOption.getOptionId()) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOption.getActivatedMode() + ".");
        }
        if (mode.getReactivationMode() != 1 || contractOption.getTimeTo() == null || contractOption.getDeactivatedTime() == null || !contractOption.getTimeTo().after(new Date())) {
            throw new BGMessageException("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430!");
        }
        contractOption.setDeactivatedTime(null);
        contractOption.setTimeTo(null);
        ctom.update(contractOption);
        EventProcessor ep = EventProcessor.getInstance();
        ep.publishAfterCommit(new TariffOptionActivatedEvent(userId, contractOption, mode, option, true));
        ep.publishAfterCommit(new ContractTariffOptionChangedEvent(contractOption.getContractId(), userId, 3, contractOption));
    }

    public Tied.Utils<ContractTariffOption, TariffOption> getTieUtils() throws BGException {
        if (this.tiedUtils != null) {
            return this.tiedUtils;
        }
        final Map<Integer, TariffOption> map = Id.newMap(this.getTariffOptionDao().list(null));
        this.tiedUtils = new Tied.Utils<ContractTariffOption, TariffOption>(new Tied.TieResolver<ContractTariffOption, TariffOption>(){

            @Override
            public TariffOption resolve(ContractTariffOption t) {
                return (TariffOption)map.get(this.resolveId(t));
            }

            @Override
            public int resolveId(ContractTariffOption t) {
                return t.getOptionId();
            }

            @Override
            public TariffOption resolve(Integer id) {
                return (TariffOption)map.get(id);
            }
        }, new Ranger<ContractTariffOption, Date>(){

            @Override
            public Date getMaxValue(ContractTariffOption r) {
                if (r.getTimeTo() == null) {
                    return null;
                }
                Calendar cal = TimeUtils.convertDateToCalendar(r.getTimeTo());
                cal.add(13, -1);
                return cal.getTime();
            }

            @Override
            public Date getMinValue(ContractTariffOption r) {
                return r.getTimeFrom();
            }
        });
        return this.tiedUtils;
    }

    public void deleteOption(int userId, int cid, int contractOptionId, boolean customer) throws BGException, BGMessageException {
        if (cid <= 0 || contractOptionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractTariffOptionDao ctom = this.getContractTariffOptionDao();
        Date now = new Date();
        ContractTariffOption contractOption = (ContractTariffOption)ctom.get(contractOptionId);
        if (contractOption == null || contractOption.getContractId() != cid) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043e\u043f\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOptionId + ".");
        }
        this.deleteOptionImpl(userId, cid, contractOptionId, contractOption, ctom, now, customer);
    }

    public boolean tryDeleteOption(int userId, int cid, int contractOptionId, boolean customer) throws BGException, BGMessageException {
        if (cid <= 0 || contractOptionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractTariffOptionDao ctom = this.getContractTariffOptionDao();
        Date now = new Date();
        ContractTariffOption contractOption = (ContractTariffOption)ctom.get(contractOptionId);
        if (contractOption == null || contractOption.getContractId() != cid) {
            return false;
        }
        if (contractOption.getTimeTo() != null && !now.before(contractOption.getTimeFrom())) {
            return false;
        }
        this.deleteOptionImpl(userId, cid, contractOptionId, contractOption, ctom, now, customer);
        return true;
    }

    private void deleteOptionImpl(int userId, int cid, int contractOptionId, ContractTariffOption contractOption, ContractTariffOptionDao ctom, Date now, boolean customer) throws BGException, BGMessageException {
        TariffOptionDao tom = this.getTariffOptionDao();
        TariffOptionActivateModeDao amm = new TariffOptionActivateModeDao(this.con);
        TariffOption option = (TariffOption)tom.get(contractOption.getOptionId());
        if (option == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043e\u043f\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOption.getOptionId() + ".");
        }
        TariffOptionActivateMode mode = amm.get(contractOption.getActivatedMode());
        if (mode == null || mode.getOptionId() != contractOption.getOptionId()) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0441 \u043a\u043e\u0434\u043e\u043c " + contractOption.getActivatedMode() + ".");
        }
        if (customer) {
            if (mode.getDeleteMode() != 2) {
                throw new BGMessageException("\u041e\u0442\u043c\u0435\u043d\u0430 \u043e\u043f\u0446\u0438\u0438 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
            }
            if (!now.before(contractOption.getTimeFrom())) {
                throw new BGMessageException("\u041e\u0442\u043c\u0435\u043d\u0430 \u043e\u043f\u0446\u0438\u0438 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
            }
        } else if (mode.getDeleteMode() != 1 && mode.getDeleteMode() != 2) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043e\u043f\u0446\u0438\u0438 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e.");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(now);
            calendar.set(14, 0);
            Date close = now = calendar.getTime();
            contractOption.setTimeTo(close);
            this.getTieUtils().checkRemove(ctom.list(cid, null, false, false), contractOption, 14);
        }
        catch (Tied.TieUnresolvedException ex) {
            this.processTieException(ex, cid);
        }
        contractOption.setDeactivatedTime(now);
        ctom.delete(contractOption.getId());
        EventProcessor ep = EventProcessor.getInstance();
        ep.publishAfterCommit(new TariffOptionDeactivatedEvent(userId, contractOption, mode, option));
        ep.publishAfterCommit(new ContractTariffOptionChangedEvent(contractOption.getContractId(), userId, 4, contractOption));
        if (contractOption.getChargeId() > 0 && (mode.getDeleteChargeMode() == 2 || mode.getDeleteChargeMode() == 1 && now.before(contractOption.getTimeFrom()))) {
            try (ChargeDao chm = new ChargeDao(this.con);
                 BalanceUtils bu = new BalanceUtils(this.con);){
                Charge charge = (Charge)chm.get(contractOption.getChargeId());
                if (charge != null) {
                    chm.delete(charge.getId());
                    contractOption.setChargeId(charge.getId());
                    contractOption.setSumma(charge.getSum());
                    bu.updateBalance(charge.getDate(), cid);
                    ep.publishAfterCommit(new ContractBalanceChangedEvent(cid, 4, charge.getSum().negate()));
                }
            }
        }
    }

    @Override
    public void recycle() {
        try {
            if (this.tariffOptionDao != null) {
                this.tariffOptionDao.recycle();
            }
            if (this.contractManager != null) {
                this.contractManager.recycle();
            }
            if (this.contractTariffOptionDao != null) {
                this.contractTariffOptionDao.recycle();
            }
        }
        catch (BGException e) {
            logger.error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u0411\u0414.", (Throwable)e);
        }
    }
}

