/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.client;

import bitel.billing.module.common.BGControlPanelPluginControls;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class ContractTariffOptionEditor
extends BGUPanel {
    private ContractTariffOptionTableModel model = new ContractTariffOptionTableModel(ContractTariffOptionTableModel.class.getName());
    private ContractTariffOptionTableModel historyModel = new ContractTariffOptionTableModel(ContractTariffOptionTableModel.class.getName());
    private BGUComboBox<TariffOption> optionComboBox = new BGUComboBox();
    private BGUComboBox<TariffOptionActivateMode> modeComboBox = new BGUComboBox();
    private JTabbedPane pane;
    private BGControlPanelPluginControls extensionPanel;
    private Boolean standartActivation = true;
    private TariffOptionService tariffOptionService = null;
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("refresh")){

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            Date date = new Date();
            try {
                ContractTariffOptionEditor.this.model.setData(ContractTariffOptionEditor.this.getTariffOptionService().contractTariffOptionList(((ClientContext)ContractTariffOptionEditor.this.getContext()).getContractId(), date));
                ContractTariffOptionEditor.this.historyModel.setData(ContractTariffOptionEditor.this.getTariffOptionService().contractTariffOptionHistory(((ClientContext)ContractTariffOptionEditor.this.getContext()).getContractId(), date, false));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    };
    AbstractBGUPanel.DefaultAction activate = new AbstractBGUPanel.DefaultAction("activate", "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", (Icon)ClientUtils.getIcon("fugue/present--plus")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ContractTariffOptionEditor.this.newItem();
        }
    };
    AbstractBGUPanel.DefaultAction reactivate = new AbstractBGUPanel.DefaultAction("reactivate", "\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", (Icon)ClientUtils.getIcon("fugue/present--arrow")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ContractTariffOptionEditor.this.reactivate();
        }
    };
    AbstractBGUPanel.DefaultAction deactivate = new AbstractBGUPanel.DefaultAction("deactivate", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", (Icon)ClientUtils.getIcon("fugue/present--minus")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ContractTariffOptionEditor.this.deactivate();
        }
    };
    AbstractBGUPanel.DefaultAction remove = new AbstractBGUPanel.DefaultAction("option.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", (Icon)ClientUtils.getIcon("item_delete")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ContractTariffOption option = ContractTariffOptionEditor.this.pane.getSelectedIndex() == 0 ? (ContractTariffOption)ContractTariffOptionEditor.this.model.getSelectedRow() : (ContractTariffOption)ContractTariffOptionEditor.this.historyModel.getSelectedRow();
            if (option == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                try {
                    ContractTariffOptionEditor.this.getTariffOptionService().contractTariffOptionDelete(((ClientContext)ContractTariffOptionEditor.this.getContext()).getContractId(), option.getId(), false);
                    ContractTariffOptionEditor.this.performAction("refresh");
                }
                catch (BGException ex) {
                    ((ClientContext)ContractTariffOptionEditor.this.getContext()).processException(ex);
                }
            }
        }
    };

    public ContractTariffOptionEditor() {
        try {
            this.optionComboBox.addActionListener(e -> this.reloadModeCombo());
            this.modeComboBox.addItemListener(e -> {
                if (this.extensionPanel != null && e.getStateChange() == 1) {
                    this.extensionPanel.invokeSetData(new Object[0]);
                }
            });
            this.build();
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog(e2);
        }
    }

    @Override
    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.model);
        table.setSelectionMode(0);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGSwingUtilites.buildToolBar(toolBar, this);
        toolBar.compact();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.pane = new JTabbedPane();
        this.pane.add((Component)panel, "\u0422\u0435\u043a\u0443\u0449\u0438\u0435");
        this.pane.add((Component)BGSwingUtilites.wrapEmptyBorder(new JScrollPane(new BGUTable(this.historyModel))), "\u0418\u0441\u0442\u043e\u0440\u0438\u044f");
        JPanel productPanel = new JPanel(new BorderLayout());
        productPanel.add((Component)toolBar, "North");
        productPanel.add((Component)this.pane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)productPanel, "Center");
        if (this.extensionPanel != null) {
            this.extensionPanel.invokeInitBGPanel(null, -1);
        }
    }

    private void reloadModeCombo() {
        TariffOption option = (TariffOption)this.optionComboBox.getSelectedItem();
        if (option != null) {
            this.modeComboBox.setData(option.getActivateModeList());
        }
        if (this.extensionPanel != null) {
            this.extensionPanel.invokeSetData(new Object[0]);
        }
    }

    public void newItem() {
        try {
            List<TariffOption> list = this.getTariffOptionService().tariffOptionListAvailable(((ClientContext)this.getContext()).getContractId(), null, null, false, false);
            ArrayList<TariffOption> result = new ArrayList<TariffOption>();
            list.forEach(option -> {
                if (option.isEnable()) {
                    result.add((TariffOption)option);
                }
            });
            result.add(new TariffOption("-----"));
            list.forEach(option -> {
                if (!option.isEnable()) {
                    result.add((TariffOption)option);
                }
            });
            this.optionComboBox.setData(result);
        }
        catch (BGException e2) {
            ((ClientContext)this.getContext()).processException(e2);
        }
        JButton okButton = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(this.getTariffOptionPanel());
        optionPane.setMessageType(-1);
        optionPane.setOptions(new Object[]{okButton, cancelButton});
        optionPane.setInitialValue(okButton);
        JDialog dialog = optionPane.createDialog(JOptionPane.getRootFrame(), "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e");
        okButton.addActionListener(e -> {
            this.stopActivate();
            dialog.setVisible(false);
        });
        cancelButton.addActionListener(e -> {
            okButton.setEnabled(false);
            dialog.setVisible(false);
        });
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    private JPanel getTariffOptionPanel() {
        Dimension dimension = new Dimension(500, 150);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)new JLabel("\u041e\u043f\u0446\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(this.optionComboBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panel.add(this.modeComboBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        try {
            this.extensionPanel = new BGControlPanelPluginControls(ContractTariffOptionEditor.class.getName(), panel, this);
            panel.add((Component)this.extensionPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
        return panel;
    }

    private void stopActivate() {
        TariffOption option = (TariffOption)this.optionComboBox.getSelectedItem();
        TariffOptionActivateMode mode = (TariffOptionActivateMode)this.modeComboBox.getSelectedItem();
        if (option == null || mode == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e \u0438 \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
        } else {
            try {
                if (this.extensionPanel != null && !this.extensionPanel.invokeBeforeAction(this.standartActivation)) {
                    return;
                }
                if (this.standartActivation.booleanValue()) {
                    this.getTariffOptionService().contractTariffOptionActivate(((ClientContext)this.getContext()).getContractId(), option.getId(), mode.getId(), false);
                }
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
                this.performAction("refresh");
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    public void deactivate() {
        ContractTariffOption option = (ContractTariffOption)this.model.getSelectedRow();
        if (option == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e!");
        } else if (option.getTimeTo() == null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e?", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 0) == 0) {
            try {
                this.getTariffOptionService().contractTariffOptionDeactivate(((ClientContext)this.getContext()).getContractId(), option.getId());
                this.performAction("refresh");
            }
            catch (BGException e) {
                ((ClientContext)this.getContext()).processException(e);
            }
        }
    }

    public void reactivate() {
        ContractTariffOption option = (ContractTariffOption)this.model.getSelectedRow();
        if (option == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e!");
        } else if (option.getTimeTo() != null && option.getDeactivatedTime() != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0440\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e?", "\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 0) == 0) {
            try {
                this.getTariffOptionService().contractTariffOptionReactivate(((ClientContext)this.getContext()).getContractId(), option.getId());
                this.performAction("refresh");
            }
            catch (BGException e) {
                ((ClientContext)this.getContext()).processException(e);
            }
        }
    }

    public int getContractId() {
        return ((ClientContext)this.getContext()).getContractId();
    }

    public void setStandarteActivation(boolean flag) {
        this.standartActivation = flag;
    }

    public BGUComboBox<TariffOptionActivateMode> getTariffOptionModeComboBox() {
        return this.modeComboBox;
    }

    private TariffOptionService getTariffOptionService() {
        if (this.tariffOptionService == null) {
            this.tariffOptionService = ((ClientContext)this.getContext()).getPort(TariffOptionService.class);
        }
        return this.tariffOptionService;
    }

    class ContractTariffOptionTableModel
    extends BGTableModel<ContractTariffOption> {
        public ContractTariffOptionTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", String.class, -1, 150, -1, "optionTitle", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", 150, 150, 200, "timeFrom", false).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", 150, 150, 200, "timeTo", false).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", 180, 180, 180, "summa", true).setTableCellRenderer(DecimalTableCellRenderer.DEFAULT());
        }
    }
}

