/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ru.bitel.common.client.table.AbstractBGTableModel;

class BGUTableColumnVisibility
extends JDialog {
    private final JTable bgTable;
    private final JTable table = new JTable();

    public BGUTableColumnVisibility(JTable table, Window owner) {
        super(owner, "\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0441\u0442\u043e\u043b\u0431\u0446\u043e\u0432", Dialog.ModalityType.MODELESS);
        this.bgTable = table;
        this.initializate(table, owner);
    }

    private void initializate(JTable _table, Window owner) {
        Dimension viewportSize;
        Point p;
        Dimension size = new Dimension(300, 200);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setSize(size);
        this.setDefaultCloseOperation(2);
        Container cont = _table.getParent();
        if (cont instanceof JViewport) {
            p = _table.getLocationOnScreen();
            viewportSize = ((JViewport)cont).getSize();
            this.setLocation(p.x + (viewportSize.width - size.width) / 2, p.y + (viewportSize.height - size.height) / 2);
        } else {
            p = owner.getLocationOnScreen();
            viewportSize = owner.getSize();
            this.setLocation(p.x + (viewportSize.width - size.width) / 2, p.y + (viewportSize.height - size.height) / 2);
        }
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                BGUTableColumnVisibility.this.dispose();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        final DefaultTableModel model = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return Integer.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        };
        this.table.setModel(model);
        model.setColumnCount(3);
        this.table.getColumnModel().getColumn(0).setHeaderValue("N");
        this.table.getColumnModel().getColumn(1).setHeaderValue("");
        this.table.getColumnModel().getColumn(2).setHeaderValue("\u0421\u0442\u043e\u043b\u0431\u0435\u0446");
        this.table.getTableHeader().setVisible(true);
        this.table.getColumnModel().getColumn(0).setMinWidth(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(0);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setMaxWidth(30);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(270);
        this.table.revalidate();
        this.table.repaint();
        AbstractBGTableModel bgModel = null;
        if (this.bgTable.getModel() instanceof AbstractBGTableModel) {
            bgModel = (AbstractBGTableModel)this.bgTable.getModel();
        }
        Enumeration<TableColumn> columns = this.bgTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            String header = (String)column.getHeaderValue();
            if (bgModel != null && bgModel.getColumnMaxWidth(column.getModelIndex()) == 0 && bgModel.isVisible(column.getModelIndex()) || header == null || header.length() == 0) continue;
            Vector<Object> vector = new Vector<Object>();
            vector.add(column.getModelIndex());
            vector.add(column.getPreferredWidth() > 0);
            vector.add(header);
            model.addRow(vector);
        }
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == 1) {
                    int row = e.getFirstRow();
                    if (BGUTableColumnVisibility.this.bgTable.getModel() instanceof AbstractBGTableModel) {
                        AbstractBGTableModel tableModel = (AbstractBGTableModel)BGUTableColumnVisibility.this.bgTable.getModel();
                        int column = (Integer)model.getValueAt(row, 0);
                        TableColumn col = BGUTableColumnVisibility.this.getColumn(column);
                        if (Boolean.FALSE.equals(model.getValueAt(row, 1))) {
                            col.setMinWidth(0);
                            col.setPreferredWidth(0);
                            col.setMaxWidth(0);
                        } else {
                            int width = tableModel.getColumnMaxWidth(column);
                            if (width < 0 || !tableModel.isVisible(column)) {
                                col.setMaxWidth(Integer.MAX_VALUE);
                            } else {
                                col.setMaxWidth(width);
                            }
                            width = tableModel.getColumnMinWidth(column);
                            if (width < 0 || !tableModel.isVisible(column)) {
                                col.setMinWidth(15);
                            } else {
                                col.setMinWidth(width);
                            }
                            width = tableModel.getColumnPrefferedWidth(column);
                            if (!tableModel.isVisible(column)) {
                                width = 100;
                            }
                            col.setPreferredWidth(width);
                        }
                    }
                }
            }
        });
        JScrollPane view = new JScrollPane();
        view.setViewportView(this.table);
        this.setLayout(new GridBagLayout());
        this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)view, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setVisible(true);
    }

    private TableColumn getColumn(int modelIndex) {
        TableColumnModel model = this.bgTable.getColumnModel();
        int size = model.getColumnCount();
        for (int i = 0; i < size; ++i) {
            TableColumn col = model.getColumn(i);
            if (col.getModelIndex() != modelIndex) continue;
            return col;
        }
        return null;
    }
}

