/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import ru.bitel.bgbilling.kernel.tariff.client.tree.FlushableRootTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;

public class TariffTreeRenderer
implements TreeCellRenderer {
    private static final Color unEditableColor = new Color(168, 168, 168);
    private static final Color findColor = new Color(0, 0, 255);
    private static final Color selectionColor = Color.red;
    private static final Color errorColor;
    private static final Color needFlushColor;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = new JLabel("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...");
        boolean wasFind = false;
        boolean isWrong = false;
        boolean needFlush = false;
        if (value instanceof DefaultMutableTreeNode) {
            Object node = ((DefaultMutableTreeNode)value).getUserObject();
            if (node instanceof TariffTreeNode) {
                wasFind = ((TariffTreeNode)node).wasFind();
                comp = ((TariffTreeNode)node).getView();
                isWrong = !((TariffTreeNode)node).checkNode();
                comp.setForeground(((TariffTreeNode)node).getEditable() ? Color.black : unEditableColor);
                if (node instanceof FlushableRootTariffTreeNode) {
                    needFlush = ((FlushableRootTariffTreeNode)node).isNeedFlush();
                }
            } else if (node instanceof JLabel) {
                comp = (JLabel)node;
                comp.setForeground(Color.black);
            }
        }
        if (isWrong) {
            comp.setForeground(errorColor);
        }
        if (selected) {
            comp.setForeground(selectionColor);
        }
        if (wasFind) {
            comp.setForeground(findColor);
        }
        if (needFlush) {
            comp.setForeground(needFlushColor);
        }
        if (comp instanceof JLabel) {
            JLabel label = comp;
            String text = label.getText();
            int max_w = 0;
            FontMetrics fm = label.getFontMetrics(label.getFont());
            Pattern pattern = Pattern.compile("<br>");
            String[] lines = pattern.split(text);
            int lineCount = lines.length;
            for (int i = 0; i < lineCount; ++i) {
                int w = fm.stringWidth(lines[i]);
                if (w <= max_w) continue;
                max_w = w;
            }
            label.setPreferredSize(new Dimension(max_w + 50, 20 + fm.getHeight() * (lineCount - 1)));
        }
        comp.repaint();
        return comp;
    }

    static {
        needFlushColor = errorColor = new Color(255, 100, 0);
    }
}

