/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.contract.ContractParameterTableRow;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;

class MultiRenderer
extends DefaultTableCellRenderer {
    private JCheckBox checkBox = new JCheckBox();

    public MultiRenderer(final JTable parentTable) {
        this.checkBox.setAlignmentX(2.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int itsColumn;
                int itsRow = parentTable.rowAtPoint(mouseEvent.getPoint());
                Object value = parentTable.getValueAt(itsRow, itsColumn = parentTable.columnAtPoint(mouseEvent.getPoint()));
                if (value != null && value.toString().startsWith("http://") && mouseEvent.isControlDown()) {
                    try {
                        ClientUtils.openBrowser(new URI(value.toString()));
                    }
                    catch (Exception e) {
                        ClientUtils.showErrorMessageDialog(e.getMessage());
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int itsColumn;
                int itsRow = parentTable.rowAtPoint(e.getPoint());
                Object value = parentTable.getValueAt(itsRow, itsColumn = parentTable.columnAtPoint(e.getPoint()));
                if (value != null && value.toString().startsWith("http://") && e.isControlDown()) {
                    parentTable.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    parentTable.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String str;
        ContractParameterTableRow row1 = (ContractParameterTableRow)table.getModel().getValueAt(row, 0);
        if (value instanceof Boolean) {
            this.checkBox.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.checkBox.setSelected((Boolean)value);
            return this.checkBox;
        }
        if (row1.getParameterType() == 10) {
            this.setBackground(table.getTableHeader().getBackground());
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        this.setBackground(null);
        String string = str = value == null ? "" : value.toString();
        if (str.startsWith("http://")) {
            String url = "<html><a href=\"" + value.toString() + "\">" + value.toString() + "</a></html>";
            return super.getTableCellRendererComponent(table, url, isSelected, hasFocus, row, column);
        }
        return super.getTableCellRendererComponent(table, str, isSelected, hasFocus, row, column);
    }
}

