/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;

public class ServerCommandWorker {
    private static final String OPEN_CONTRACT_PREFIX = "openContract:";
    private static final int OPEN_CONTRACT_PREFIX_LENGTH = "openContract:".length();

    public static void doCommands(BGClientBase frame, DBInfoManager dbInfoManager) {
        for (DBInfo dbInfo : dbInfoManager.getInfoLists()) {
            if (!dbInfoManager.isAutorized(dbInfo)) continue;
            TransferData transferData = dbInfo.getTransferData();
            Request request = new Request();
            request.setModule("admin");
            request.setAction("Command");
            request.setAttribute("command", "get");
            try {
                int contractId;
                transferData.postData(request);
                Document doc = transferData.getDocument();
                String value = doc.getDocumentElement().getAttribute("value");
                if (!Utils.notBlankString(value) || !value.startsWith(OPEN_CONTRACT_PREFIX) || (contractId = Utils.parseInt(value.substring(OPEN_CONTRACT_PREFIX_LENGTH))) <= 0) continue;
                frame.auth(dbInfo);
                frame.getTabbedPane().addContractEditorTab(contractId);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

