/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class TaskBaseRunner
extends RunTask {
    private int taskId = 0;
    private Date dt = null;
    private String className = null;
    private String params = null;
    private int moduleId;

    public TaskBaseRunner(String className, Date dt, int taskId, String params, int moduleId) throws Exception {
        this.taskId = taskId;
        this.dt = dt;
        this.className = className;
        this.params = params;
        this.moduleId = moduleId;
        if (this.className == null || this.params == null || this.dt == null) {
            throw new Exception("error param");
        }
    }

    @Override
    public String getDescription() {
        try {
            TaskBase task = (TaskBase)Class.forName(this.className).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (task != null) {
                GregorianCalendar time = new GregorianCalendar();
                time.setTime(this.dt);
                task.setExecutingTime(time);
                task.setModuleId(this.moduleId);
                task.initTask(Setup.getSetup(), this.taskId, this.params);
                return task.getDescription();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void executeTask() {
        try {
            TaskBase task = (TaskBase)Class.forName(this.className).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (task != null) {
                this.log = LogManager.getLogger(Class.forName(this.className));
                GregorianCalendar time = new GregorianCalendar();
                time.setTime(this.dt);
                task.setModuleId(this.moduleId);
                task.setExecutingTime(time);
                task.initTask(this.setup, this.taskId, this.params);
                long start = System.currentTimeMillis();
                this.log.info("start task id => " + this.taskId + " at time " + TimeUtils.format((Date)this.dt, (String)"dd.MM.yyyy HH"));
                task.startTask();
                long end = System.currentTimeMillis();
                this.log.info("task time : " + TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
            } else {
                this.log.error("task is null");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
    }

    public String toString() {
        return this.className;
    }
}

