/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.plugin.client;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnDestroyClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnInitClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginManagerBase;
import ru.bitel.common.XMLUtils;

public class BGPluginManagerClient
extends BGPluginManagerBase {
    private static Logger log = LogManager.getLogger();
    private static Map<String, BGPluginClient> allPluginsMap;
    private Map<String, BGPluginClient> enabledPluginsMap = new LinkedHashMap<String, BGPluginClient>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluginsOnServer(Iterable<String> pluginsOnServer) {
        Map<String, BGPluginClient> map = this.enabledPluginsMap;
        synchronized (map) {
            this.enabledPluginsMap.clear();
            this.cacheInvokeablePoints.clear();
            this.cacheExtensionPoints.clear();
            for (String pluginId : pluginsOnServer) {
                if (allPluginsMap.containsKey(pluginId)) {
                    this.enablePlugin(pluginId);
                    continue;
                }
                System.out.println("WARNING: \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u041f\u043b\u0430\u0433\u0438\u043d " + pluginId + " \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u0432 \u0441\u0435\u0440\u0432\u0435\u0440\u0435, \u043d\u043e \u0435\u0433\u043e jar \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043a\u043b\u0438\u0435\u043d\u0442\u0435!");
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "WARNING: \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u041f\u043b\u0430\u0433\u0438\u043d " + pluginId + " \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u0432 \u0441\u0435\u0440\u0432\u0435\u0440\u0435, \u043d\u043e \u0435\u0433\u043e jar \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043a\u043b\u0438\u0435\u043d\u0442\u0435!");
            }
        }
    }

    public void enablePlugin(String pluginId) {
        this.enabledPluginsMap.put(pluginId, allPluginsMap.get(pluginId));
    }

    public void disablePlugin(String pluginId) {
        this.enabledPluginsMap.remove(pluginId);
        this.cacheInvokeablePoints.clear();
    }

    public static final BGPluginManagerClient getManager() {
        if (ourInstance == null) {
            ourInstance = new BGPluginManagerClient();
        }
        return (BGPluginManagerClient)ourInstance;
    }

    public static void init() throws BGException {
        if (allPluginsMap == null) {
            allPluginsMap = new HashMap<String, BGPluginClient>();
            for (URL pluginUrl : BGPluginManagerClient.getPlugins()) {
                if (log.isDebugEnabled()) {
                    log.debug("plugin: " + pluginUrl);
                }
                try {
                    BGPluginClient plugin = new BGPluginClient();
                    InputStream inputStream = pluginUrl.openStream();
                    if (inputStream != null) {
                        plugin.setDocument(XMLUtils.parseDocument((InputSource)new InputSource(inputStream)));
                    }
                    plugin.setResourceBundle(ResourceBundle.getBundle(plugin.getId() + ".plugin"));
                    allPluginsMap.put(plugin.getId(), plugin);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("plugin " + plugin.getId() + " load");
                }
                catch (Exception ex) {
                    throw new BGException("error plugin " + pluginUrl.toString() + " load", (Throwable)ex);
                }
            }
        }
    }

    public <T> Collection<BGPluginClient> getPluginsForInvokeablePoints(Class<T> point) {
        return point == OnInitClient.class || point == OnDestroyClient.class ? allPluginsMap.values() : this.enabledPluginsMap.values();
    }

    @Override
    public BGPluginClient getPlugin(String id) {
        return this.enabledPluginsMap.get(id);
    }

    public Map<String, BGPluginClient> getPluginsMap() {
        return this.enabledPluginsMap;
    }
}

