/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.task;

import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class ContractCleaner
extends TaskBase {
    private int _max_by_close = 10;
    private int _max_by_balance = 10;
    private String _email;
    private String _folder = "/";
    private Connection con;
    private Connection conSlave;

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432.";
    }

    @Override
    protected boolean initTask() {
        this._max_by_close = this.taskSetup.getInt("max_closed", this._max_by_close);
        this._max_by_balance = this.taskSetup.getInt("max_balance", this._max_by_balance);
        this._email = this.taskSetup.get("email", this._email);
        this._folder = this.taskSetup.get("folder", this._folder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTask() {
        this.con = this.setup.getDBConnectionFromPool();
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        try (ContractRemover remover = new ContractRemover(this.con, this._folder);){
            ResultSet rsRule;
            Vector<Integer> cids = new Vector<Integer>();
            String query = "SELECT time, gr, params FROM contract_delete_time WHERE ( ISNULL(date2) OR date2 >= CURDATE() ) AND ( ISNULL(date1) OR date1 <= CURDATE()  )";
            try (PreparedStatement psSelectRulesTime = this.conSlave.prepareStatement(query);){
                rsRule = psSelectRulesTime.executeQuery();
                try {
                    cids.addAll(this.deleteByClose(rsRule));
                }
                finally {
                    if (rsRule != null) {
                        rsRule.close();
                    }
                }
            }
            query = "SELECT time, gr, money, params FROM contract_delete_money WHERE ( ISNULL(date2) OR date2 >= CURDATE() ) AND ( ISNULL(date1) OR date1 <= CURDATE()  )";
            try (PreparedStatement psSelectRulesMoney = this.conSlave.prepareStatement(query);){
                rsRule = psSelectRulesMoney.executeQuery();
                try {
                    cids.addAll(this.deleteByBalance(rsRule));
                }
                finally {
                    if (rsRule != null) {
                        rsRule.close();
                    }
                }
            }
            ContractUtils cu = new ContractUtils(this.con);
            StringBuffer msg = new StringBuffer();
            for (Integer cid : cids) {
                msg.append("\n");
                msg.append(cu.getContractTitle(cid, true));
            }
            if (this._email != null && msg.length() > 0) {
                new MailMsg(this.setup).sendMessage(this._email, "These contracts were deleted!", msg.toString());
            }
            this.log.info("Removing " + cids);
            remover.removeContracts(cids, true);
        }
        catch (Exception e1) {
            this.log.error(e1.getMessage(), (Throwable)e1);
        }
        finally {
            ServerUtils.closeConnection(this.con, this.conSlave);
        }
    }

    private Vector<Integer> deleteByClose(ResultSet rsRules) throws SQLException {
        Vector<Integer> cids = new Vector<Integer>();
        while (rsRules.next()) {
            Object query = "SELECT id FROM contract WHERE !(date2 is NULL) && date2 < date_sub(curdate(), interval ? month) AND gr&?>0 AND scid=0";
            String statuses = this.getStatuses(this.getParamsMap(rsRules.getString("params")).get("statuses"));
            if (Utils.notBlankString((String)statuses)) {
                query = (String)query + " AND status IN ( " + statuses + ")";
            }
            query = (String)query + " ORDER BY title";
            long gr = rsRules.getLong("gr");
            int months = rsRules.getInt("time");
            PreparedStatement ps = this.conSlave.prepareStatement((String)query);
            try {
                ps.setInt(1, months);
                ps.setLong(2, gr);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    cids.add(rs.getInt(1));
                    if (cids.size() <= this._max_by_close) continue;
                }
                rs.close();
            }
            finally {
                if (ps == null) continue;
                ps.close();
            }
        }
        return cids;
    }

    private Vector<Integer> deleteByBalance(ResultSet rsRules) throws SQLException {
        Vector<Integer> cids = new Vector<Integer>();
        int count = 0;
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            block5: while (rsRules.next()) {
                long gr = rsRules.getLong("gr");
                float money = rsRules.getFloat("money");
                int timeCount = rsRules.getInt("time");
                Map<String, String> params = this.getParamsMap(rsRules.getString("params"));
                String statuses = this.getStatuses(params.get("statuses"));
                int periodType = Utils.parseInt((String)params.get("typePeriod"), (int)0);
                String periodSql = periodType < 1 ? "MONTH" : "DAY";
                String query = "SELECT id FROM contract WHERE (( date1 IS NULL ) OR DATE_ADD( date1, INTERVAL ? " + periodSql + " )<=NOW()) AND scid=0";
                if (gr > 0L) {
                    query = query + " AND gr&?>0 ";
                }
                if (Utils.notBlankString((String)statuses)) {
                    query = query + " AND status IN ( " + statuses + ")";
                }
                PreparedStatement ps = this.conSlave.prepareStatement(query);
                ps.setInt(1, timeCount);
                if (gr > 0L) {
                    ps.setLong(2, gr);
                }
                ResultSet rsCidFromGroups = ps.executeQuery();
                int months = timeCount;
                if (periodType == 1) {
                    Calendar from = (Calendar)this.getOperatingTime().clone();
                    from.add(6, -timeCount);
                    Calendar to = (Calendar)this.getOperatingTime().clone();
                    months = to.get(2) + 12 * to.get(1) - (from.get(2) + 12 * from.get(1));
                }
                while (rsCidFromGroups.next()) {
                    int cid = rsCidFromGroups.getInt(1);
                    if (!(bu.getBalance(this.getOperatingTime().getTime(), cid).floatValue() <= money)) continue;
                    boolean delete = true;
                    Calendar time = (Calendar)this.getOperatingTime().clone();
                    int i = 0;
                    do {
                        time.add(2, -i);
                        if (!bu.wasMoveByAccount(time, cid)) continue;
                        delete = false;
                        break;
                    } while (++i < months);
                    if (!delete) continue;
                    cids.add(cid);
                    if (++count <= this._max_by_balance) continue;
                    continue block5;
                }
            }
        }
        return cids;
    }

    private Map<String, String> getParamsMap(String params) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (Utils.notBlankString((String)params)) {
            StringTokenizer st = new StringTokenizer(params, "\r\n");
            while (st.hasMoreTokens()) {
                String keyValue = st.nextToken();
                if (!keyValue.contains("=")) continue;
                String[] values = keyValue.split("=");
                paramsMap.put(values[0], values[1]);
            }
        }
        return paramsMap;
    }

    private String getStatuses(String statuses) {
        if (Utils.isBlankString((String)statuses)) {
            return null;
        }
        return Utils.toString((Iterable)Utils.toIntegerSet((String)statuses));
    }
}

