/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.common.service.ContractParameterServiceOld;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class LoaderBase {
    protected ServerContext context = (ServerContext)ServerContext.get();
    protected Setup setup = Setup.getSetup();
    protected Connection con = this.setup.getDBConnection();
    private EntityService entityService = null;
    private ContractService contractService = null;
    private ContractParameterService contractParameterService = null;
    private ContractParameterServiceOld contractParameterService2 = null;

    protected LoaderBase() {
    }

    protected EntityService getEntityService() throws BGException {
        if (this.entityService == null) {
            this.entityService = this.context.getService(EntityService.class, 0);
        }
        return this.entityService;
    }

    protected ContractService getContractService() throws BGException {
        if (this.contractService == null) {
            this.contractService = this.context.getService(ContractService.class, 0);
        }
        return this.contractService;
    }

    protected ContractParameterService getContractParameterService() throws BGException {
        if (this.contractParameterService == null) {
            this.contractParameterService = this.context.getService(ContractParameterService.class, 0);
        }
        return this.contractParameterService;
    }

    protected ContractParameterServiceOld getContractParameterService2() throws BGException {
        if (this.contractParameterService2 == null) {
            this.contractParameterService2 = this.context.getService(ContractParameterServiceOld.class, 0);
        }
        return this.contractParameterService2;
    }

    protected void deleteParameter(int parameterId) throws Exception {
        String tableName = this.getTableName(parameterId);
        if (tableName != null) {
            PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + tableName + " WHERE pid=?");
            psDelete.setInt(1, parameterId);
            psDelete.executeUpdate();
            psDelete.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getTableName(int parameterId) throws Exception {
        String tableName = null;
        try (ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(this.con);){
            ContractParameterGroupAttr contractParameterGroupAttr = (ContractParameterGroupAttr)contractParameterGroupAttrDao.get(parameterId);
            switch (contractParameterGroupAttr.getType()) {
                case 1: {
                    tableName = ContractParameterPrefType.getType(1).getTableName();
                    return tableName;
                }
                case 5: {
                    tableName = ContractParameterPrefType.getType(6).getTableName();
                    return tableName;
                }
            }
            return tableName;
        }
    }
}

